<?php
/**
* Template part for displaying posts
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package monal
*/

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="container">
        <div class="glamour-pagewrapper">
            <section class="blog-heading-1">
                <div class="glamour-blog-desection">
                    <div class="container">
                        <div class="custholder">
                            <?php if (get_theme_mod('enable_sidebar_option_single_post', 1) == 1){
                                $full = "cust-bio-left";
                                $wid = "side";
                                $center = "text-normal";
                            } else {
                                $full = "cust-bio-full";
                                $wid = "blog-no-sidebar";
                                $center = "text-center";
                            }?>
                            <div class="<?php echo esc_attr($full); ?>">
                                <div class="blog-wrap">
                                    <div class="<?php echo esc_attr($center); ?>">
                                        <?php monal_breadcrumb(); ?>
                                        <?php $categories = get_the_category();
                                        if($categories){
                                            $page_category = $categories[0]->name;    
                                        }
                                        ?>
                                        <div class="upper-blog-heading">
                                            <?php
                                        if ( ! empty( $categories ) ) {?>
                                            <?php 
                                        foreach( $categories as $category ) {
                                        ?>
                                            <a href="<?php echo esc_url( get_category_link( $category->term_id ) ) ?>">
                                                <p class=" blog-main-category">
                                                    <?php echo esc_html( $category->name );  ?>
                                                </p>
                                            </a>
                                            <?php
                                    }
                                        ?>



                                            <?php
                                                }
                                                ?><h1 class="blog-heading"><?php the_title(); ?>
                                            </h1>
                                            <div class="entry-meta">
                                                <?php if(get_the_modified_date('M j, Y') == get_the_date('M j, Y'))
                                                        {
                                                        ?>
                                                <i class="fa fa-calendar"></i>
                                                <?php 
                                                echo "Posted on ".get_the_date('M j, Y').", ";
                                            ?>
                                                <i class="fa fa-user"></i><?php the_author() ?>
                                                <?php
                                                        } else {
                                                        ?>
                                                <i class="fa fa-calendar"></i>
                                                <?php 
                                                echo "Posted on ".get_the_date('M j, Y').", ";
                                            ?>
                                                <?php 
                                                echo "Modified : ".get_the_modified_date('M j, Y')." ";
                                            ?>
                                                <i class="fa fa-user"></i><?php the_author() ?>
                                                <?php } ?>
                                            </div><!-- .entry-meta -->
                                        </div>
                                    </div>
                                    <?php 
                                        if(get_the_post_thumbnail_url()){
                                    ?>
                                    <div class="blog-img"><?php the_post_thumbnail(); ?> </div>
                                    <?php
                                        }
                                    ?>
                                    <div class=" blog-content-seperate <?php echo esc_attr($wid); ?>">
                                        <div class="main-content">
                                            <div class="glamour-blog-content">
                                                <?php the_content(); 
                                                $post_tags = get_the_tags();
                                                if ( $post_tags ) {
                                                    ?>
                                                <div class="glamour-side-heading-blog">
                                                    <h2 class="prime-color-text" style="display:block">
                                                        <?php esc_html_e('Tags', 'monal')?>
                                                    </h2>
                                                </div>
                                                <ul class="glamour-tags-blog">
                                                    <?php
                                                    foreach( $post_tags as $single_tag ) {
                                                    echo '<li><a href="'. get_tag_link($single_tag->term_id) .'"> '. $single_tag->name.'</a></li>';
                                                    }
                                                }
                                                ?>
                                            </div>
                                            <?php
                                            wp_link_pages( array(
                                                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'monal' ),
                                                'after'  => '</div>',
                                            ));
                                            the_post_navigation();
                                            ?>
                                        </div>

                                    </div>
                                    <div class="<?php echo esc_attr($wid); ?>">
                                        <?php                 
                                    // If comments are open or we have at least one comment, load up the comment template.
                                    if ( comments_open() || get_comments_number() ) :
                                        comments_template();
                                    endif;
                                    ?>
                                    </div>

                                </div>
                                <!-- BLOG WRAP  -->

                            </div>
                            <?php
                            if (get_theme_mod('enable_sidebar_option_single_post', 1) == 1){
                                get_sidebar();	
                            }?>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <div class="heading">
            <h2>
                Others
            </h2>
        </div>
        <div class="custholder monal-posts-container ">
            <?php             
            $args = array(
                'post_type' => 'post',
                'posts_per_page' => get_option( 'posts_per_page' ),
                'order_by' => 'date',
                'post_status' => 'publish',
                'order' => 'DESC',
            );
            $bio = new WP_Query( $args );
                if( $bio->have_posts() ) {
                    while( $bio->have_posts() ) {
                        $bio->the_post();
				?>
            <div class="custcol-4">
                <div class="slider-gridcont post-margin-cust reveal">
                    <div class="slider-celeb">
                        <a href="<?php the_permalink(); ?>">
                            <div class="slider-container image-height">
                                <?php 
                                    if(get_the_post_thumbnail_url()){
                                        the_post_thumbnail('medium');
                                    }
                                    ?>
                                <div class="slider-desc">
                                    <h2> <?php the_title() ?> </h2>
                                    <small> <?php esc_html_e('By: ', 'monal')?> <?php the_author() ?> <i
                                            class="fa fa-calendar"></i><?php echo get_the_date('M j, Y')?></small>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
            <?php
                }
            }
            ?>
        </div>
        <div class="center">
            <button style="" class="btn monal-load-more" data-page="1"
                data-url="<?php echo admin_url('admin-ajax.php'); ?>" data-pagetype="singlepage"
                data-category="<?php if($page_category){echo $page_category;} ?>"><i class="fa fa-spinner"></i> <span
                    class="text">
                    <?php esc_html_e('Load More', 'monal')?> </span>
            </button>
        </div>

    </div>


</article><!-- #post-<?php the_ID(); ?> -->