<?php 
 
// ===================== 
//     AJAX FUNCTIONS
// ===================== 


add_action('wp_ajax_nopriv_monal_load_more', 'monal_load_more');
add_action('wp_ajax_monal_load_more', 'monal_load_more');

function monal_load_more(){
    // this page comes from the js type : post
    $paged = $_POST["page"] + 1;
    $categ = $_POST["category"];    
    $post_per_pages =  get_option( 'posts_per_page' );
    $query = new WP_Query( array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'paged' => $paged,
        'order_by' => 'date',
        'order' => 'DESC',
        'post_per_page' => $post_per_pages,
        'category_name' => $categ
    ));
    if ($query->have_posts() ):
        while($query->have_posts()) : $query->the_post();
        ?>

<div class="custcol-4">
    <div class="slider-gridcont post-margin-cust">
        <div class="slider-celeb">
            <a href="<?php the_permalink(); ?>">
                <div class="slider-container image-height <?php echo $categ;?>">
                    <?php 
                            if(get_the_post_thumbnail_url()){
                                the_post_thumbnail();
                            }
                            ?>
                    <div class="slider-desc">

                        <h2> <?php the_title() ?> </h2>

                        <small> <?php esc_html_e('By: ', 'monal')?> <?php the_author() ?> <i
                                class="fa fa-calendar"></i><?php echo get_the_date('M j, Y')?>
                        </small>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>

<?php

    endwhile;
endif;
    
    die();
}


add_action('wp_ajax_nopriv_monal_load_more_home', 'monal_load_more_home');
add_action('wp_ajax_monal_load_more_home', 'monal_load_more_home');

function monal_load_more_home(){
    // this page comes from the js type : post
    $paged = $_POST["page"] + 1; 
    $catego = $_POST["category"];       
    $query = new WP_Query( array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'paged' => $paged,
        'order_by' => 'date',
        'order' => 'DESC',
        'category_name' => $catego,
    ));
    if ($query->have_posts() ):
        while($query->have_posts()) : $query->the_post();
        ?>

<div class="glamcol-6">
    <div class="glamour-flex orders">
        <div class="glam-image">
            <?php
                        if(get_the_post_thumbnail_url()){
                            the_post_thumbnail(); 
                        }
                        ?>
        </div>
        <div class="glam-details">

            <?php 
                                    $categories = get_the_category();
                                    if ( ! empty( $categories ) ) {
                                        ?>
            <p class="glam-category prime-color-text">
                <?php echo esc_html( $categories[0]->name );  ?>
            </p>
            <?php
                                        
                                    }
                                    ?>
            <h2> <?php the_title(); ?> </h2>
            <span> <i class="fa fa-user prime-color-text"></i> <?php the_author(); ?> <i
                    class="fa fa-calendar prime-color-text"></i>
                <?php echo get_the_date('M j, Y')?>
            </span>
            <a href="<?php the_permalink();?>">
                <div class="button-read prime-color prime-text"> <?php esc_html_e('Read More', 'monal')?> </div>
            </a>
        </div>
    </div>
</div>

<?php

    endwhile;
endif;
    
    die();
}