<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package monal
 */

get_header();
?>

<main id="primary" class="site-main container ">
    <div class="custholder margin-30">
        <div class="cust-bio-left">

            <?php if ( have_posts() ) : ?>

            <header class="page-header">
                <h1 class="page-title">
                    <?php
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'monal' ), '<span>' . get_search_query() . '</span>' );
					?>
                </h1>
            </header><!-- .page-header -->

            <?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();
				get_template_part( 'template-parts/content', get_post_type() );

			endwhile;
?>
            <div class=" page-nav">
                <?php
		the_posts_pagination( array(
			'mid_size'  => 2,
			'prev_text' => __( 'Previous', 'monal' ),
			'next_text' => __( 'Next', 'monal' ),
		) );
		?>

            </div>
            <?php
		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>
        </div>

        <?php get_sidebar() ?>
    </div>

</main><!-- #main -->

<?php

get_footer();