<?php
/**
 * monal Theme Customizer
 *
 * @package monal
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function monal_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'monal_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'monal_customize_partial_blogdescription',
			)
        );
        // Add "display_title_and_tagline" setting for displaying the site-title & tagline.
			$wp_customize->add_setting(
				'display_title_tagline',
				array(
					'capability'        => 'edit_theme_options',
					'default'           => true,
					'sanitize_callback' => 'monal_sanitize_checkbox',
				)
			);

			// Add control for the "display_title_and_tagline" setting.
			$wp_customize->add_control(
				'display_title_tagline',
				array(
					'type'    => 'checkbox',
					'section' => 'title_tagline',
					'label'   => esc_html__( 'Display Site Title & Tagline', 'monal' ),
				)
			);
	}
}
add_action( 'customize_register', 'monal_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function monal_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function monal_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function monal_customize_preview_js() {
	wp_enqueue_script( 'monal-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), MONAL_VERSION, true );
}
add_action( 'customize_preview_init', 'monal_customize_preview_js' );




// Sanitization
require_once get_template_directory().'/custom-customizer/sanitize-customizer.php';


// Custom Customizer
function monal_extra_register($wp_customize){
    require_once get_template_directory().'/custom-customizer/general-settings.php';
    require_once get_template_directory().'/custom-customizer/theme-options.php';

}
add_action('customize_register', 'monal_extra_register');



// CSS HOOK 
add_action('wp_head', 'monal_customizer_css');
function monal_customizer_css(){
	$primeColor =  esc_attr(get_theme_mod('primary_color', '#0bc615'));
	$primeColorInsideText = esc_attr(get_theme_mod('text_inside_primary_color', '#ffffff'));
	$headerTextColor = esc_attr(get_theme_mod('header_text_color', '#000000'));
	$headerBackgroundColor = esc_attr(get_theme_mod('header_background', '#ffffff'));
    $footerBackgroundColor = esc_attr(get_theme_mod('footer_background_color', '#484848'));
    $copyrightBackgroundColor = esc_attr(get_theme_mod('copyright_background', '#000000'));
    $bckgcolor = esc_attr(get_theme_mod('bodybg_color', '#ffffff'));
	?>
<style>
.search-right .entry-meta a:hover,
a:hover {
    color: <?php echo $primeColor;
    ?>;
}

a:visited :hover {
    color: <?php echo $primeColor;
    ?>;
}

a:hover,
a:visited:hover {
    color: <?php echo $primeColor;
    ?>;
}


.navwhite,
.nav-menu {
    background: <?php echo $headerBackgroundColor;
    ?> !important;
}

.page_item_has_children::after,
.menu-item-has-children::after {
    color: <?php echo $headerTextColor;
    ?> !important;
}

.main-navigation a,
.site-title,
.site-description,
.menu-toggle,
.bot-nav .bot-search i,
.site-title a {
    color: <?php echo $headerTextColor;
    ?>;
}

.line {
    stroke: <?php echo $headerTextColor ?>;
}



.bars {
    color: <?php echo $headerTextColor;
    ?> !important;
}


.posted-on::before,
.tags-links::before,
.by-line::before,
.cat-links::before,
.main-navigation a:hover {
    color: <?php echo $primeColor;
    ?>;
}

.menu-container {
    background: <?php echo $headerBackgroundColor ?> !important;
}

.home-bt {
    background: <?php echo $primeColor;
    ?> !important;
}

.main-navigation ul ul li {
    background: <?php echo esc_attr(get_theme_mod('dropdown_background', '#f3f3f3'));
    ?>;
    color: <?php echo esc_attr(get_theme_mod('dropdown_color', '#000000'));
    ?>;
}

.main-navigation ul ul li a {
    color: <?php echo esc_attr(get_theme_mod('dropdown_color', '#000000'));
    ?>;
}


.posted-on::before,
.tags-links::before,
.byline::before,
.cat-links::before {
    color: <?php echo $primeColor;
    ?> !important;
}

.site-footer {
    background: <?php echo $footerBackgroundColor;
    ?> !important;
}

.copyright {
    background: <?php echo $copyrightBackgroundColor;
    ?> !important;
}

.widget-title span,
body {
    background: <?php echo $bckgcolor;
    ?> !important;
}

.search-submit,
.form-submit .submit {
    background: <?php echo $primeColor;
    ?> !important;
}

.navwhite .bot-nav .menu-class ul li a {
    color: <?php echo $headerTextColor;
    ?> !important;
}

.navwhite .bot-nav .bot-search i {
    color: <?php echo $headerTextColor;
    ?> !important;
}

.heading h2::before,
.heading h2::after {
    background: <?php echo $primeColor;
    ?> !important;
}

.monal-load-more,
.page-nav .page-numbers {
    background: <?php echo $primeColor;
    ?> !important;
    color: <?php echo $primeColorInsideText;
    ?> !important;
}

.prime-color {
    background: <?php echo $primeColor;
    ?> !important;
    border-color: <?php echo $primeColor;
    ?> !important;
}

.widget-title,
.entry-meta i {
    color: <?php echo $primeColor;
    ?> !important;
}


.widget ul li a:hover {
    color: <?php echo $primeColor;
    ?> !important;
}

.prime-color-ba::before,
.prime-color-ba::after,
.widget-title::before {
    background: <?php echo $primeColor;
    ?> !important;
}

.prime-color-text {
    color: <?php echo $primeColor;
    ?> !important;
}

.prime-text {
    color: <?php echo $primeColorInsideText;
    ?> !important;
}

.glamour-sideblog-newsletter .wpcf7-submit {

    background: <?php echo $primeColor;
    ?> !important;
    color: <?php echo $primeColorInsideText;
    ?> !important;
}

.blog-main-category {
    background: <?php echo $primeColor ?> !important;
    color: <?php echo $primeColorInsideText ?> !important;
}

/* Typography Options */

h1 {
    font-size: <?php echo esc_attr(get_theme_mod('heading_one_size', '32'));
    ?>px;
}

h2 {
    font-size: <?php echo esc_attr(get_theme_mod('heading_two_size', '24'));
    ?>px;
}

h3 {
    font-size: <?php echo esc_attr(get_theme_mod('heading_three_size', '20'));
    ?>px;
}

h4 {
    font-size: <?php echo esc_attr(get_theme_mod('heading_four_size', '18'));
    ?>px;
}

p {
    font-size: <?php echo esc_attr(get_theme_mod('paragraph_size', '16'));
    ?>px;
}

.entry-meta,
.tags-links {
    font-size: <?php echo esc_attr(get_theme_mod('meta_size', '14'));
    ?>px;
}
</style>
<?php
}