<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package monal
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'monal' ); ?></a>

        <?php 
                $containerClass = "";
        if (get_theme_mod('navbar_select', 'box') == 'box'){
            $containerClass = "container";
        } else if (get_theme_mod('navbar_select', 'box') == 'fullwidth'){
            $containerClass = "no-container";
        }
        ?>
        <header id="masthead" class="site-header">
            <nav style="position: relative" id="site-navigation" class="main-navigation">
                <div class="abs navwhite">
                    <div class="<?php echo $containerClass; ?>">
                        <div class="bot-nav">
                            <div class="bot-logo">
                                <?php if ( has_custom_logo() ) :
                                the_custom_logo();
                                endif; 
                            ?>
                                <div class="site-title-wrapper">
                                    <?php
                                    if (get_theme_mod( 'display_title_tagline', true ) ) {
                                        if ( is_front_page() || is_home() ) : ?>
                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"
                                            rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                                    <?php else : ?>
                                    <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"
                                            rel="home"><?php bloginfo( 'name' ); ?></a></p>
                                    <?php
                                        endif;                    
                                        $description = get_bloginfo( 'description', 'display' );
                                        if ( $description || is_customize_preview() ) : ?>
                                    <p class="site-description">
                                        <?php echo esc_html($description); /* WPCS: xss ok. */ ?></p>
                                    <?php
                                        endif; 
                                    }
					?>
                                </div>
                            </div>
                            <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"
                                onclick="monal_hamburger(this)" aria-label=" Main Menu" id="hamburger-menu">
                                <svg width="20" height="20" viewBox="0 0 100 100">
                                    <path class="line line1"
                                        d="M 20,29.000046 H 80.000231 C 80.000231,29.000046 94.498839,28.817352 94.532987,66.711331 94.543142,77.980673 90.966081,81.670246 85.259173,81.668997 79.552261,81.667751 75.000211,74.999942 75.000211,74.999942 L 25.000021,25.000058" />
                                    <path class="line line2" d="M 20,50 H 80" />
                                    <path class="line line3"
                                        d="M 20,70.999954 H 80.000231 C 80.000231,70.999954 94.498839,71.182648 94.532987,33.288669 94.543142,22.019327 90.966081,18.329754 85.259173,18.331003 79.552261,18.332249 75.000211,25.000058 75.000211,25.000058 L 25.000021,74.999942" />
                                </svg>
                            </button>
                            <div class="menu-container" tabindex="-1">
                                <button class="menu-close-btn opened" id="close-menu" onclick="menu_close()"><svg
                                        width="20" height="20" viewBox="0 0 100 100">
                                        <path class="line line1"
                                            d="M 20,29.000046 H 80.000231 C 80.000231,29.000046 94.498839,28.817352 94.532987,66.711331 94.543142,77.980673 90.966081,81.670246 85.259173,81.668997 79.552261,81.667751 75.000211,74.999942 75.000211,74.999942 L 25.000021,25.000058">
                                        </path>
                                        <path class=" line line2" d="M 20,50 H 80"></path>
                                        <path class="line line3"
                                            d="M 20,70.999954 H 80.000231 C 80.000231,70.999954 94.498839,71.182648 94.532987,33.288669 94.543142,22.019327 90.966081,18.329754 85.259173,18.331003 79.552261,18.332249 75.000211,25.000058 75.000211,25.000058 L 25.000021,74.999942">
                                        </path>
                                    </svg>
                                </button>
                                <?php   
                            if ( has_nav_menu( 'menu-1' ) ) {
                            wp_nav_menu(
                                array(
                                    'theme_location' => 'menu-1',
                                    'menu_id'        => 'primary-menu',
                                )
                            );
                            } else {
                            wp_nav_menu(
                                array(
                                    'container_id'        => 'primary-menu',
                                    'menu_class' => 'nav-menu',
                                    'container_class' => 'menu-short-container',
                                )
                            );
                        }                
                            ?>
                            </div>
                            <button class="bot-search" id="search-open" onclick="monal_searchshow()">
                                <i class="fa fa-search"></i>
                            </button>
                            <div class="search-glam" id="search-show" tabindex="-1">
                                <div class="container">
                                    <div class="search-query">
                                        <form role="search" method="get" class="search-form"
                                            action="<?php echo esc_url(home_url()); ?>">

                                            <label>
                                                <span
                                                    class="screen-reader-text"><?php esc_html_e('Search For: ', 'monal'); ?></span>
                                                <input type="search" id="search-input" class="search-field"
                                                    placeholder="<?php esc_attr_e( 'Search','monal'); ?>"
                                                    value="<?php echo get_search_query(); ?>" name="s">
                                            </label>

                                        </form>
                                        <button class="cross" onclick="monal_searchremove()">
                                            <i class="fa fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </nav>
        </header><!-- #masthead -->