<?php
// Register and load the widget
function monal_load_slider_widget() {
    register_widget( 'monal_slider_widget' );
}
add_action( 'widgets_init', 'monal_load_slider_widget' );
//  CUSTOM WIDGET ----------------------------------------------------------------------------------------------------------------------------================================================ 
// Creating the widget 
class monal_slider_widget extends WP_Widget {
    
    //Setup The Widget Name, Description, etc ...
function __construct() { //gets executed immediately at the beginning

parent::__construct(
// Base ID of your widget
'monal_slider_widget', 
 
// Widget name will appear in UI
__('Monal Slider', 'monal'), 
 
// Widget description
array( 'description' => __( 'Monal Slider Details', 'monal' ))
);
}

// Creating widget front-end

public function widget( $args, $instance ) {
    
        $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance['dorecent_category'] : '' ;
        $dorecent_number = ( !empty($instance[ 'dorecent_number' ])) ? $instance['dorecent_number'] : '4' ;
        $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance['dorecent_order'] : esc_html__( 'DESC', 'monal' ) ;
        $title = ( !empty($instance[ 'title' ])) ? $instance['title'] : '' ;
        echo $args['before_widget'];
    ?>
<div class="glamour-sidebar-blog-container">
    <?php if ($title) :?>
    <h2 class="widget-title"><span class="title"><?php echo esc_html($title); ?></span></h2>
    <?php endif;?>

    <div class="glide" id="intro" data-typeId="<?php echo esc_html($dorecent_number); ?>">
        <div data-glide-el="track" class="glide__track">
            <div class="glide__slides">
                <?php             
        $q_args = array(
            'post_type' => 'post',
            'posts_per_page' => 12,
            'post_status' => 'publish',
            'order_by' => 'date',
			'order' => 'DESC',
            'category_name' => esc_attr($dorecent_category),
        );
		?>
                <?php 
            $slider = new WP_Query( $q_args );
                if($slider->have_posts()){
            ?>

                <?php
                }
                ?>
                <?php      
                if( $slider->have_posts() ) {
                    while( $slider->have_posts() ) {
                        $slider->the_post();
                ?>
                <div class="glide__slide">
                    <a href="<?php echo the_permalink() ?>">
                        <div class="slider-container">
                            <?php
                                if(get_the_post_thumbnail_url()){
                                    the_post_thumbnail();
                                }
                            ?>
                            <div class="slider-cat prime-color prime-text">
                                <?php 
                                    $categories = get_the_category();
                                    if ( ! empty( $categories ) ) {
                                        echo esc_html( $categories[0]->name );   
                                    }
                                    ?>
                            </div>
                            <div class="slider-desc">
                                <h2> <?php the_title(); ?> </h2>
                                <small><?php esc_html_e('By: ', 'monal'); the_author(); ?> <i
                                        class="fa fa-calendar"></i><?php echo get_the_date('M j, Y')?></small>
                            </div>

                        </div>
                    </a>
                </div>
                <?php
                                        }
                                    }
                                    ?>

            </div>

            <div class="glide__arrows" data-glide-el="controls">
                <button class="glide__arrow glide__arrow--left" data-glide-dir="<"><i
                        class="fa fa-chevron-left prime-color-text"></i></button>
                <button class="glide__arrow glide__arrow--right" data-glide-dir=">"><i
                        class="fa fa-chevron-right prime-color-text"></i></button>
            </div>
        </div>
    </div>
</div>


<?php
		echo $args['after_widget'];
}

// Widget Backend 
public function form( $instance ) {

    $dorecent_category = ( !empty($instance[ 'dorecent_category' ])) ? $instance[ 'dorecent_category' ] : '' ;
    $dorecent_number = ( !empty($instance[ 'dorecent_number' ])) ? $instance[ 'dorecent_number' ] : '4' ;
    $dorecent_order = ( !empty($instance[ 'dorecent_order' ])) ? $instance[ 'dorecent_order' ] : esc_html__( 'DESC', 'monal' );
    $title = ( !empty($instance[ 'title' ])) ? $instance[ 'title' ] : '' ;

// Widget admin form
?>

<p>
    <label
        for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'The Title of the Widget', 'monal' ); ?></label>

    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
        name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_number' ); ?>"><?php esc_html_e( 'Number of slides', 'monal' ); ?></label>
    <input class="widefat" type="number" min="1" max="4" id="<?php echo $this->get_field_id( 'dorecent_number' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_number' ); ?>" type="text"
        value="<?php echo esc_attr( $dorecent_number ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"><?php esc_html_e( 'Ordering: Either Ascending or Desending order', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_order' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_order' ); ?>"
        value="<?php echo esc_attr( $dorecent_order ); ?>">
        <option value="ASC" <?php echo ($dorecent_order=='ASC')?'selected':''; ?>>
            <?php esc_html_e( 'Ascending Order', 'monal' ) ?>
        </option>
        <option value="DESC" <?php echo ($dorecent_order=='DESC')?'selected':''; ?>>
            <?php esc_html_e( 'Descending Order', 'monal' ) ?>
        </option>
    </select>
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"><?php  esc_html_e( 'Select the category:', 'monal' ); ?></label>
    <select class="widefat" id="<?php echo $this->get_field_id( 'dorecent_category' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_category' ); ?>">

        <?php  
                $ag = array(
                    'post_type' => 'post',
                );
                $all_categories = get_categories( $ag );
                foreach ($all_categories as $cat) {    
                    ?>
        <option value="<?php echo $cat->slug;?>" <?php echo ($dorecent_category == $cat->slug)?'selected':''; ?>>
            <?php echo $cat->name;?></option>
        <?php
                }
                
?>
    </select>
</p>

<?php 
}
    //  CUSTOM WIDGET ----------------------------------------------------------------------------------------------------------------------------================================================
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
$instance = array();
$instance['dorecent_category'] = (!empty( $new_instance['dorecent_category'] ) ) ? sanitize_text_field( $new_instance['dorecent_category'] ) : '' ;
$instance['dorecent_number'] = absint( ! empty( $new_instance['dorecent_number'] ) ) ? absint(strip_tags( $new_instance['dorecent_number'] )) : '';
$instance['dorecent_order'] =  ( ! empty( $new_instance['dorecent_order'] ) ) ? sanitize_text_field( $new_instance['dorecent_order'] ) : '' ;
$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
return $instance;
}
} // Class monal_widget ends here
?>