<?php
// Register and load the widget
function monal_load_widget() {
    register_widget( 'monal_widget' );
}
add_action( 'widgets_init', 'monal_load_widget' );
// Creating the widget 
class monal_widget extends WP_Widget {
    
function __construct() { 

parent::__construct(

'monal_widget', 
__('Monal Recent Details', 'monal'), 
array( 'description' => __( 'Monal Recent Details', 'monal' )) 
);
}

// Creating widget front-end

public function widget( $args, $instance ) {
        $dorecent_number = ( !empty($instance[ 'dorecent_number' ])) ? $instance['dorecent_number'] : '4' ;
        $title = ( !empty($instance[ 'title' ])) ? $instance['title'] : '' ;
        echo $args['before_widget'];
    ?>
<div class="glamour-sidebar-blog-container">
    <?php if ($title) :?>
    <h2 class="widget-title"><span class="title"><?php echo esc_html($title); ?></span></h2>
    <?php endif;?>
    <?php                                    
    $q_args = array(
        'post_type' => 'post',
        'posts_per_page' => esc_attr($dorecent_number),
        'post_status' => 'publish',
        'order_by' => 'date',
        'order' => 'DESC',
        'post__not_in' => array (get_the_ID()),
    );
    $bio = new WP_Query( $q_args );
    if( $bio->have_posts() ) {
        while( $bio->have_posts() ) {
            $bio->the_post();
    ?>
    <div class="glamholder">
        <div class="custcol-2">
            <a href="<?php the_permalink(); ?>" class="comp-side1-right-img-container">
                <?php 
                if(get_the_post_thumbnail_url()){
                    the_post_thumbnail('medium');
                }
                ?>
            </a>
        </div>
        <div class="custcol-5">
            <div class="comp-side1-right-info">
                <a href="<?php the_permalink() ?>">
                    <h3><?php the_title() ?></h3>
                </a>
                <small> <?php esc_html_e('By: ', 'monal'); the_author(); ?></small>
            </div>
        </div>
    </div>
    <?php
        }
    }
    ?>
</div>
<?php
		echo $args['after_widget'];
}

// Widget Backend 
public function form( $instance ) {
    $dorecent_number = ( !empty($instance[ 'dorecent_number' ])) ? $instance[ 'dorecent_number' ] : '4' ;
    $title = ( !empty($instance[ 'title' ])) ? $instance[ 'title' ] : '' ;
?>

<p>
    <label
        for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'The Title of the Widget', 'monal' ); ?></label>

    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
        name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<p>
    <label
        for="<?php echo $this->get_field_id( 'dorecent_number' ); ?>"><?php esc_html_e( 'Number of posts to show ', 'monal' ); ?></label>
    <input class="widefat" type="number" id="<?php echo $this->get_field_id( 'dorecent_number' ); ?>"
        name="<?php echo $this->get_field_name( 'dorecent_number' ); ?>" type="text"
        value="<?php echo esc_attr( $dorecent_number ); ?>" />
</p>
<?php 
}
// Updating widget replacing old instances with new
    public function update( $new_instance, $old_instance ) {
    $instance = array();
    $instance['dorecent_number'] = ( ! empty( $new_instance['dorecent_number'] ) ) ? absint(strip_tags( $new_instance['dorecent_number'] )) : '';
    $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field($new_instance['title']) : '';
    return $instance;
    }
} // Class monal_widget ends here
?>