<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package monal
 */

get_header();
?>
<main id="primary" class="site-main">
    <header class="page-header">
        <div class="page-description">
            <?php the_archive_title('<h1 class="page-title">', '</h1>')?>
            <?php monal_breadcrumb();?>
        </div>
    </header>
    <div class="container">
        <div class="custholder margin-30">
            <?php 
			if (get_theme_mod('enable_sidebar_option_archive', 1) == 1){
				$archiveWidth = "cust-bio-left";
				} else {
				$archiveWidth = "cust-bio-full";
			}
							?>
            <div class="<?php echo $archiveWidth; ?>">

                <?php
		if ( have_posts() ) :
				?>
                <header class="page-header">

                </header><!-- .page-header -->
                <?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();
				/*
				 * Include the Post-Type-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
				 */
				get_template_part( 'template-parts/content', get_post_type() );


			endwhile;

			?>
                <div class=" page-nav">
                    <?php
		the_posts_pagination( array(
			'mid_size'  => 2,
			'prev_text' => __( 'Previous', 'monal' ),
			'next_text' => __( 'Next', 'monal' ),
		) );
		?>

                </div>
                <?php

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>
            </div>

            <?php 
			if (get_theme_mod('enable_sidebar_option_archive', 1) == 1){
			get_sidebar();	
			} 
			?>
        </div>
    </div>




</main><!-- #main -->

<?php

get_footer();