<?php
$momota_theme_svg_icons = array(
	'fort-awesome'         => array(
		'name'    => 'font-awesome/fort-awesome',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="fort-awesome" viewBox="0 0 1792 1896.0833"><path d="M640 1008V784q0-16-16-16h-96q-16 0-16 16v224q0 16 16 16h96q16 0 16-16zm512 0V784q0-16-16-16h-96q-16 0-16 16v224q0 16 16 16h96q16 0 16-16zm512 32v752h-640v-320q0-80-56-136t-136-56-136 56-56 136v320H0v-752q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-6 2.5-9.5t8.5-5 9.5-2 11.5 0 9 .5V121q-32-15-32-50 0-23 16.5-39T832 16t38.5 16T887 71q0 35-32 50v17q45-10 83-10 21 0 59.5 7.5t54.5 7.5q17 0 47-7.5t37-7.5q16 0 16 16v210q0 15-35 21.5t-62 6.5q-18 0-54.5-7.5T945 367q-40 0-90 12v133q1 0 9-.5t11.5 0 9.5 2 8.5 5 2.5 9.5v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v624h128v-112q0-16 16-16h96q16 0 16 16z"/></svg>',
	),
	'phone'                => array(
		'name'    => 'icons8-line-awesome/phone',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="phone" viewBox="0 0 512 545.5"><path d="M138.5 80c8.375 0 16.656 3.024 23.5 8.5l1 .5.5.5 64 66 1.5 1.5-.5.5c14.174 13.212 13.968 35.53.5 49l-32 32c4.92 11.277 18.33 40.02 44.5 65 26.358 25.16 53.932 39.467 65.5 45l31.5-31.5.5-.5c13.28-13.28 36.72-13.28 50 0l.5 1 65 65c13.28 13.28 13.28 36.22 0 49.5L405 481.5l-.5.5-.5.5c-15.01 12.867-36.04 17.486-55.5 11h-.5c-37.55-14.693-113.51-48.01-181.5-116C98.773 309.773 64.052 234.84 50.5 196c-.035-.1.034-.4 0-.5-6.703-18.434-1.915-39.738 13.5-54l-.5-.5 50-51.5.5-.5 1-.5c6.844-5.476 15.125-8.5 23.5-8.5zm0 32c-1.172 0-2.344.575-3.5 1.5L86.5 163l-.5.5-.5.5c-5.674 4.863-7.44 14.493-5 21 12.12 34.847 45.2 106.7 108.5 170 62.784 62.784 133.224 93.76 169.5 108 9.34 3.113 17.11 1.833 24.5-4.5l49-49c2.72-2.72 2.72-1.78 0-4.5l-65.5-65.5c-2.72-2.72-2.28-2.72-5 0l-40 40-7.5 7.5-10-4.5s-43.83-18.552-81-52.5l-3.5-3c-38.595-36.84-57-86-57-86l-3.5-10 7.5-7 40-40c1.966-1.966.874-3.6 1-3.5l-.5-.5-1-1-64-65.5c-1.156-.925-2.328-1.5-3.5-1.5z"></path></svg>',
	),
	'phone-square'         => array(
		'name'    => 'font-awesome/phone-square',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="phone-square" viewBox="0 0 1536 1896.0833"><path d="M1280 1193q0-11-2-16t-18-16.5-40.5-25-47.5-26.5-45.5-25-28.5-15q-5-3-19-13t-25-15-21-5q-15 0-36.5 20.5t-39.5 45-38.5 45T885 1167q-7 0-16.5-3.5T853 1157t-17-9.5-14-8.5q-99-55-170-126.5T525 842q-2-3-8.5-14t-9.5-17-6.5-15.5T497 779q0-13 20.5-33.5t45-38.5 45-39.5T628 631q0-10-5-21t-15-25-13-19q-3-6-15-28.5T555 492t-26.5-47.5-25-40.5-16.5-18-16-2q-48 0-101 22-46 21-80 94.5T256 631q0 16 2.5 34t5 30.5 9 33 10 29.5 12.5 33 11 30q60 164 216.5 320.5T843 1358q6 2 30 11t33 12.5 29.5 10 33 9 30.5 5 34 2.5q57 0 130.5-34t94.5-80q22-53 22-101zm256-777v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
	),
	'map'                  => array(
		'name'    => 'font-awesome/map-o',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-o" viewBox="0 0 2048 1896.0833"><path d="M2020 11q28 20 28 53v1408q0 20-11 36t-29 23l-640 256q-24 11-48 0l-616-246-616 246q-10 5-24 5-19 0-36-11-28-20-28-53V320q0-20 11-36t29-23L680 5q24-11 48 0l616 246L1960 5q32-13 60 6zM736 146v1270l576 230V376zM128 363v1270l544-217V146zm1792 1066V159l-544 217v1270z"/></svg>',
	),
	'map-marker'           => array(
		'name'    => 'icons8-line-awesome/map-marker',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-marker" viewBox="0 0 512 545.5"><path d="M256 80c79.336 0 144 64.664 144 144 0 22.5-9.116 48.313-21.5 76.5s-28.314 58.098-44.5 86C301.628 442.306 269 489 269 489l-13 19-13-19s-32.628-46.694-65-102.5c-16.186-27.902-32.116-57.813-44.5-86S112 246.5 112 224c0-79.336 64.664-144 144-144zm0 32c-62.04 0-112 49.96-112 112 0 12.844 6.884 37.06 18.5 63.5s27.686 55.738 43.5 83c25.155 43.364 40.74 66.3 50 80 9.26-13.7 24.845-36.636 50-80 15.815-27.262 31.884-56.56 43.5-83S368 236.844 368 224c0-62.04-49.96-112-112-112zm0 80c17.673 0 32 14.327 32 32s-14.327 32-32 32-32-14.327-32-32 14.327-32 32-32z"></path></svg>',
	),
	'map-pin'              => array(
		'name'    => 'icons8-line-awesome/map-pin',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-pin" viewBox="0 0 512 545.5"><path d="M256 112c61.666 0 112 50.334 112 112 0 56.225-41.876 102.677-96 110.5V480h-32V334.5c-54.124-7.823-96-54.275-96-110.5 0-61.666 50.334-112 112-112zm0 32c-44.372 0-80 35.628-80 80s35.628 80 80 80 80-35.628 80-80-35.628-80-80-80zm0 16v32c-17.866 0-32 14.134-32 32h-32c0-35.157 28.843-64 64-64z"></path></svg>',
	),
	'envelope-open'        => array(
		'name'    => 'font-awesome/envelope-open-o',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="envelope-open-o" viewBox="0 0 1792 1896.0833"><path d="M1474 913l39 51q8 11 6.5 23.5T1508 1008q-43 34-126.5 98.5t-146.5 113-67 51.5q-39 32-60 48t-60.5 41-76.5 36.5-74 11.5h-2q-37 0-74-11.5t-76-36.5-61-41.5-60-47.5q-5-4-65-50.5t-143.5-111T293 1015q-11-8-12.5-20.5T287 971l37-52q8-11 21.5-13t24.5 7q94 73 306 236 5 4 43.5 35t60.5 46.5 56.5 32.5 58.5 17h2q24 0 58.5-17t56.5-32.5 60.5-46.5 43.5-35q258-198 313-242 11-8 24-6.5t21 12.5zm190 719V704q-90-83-159-139-91-74-389-304-3-2-43-35t-61-48-56-32.5-59-17.5h-2q-24 0-59 17.5T780 178t-61 48-43 35Q461 427 360.5 506.5T231 610.5 149 685q-14 12-21 19v928q0 13 9.5 22.5t22.5 9.5h1472q13 0 22.5-9.5t9.5-22.5zm128-928v928q0 66-47 113t-113 47H160q-66 0-113-47T0 1632V704q0-56 41-94 123-114 350-290.5T624 138q36-30 59-47.5t61.5-42 76-36.5T895 0h2q37 0 74.5 12t76 36.5 61.5 42 59 47.5q43 36 156 122t226 177 201 173q41 38 41 94z"/></svg>',
	),
	'envelope'             => array(
		'name'    => 'font-awesome/envelope',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="envelope" viewBox="0 0 512 545.5"><path d="M48 160h416v288H48V160zm69 32l139 92.5L395 192H117zm-37 14v210h352V206L265 317.5l-9 5.5-9-5.5z"></path></svg>',
	),
	'facebook'             => array(
		'name'    => 'socicon/facebook',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1500 1500"><path d="M867.188 1500v-685.547h228.516l35.156-266.602h-263.672v-169.922c0-76.172 20.508-128.906 131.836-128.906h140.625v-237.305c-23.438-5.859-108.398-11.719-205.078-11.719-205.078 0-342.773 123.047-342.773 351.563v196.289h-231.445v266.602h231.445v685.547z"></path></svg>',
	),
	'facebook-square'      => array(
		'name'    => 'icons8-line-awesome/facebook',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="facebook" viewBox="0 0 512 545.5"><path d="M112 112h288c17.49 0 32 14.51 32 32v288c0 17.49-14.51 32-32 32H112c-17.49 0-32-14.51-32-32V144c0-17.49 14.51-32 32-32zm0 32v288h155V324h-42v-48h42v-36c0-41.328 25.136-63.5 62-63.5 17.664 0 33.068.908 37.5 1.5v43.5h-26c-20.048 0-23.5 9.516-23.5 23.5v31h47.5l-6 48H317v108h83V144H112z"></path></svg>',
	),
	'facebook-square-full' => array(
		'name'    => 'icons8-line-awesome/facebook',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="facebook-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664h-188v-595h199l30-232h-229V689q0-56 23.5-84t91.5-28l122-1V369q-63-9-178-9-136 0-217.5 80T820 666v171H620v232h200v595H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z"></path></svg>',
	),
	'twitter'              => array(
		'name'    => 'socicon/twitter',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1500 1500"><path d="M1347.656 445.313c0 11.719 0 26.367 0 38.086 0 407.227-310.547 875.977-875.977 875.977-172.852 0-336.914-49.805-471.68-137.695 23.438 2.93 49.805 2.93 73.242 2.93 143.555 0 278.32-46.875 383.789-131.836-134.766 0-249.023-90.82-290.039-213.867 20.508 5.859 38.086 5.859 58.594 5.859 29.297 0 55.664-2.93 82.031-8.789-140.625-29.297-246.094-155.273-246.094-301.758 0-2.93 0-2.93 0-5.859 41.016 23.438 87.891 38.086 137.695 38.086-82.031-52.734-137.695-149.414-137.695-254.883 0-55.664 17.578-108.398 43.945-155.273 149.414 187.5 377.93 310.547 632.813 322.266-5.859-23.438-8.789-46.875-8.789-70.313 0-169.922 137.695-307.617 307.617-307.617 90.82 0 169.922 38.086 225.586 96.68 70.313-14.648 137.695-38.086 196.289-73.242-23.438 70.313-73.242 131.836-134.766 169.922 61.523-8.789 120.117-23.438 175.781-49.805-41.016 61.523-93.75 117.188-152.344 161.133z"></path></svg>',
	),
	'twitter-x'            => array(
		'name'    => 'font-awesome/twitter-x',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" id="twitter-x" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"></path></svg>',
	),
	'youtube'              => array(
		'name'    => 'socicon/youtube',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1500 1500"><path d="M1485.352 451.172c0 0-14.648-105.469-58.594-149.414-58.594-61.523-123.047-61.523-152.344-64.453-208.008-14.648-524.414-14.648-524.414-14.648v0c0 0-316.406 0-524.414 14.648-29.297 2.93-93.75 2.93-152.344 64.453-43.945 43.945-58.594 149.414-58.594 149.414s-14.648 120.117-14.648 240.234v114.258c0 123.047 14.648 243.164 14.648 243.164s14.648 102.539 58.594 149.414c58.594 58.594 134.766 58.594 166.992 64.453 120.117 11.719 509.766 14.648 509.766 14.648s316.406 0 524.414-14.648c29.297-2.93 93.75-5.859 152.344-64.453 43.945-46.875 58.594-149.414 58.594-149.414s14.648-120.117 14.648-243.164v-114.258c0-120.117-14.648-240.234-14.648-240.234zM952.148 761.719v0l-354.492 184.57v-421.875l404.297 210.938z"></path></svg>',
	),
	'youtube-play'         => array(
		'name'    => 'icons8-line-awesome/youtube-play',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="youtube-play" viewBox="0 0 512 545.5"><path d="M256 128c60.263 0 113.502 6.265 146 11 26.856 3.916 48.563 24.196 53.5 51 4.223 22.86 8.5 56.296 8.5 98 0 41.688-4.296 75.152-8.5 98-4.938 26.824-26.624 47.105-53.5 51-32.612 4.733-86.06 11-146 11-59.954 0-113.4-6.267-146-11-26.864-3.896-48.54-24.197-53.5-51-4.205-22.822-8.5-56.207-8.5-98 0-41.81 4.294-75.176 8.5-98 4.938-26.805 26.652-47.086 53.5-51 32.498-4.735 85.722-11 146-11zm0 32c-58.122 0-110.095 5.924-141.5 10.5-13.536 1.974-24.046 12.177-26.5 25.5-3.89 21.112-8 52.337-8 92 0 39.648 4.11 70.887 8 92 2.465 13.325 12.98 23.54 26.5 25.5 31.53 4.578 83.727 10.5 141.5 10.5 57.758 0 109.952-5.92 141.5-10.5 13.54-1.962 24.045-12.164 26.5-25.5 3.892-21.152 8-52.472 8-92 0-39.544-4.095-70.86-8-92-2.454-13.324-12.973-23.527-26.5-25.5-31.406-4.576-83.394-10.5-141.5-10.5zm-48 36.5l24 13.5 112 64 24 14-24 14-112 64-24 13.5v-183zm32 55v73l63.5-36.5z"></path></svg>',
	),
	'vimeo'                => array(
		'name'    => 'font-awesome/vimeo-square',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="vimeo-square" viewBox="0 0 1536 1896.0833">                                <path d="M1292 638q10-216-161-222-231-8-312 261 44-19 82-19 85 0 74 96-4 57-74 167t-105 110q-43 0-82-169-13-54-45-255-30-189-160-177-59 7-164 100l-81 72-81 72 52 67q76-52 87-52 57 0 107 179 15 55 45 164.5t45 164.5q68 179 164 179 157 0 383-294 220-283 226-444zm244-222v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
	),
	'pinterest'            => array(
		'name'    => 'font-awesome/pinterest-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="pinterest-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664H523q85-122 108-210 9-34 53-209 21 39 73.5 67t112.5 28q181 0 295.5-147.5T1280 819q0-84-35-162.5t-96.5-139-152.5-97T799 384q-104 0-194.5 28.5t-153 76.5T344 598.5t-66.5 128T256 859q0 102 39.5 180T412 1149q13 5 23.5 0t14.5-19q10-44 15-61 6-23-11-42-50-62-50-150 0-150 103.5-256.5T778 514q149 0 232.5 81t83.5 210q0 168-67.5 286T853 1209q-60 0-97-43.5T733 1062q8-34 26.5-92.5t29.5-102 11-74.5q0-49-26.5-81.5T698 679q-61 0-103.5 56.5T552 875q0 72 24 121l-98 414q-24 100-7 254H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z"/></svg>',
	),
	'instagram'            => array(
		'name'    => 'socicon/instagram',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1500 1500"><path d="M750 134.766c202.148 0 222.656 2.93 301.758 5.859 76.172 2.93 114.258 14.648 140.625 23.438 35.156 14.648 61.523 32.227 84.961 55.664 26.367 26.367 43.945 52.734 55.664 84.961 11.719 29.297 23.438 67.383 26.367 140.625 2.93 82.031 5.859 102.539 5.859 304.688s-2.93 222.656-5.859 301.758c-2.93 76.172-14.648 114.258-23.438 140.625-14.648 35.156-32.227 61.523-55.664 84.961-26.367 26.367-52.734 43.945-84.961 55.664-29.297 11.719-67.383 23.438-140.625 26.367-82.031 2.93-102.539 5.859-304.688 5.859s-222.656-2.93-301.758-5.859c-76.172-2.93-114.258-14.648-140.625-23.438-35.156-14.648-61.523-32.227-84.961-55.664-26.367-26.367-43.945-52.734-55.664-84.961-11.719-29.297-23.438-67.383-26.367-140.625-2.93-82.031-5.859-102.539-5.859-304.688s2.93-222.656 5.859-301.758c2.93-76.172 14.648-114.258 23.438-140.625 14.648-35.156 32.227-61.523 55.664-84.961 26.367-26.367 52.734-43.945 84.961-55.664 29.297-11.719 67.383-23.438 140.625-26.367 82.031-2.93 102.539-5.859 304.688-5.859M750 0c-205.078 0-228.516 2.93-307.617 5.859-82.031 2.93-137.695 14.648-181.641 32.227-49.805 20.508-93.75 46.875-134.766 87.891s-67.383 84.961-87.891 134.766c-17.578 46.875-29.297 99.609-32.227 181.641-2.93 79.102-5.859 102.539-5.859 307.617s2.93 228.516 5.859 307.617c2.93 82.031 14.648 137.695 32.227 181.641 20.508 49.805 46.875 93.75 87.891 134.766s84.961 67.383 134.766 87.891c46.875 17.578 99.609 29.297 181.641 32.227 79.102 2.93 102.539 5.859 307.617 5.859s228.516-2.93 307.617-5.859c82.031-2.93 137.695-14.648 181.641-32.227 49.805-20.508 93.75-46.875 134.766-87.891s67.383-84.961 87.891-134.766c17.578-46.875 29.297-99.609 32.227-181.641 2.93-79.102 5.859-102.539 5.859-307.617s-2.93-228.516-5.859-307.617c-2.93-82.031-14.648-137.695-32.227-181.641-20.508-49.805-46.875-93.75-87.891-134.766s-84.961-67.383-134.766-87.891c-46.875-17.578-99.609-29.297-181.641-32.227-79.102-2.93-102.539-5.859-307.617-5.859zM750 363.281c-213.867 0-386.719 172.852-386.719 386.719s172.852 386.719 386.719 386.719c213.867 0 386.719-172.852 386.719-386.719s-172.852-386.719-386.719-386.719zM750 1001.953c-137.695 0-251.953-114.258-251.953-251.953s114.258-251.953 251.953-251.953c137.695 0 251.953 114.258 251.953 251.953s-114.258 251.953-251.953 251.953zM1239.258 348.633c0 49.805-38.086 90.82-87.891 90.82s-90.82-41.016-90.82-90.82c0-49.805 41.016-87.891 90.82-87.891s87.891 38.086 87.891 87.891z"></path></svg>',
	),
	'instagram-square'     => array(
		'name'    => 'icons8-line-awesome/instagram',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="instagram" viewBox="0 0 512 545.5"><path d="M128 112h256c26.32 0 48 21.68 48 48v256c0 26.32-21.68 48-48 48H128c-26.32 0-48-21.68-48-48V160c0-26.32 21.68-48 48-48zm208 48v48h48v-48h-48zm-80 64c-35.536 0-64 28.464-64 64s28.464 64 64 64 64-28.464 64-64-28.464-64-64-64zm-144 32v160c0 9.04 6.96 16 16 16h256c9.04 0 16-6.96 16-16V256h-53.5c3.544 9.99 5.5 20.83 5.5 32 0 52.83-43.17 96-96 96s-96-43.17-96-96c0-11.17 1.956-22.01 5.5-32H112z"></path></svg>',
	),
	'behance'              => array(
		'name'    => 'font-awesome/behance-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="behance-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960zM499 495H128v787h382q117 0 197-57.5t80-170.5q0-158-143-200 107-52 107-164 0-57-19.5-96.5T675 533t-79-29.5-97-8.5zm-22 318H301V629h163q119 0 119 90 0 94-106 94zm9 335H301V931h189q124 0 124 113 0 104-128 104zm650 32q-68 0-104-38t-36-107h411q1-10 1-30 0-132-74.5-220.5T1130 696q-128 0-210 86t-82 216q0 135 79 217t213 82q205 0 267-191h-138q-11 34-47.5 54t-75.5 20zm-10-366q113 0 124 122H996q4-56 39-89t91-33zM964 548h319v77H964v-77z"/></svg>',
	),
	'reddit'               => array(
		'name'    => 'icons8-line-awesome/reddit',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="reddit" viewBox="0 0 512 545.5"><path d="M298.5 96c17.22 0 30.54 6.428 45 11.5 12.44 4.364 26.343 8.396 45.5 9.5 6.795-12.467 19.875-21 35-21 22 0 40 18 40 40s-18 40-40 40c-17.4 0-32.032-11.405-37.5-27-22.485-1.5-39.988-6.76-53.5-11.5-15.896-5.575-26.17-9.5-34.5-9.5-17.55 0-26.5 10.836-26.5 26.5v54c44.15 2.282 84.11 13.977 116.5 32.5 12.372-11.938 28.88-17.012 45-17 17.43.013 35.21 6.175 47.5 20l.5.5c11.788 14.732 16.644 34.406 13.5 54-2.882 17.96-13.36 36.218-31.5 48 .1 1.83.5 3.648.5 5.5 0 41.664-25.204 78.205-63 103.5S312.216 496 256 496s-107.204-15.205-145-40.5S48 393.664 48 352c0-1.852.4-3.67.5-5.5-18.14-11.782-28.618-30.04-31.5-48-3.143-19.594 1.712-39.268 13.5-54l.5-.5v-.5c12.29-13.823 30.073-19.487 47.5-19.5 16.12-.012 32.624 5.065 45 17 32.39-18.523 72.35-30.218 116.5-32.5v-54c0-31.184 24.946-58.5 58.5-58.5zM256 240c-50.456 0-95.464 13.895-127 35s-49 48.265-49 77 17.464 55.895 49 77 76.544 35 127 35 95.464-13.895 127-35 49-48.265 49-77-17.464-55.895-49-77-76.544-35-127-35zM78.5 256c-9.49.007-18.153 3.372-23 8.5-.086.107.085.39 0 .5-5.1 6.614-8.224 17.757-6.5 28.5 1 6.229 3.408 12.36 7.5 17.5 8.12-19.152 21.637-36.46 39-51-4.925-2.5-10.912-4.005-17-4zm355 0c-6.09-.005-12.075 1.5-17 4 17.363 14.54 30.88 31.848 39 51 4.092-5.14 6.5-11.271 7.5-17.5 1.724-10.743-1.4-21.886-6.5-28.5-.035-.037.035-.463 0-.5-4.846-5.126-13.507-8.493-23-8.5zM176 288c17.673 0 32 14.327 32 32s-14.327 32-32 32-32-14.327-32-32 14.327-32 32-32zm160 0c17.673 0 32 14.327 32 32s-14.327 32-32 32-32-14.327-32-32 14.327-32 32-32zm4 88.5c-10.224 29.872-43.103 55.5-84 55.5s-73.776-25.773-84-53.5c18.4 14.928 49.248 26 84 26s65.6-10.928 84-28z"></path></svg>',
	),
	'logoNav'              => array(
		'name'    => 'logoNav',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M16.11 22.7h7.96v1.58h-7.96zM26.05 22.7h7.96v1.58h-7.96zM36 22.7h7.96v1.58H36zM7.11 21a2.48 2.48 0 11-2.45 2.51A2.48 2.48 0 017.11 21m0-1.59a4.07 4.07 0 104.07 4.07 4.09 4.09 0 00-4.07-4.05z"></path></svg>',
	),
	'logoAbove'            => array(
		'name'    => 'logoAbove',
		'content' => '<svg  width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M9.6 28.1h7.96v1.58H9.6zM19.53 28.1h7.96v1.58h-7.96zM29.44 28.1h7.96v1.58h-7.96zM23.52 18.91a2.48 2.48 0 010 4.95A2.49 2.49 0 0121 21.38a2.49 2.49 0 012.49-2.47m0-1.6a4.07 4.07 0 104.05 4.09 4.08 4.08 0 00-4.02-4.09z"></path></svg>',
	),
	'logoNavCta'           => array(
		'name'    => 'logoNavCta',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M14.51 22.7h7.96v1.58h-7.96zM24.45 22.7h7.96v1.58h-7.96zM43.16 22.7a.8.8 0 010 1.6h-6.38a.8.8 0 110-1.6h6.38m0-1.58h-6.38a2.38 2.38 0 000 4.76h6.38a2.38 2.38 0 100-4.76zM5.54 21a2.48 2.48 0 11-2.48 2.5A2.48 2.48 0 015.54 21m0-1.59a4.07 4.07 0 104.06 4.1 4.08 4.08 0 00-4.06-4.08z"></path></svg>',
	),
	'navLogoCta'           => array(
		'name'    => 'navLogoCta',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M9.94 22.7h7.96v1.58H9.94zM0 22.7h7.96v1.58H0zM38.24 22.7h6.38a.8.8 0 110 1.6h-6.38a.8.8 0 010-1.6m-2.38.8a2.38 2.38 0 002.38 2.38h6.38a2.38 2.38 0 100-4.76h-6.38a2.38 2.38 0 00-2.38 2.38zM26.87 21a2.49 2.49 0 012.49 2.48A2.48 2.48 0 1126.87 21m-4.06 2.5a4.07 4.07 0 104.06-4.08 4.07 4.07 0 00-4.06 4.09z"></path></svg>',
	),
	'logoNavCta2'          => array(
		'name'    => 'logoNavCta2',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M9.6 28.1h7.96v1.58H9.6zM19.54 28.1h7.96v1.58h-7.96zM29.45 28.1h7.96v1.58h-7.96zM43.16 20.58a.8.8 0 010 1.6h-6.37a.8.8 0 010-1.6h6.37m0-1.58h-6.37a2.38 2.38 0 100 4.76h6.37a2.38 2.38 0 100-4.76zM5.55 18.91a2.48 2.48 0 11-2.48 2.47 2.47 2.47 0 012.48-2.47m0-1.6A4.07 4.07 0 109.6 21.4a4.07 4.07 0 00-4.05-4.09z"></path></svg>',
	),
	'customLogo'           => array(
		'name'    => 'customLogo',
		'content' => '<svg height="14" enable-background="new 0 0 41 9" viewBox="0 0 41 9" xmlns="http://www.w3.org/2000/svg"><path d="m17.8 4.5c-.3-.2-.8-.4-1.3-.6s-1-.3-1.2-.5-.3-.4-.3-.6c0-.3.1-.6.3-.7s.5-.3.9-.3.8.1 1 .3.3.5.3.9h1.2c0-.4-.1-.8-.3-1.1s-.4-.7-.8-.8-.8-.3-1.3-.3c-.7 0-1.4.2-1.8.6-.5.4-.7.8-.7 1.4 0 .7.3 1.2 1 1.6.3.2.8.4 1.4.6s1 .3 1.2.5.3.4.3.7-.1.5-.3.7-.5.3-1 .3-.9-.1-1.1-.3-.4-.5-.4-.9h-1.2c0 .4.1.8.4 1.2s.6.6 1 .8.9.3 1.4.3c.8 0 1.4-.2 1.8-.5s.7-.8.7-1.4c0-.4-.1-.7-.2-1s-.6-.7-1-.9z"/><path d="m11.3 5.6c0 1-.5 1.5-1.4 1.5-.5 0-.8-.1-1.1-.4s-.3-.6-.3-1.1v-4.7h-1.3v4.7c0 .8.3 1.4.8 1.8s1.1.7 1.9.7 1.4-.2 1.9-.7.7-1 .7-1.8v-4.7h-1.2z"/><path d="m2.3 2.4c.3-.4.7-.6 1.2-.6s.8.1 1.1.3.4.6.4 1.1h1.2c0-.7-.3-1.3-.8-1.8s-1.1-.6-1.9-.6c-.6 0-1.1.1-1.5.4s-.8.7-1 1.2-.4 1.1-.4 1.8v.7c0 .7.1 1.2.4 1.7s.6.9 1 1.1.9.4 1.5.4c.8 0 1.5-.2 1.9-.6s.8-1 .8-1.8h-1.2c-.1.5-.2.9-.5 1.1s-.6.3-1 .3c-.5 0-.9-.2-1.2-.6s-.4-1-.4-1.8v-.6c-.1-.8.1-1.3.4-1.7z"/><path d="m38.6.9-2.1 5.4-2-5.4h-1.6v7.1h1.2v-2.3l-.1-3.2 2.1 5.5h.9l2.1-5.5-.2 3.2v2.3h1.3v-7.1z"/><path d="m19.4 1.9h2.2v6.1h1.2v-6.1h2.2v-1h-5.6z"/><path d="m30.2 1.2c-.4-.3-1-.4-1.5-.4s-1.1.1-1.5.4-.8.7-1 1.2-.4 1.1-.4 1.8v.4c0 .7.1 1.3.4 1.8s.6.9 1 1.2 1 .4 1.5.4c.6 0 1.1-.1 1.5-.4s.8-.7 1-1.2.4-1.1.4-1.8v-.4c0-.7-.1-1.3-.4-1.8s-.5-.9-1-1.2zm.2 3.4c0 .8-.1 1.4-.4 1.8s-.7.6-1.3.6c-.5 0-1-.2-1.3-.6s-.4-1-.4-1.8v-.4c0-.8.2-1.4.5-1.8s.7-.6 1.3-.6c.5 0 1 .2 1.3.6s.4 1 .4 1.8v.4z"/></svg>',
	),
	'textOnly'             => array(
		'name'    => 'textOnly',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M0 17.93h47v2.58H0zM2.06 23.01h42.88v1.29H2.06zM17.81 27.12h11.38v1.95H17.81z"></path></svg>',
	),
	'textWithMediaOnRight' => array(
		'name'    => 'textWithMediaOnRight',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M46.14 12.5H25.86a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84v-20.3a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L34.1 24a1.89 1.89 0 00-2.48 0l-5.35 4.2V13.79zM26.29 33.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.6.16l2.39-1.72a.6.6 0 01.74 0L45.71 29v4.22z"></path><path d="M40.66 22.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM0 17.93h20v2.58H0zM0 23.01h15.88v1.29H0zM0 27.12h5.69v1.95H0z"></path></svg>',
	),
	'textWithMediaOnLeft'  => array(
		'name'    => 'textWithMediaOnLeft',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M21.14 12.5H.86a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84v-20.3a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L9.12 24a1.88 1.88 0 00-2.48-.09l-5.35 4.25V13.79zM1.29 33.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.6.16l2.39-1.72a.6.6 0 01.74 0L20.71 29v4.22z"></path><path d="M15.66 22.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM27 17.93h20v2.58H27zM27 23.01h15.88v1.29H27zM27 27.12h5.69v1.95H27z"></path></svg>',
	),
	'textWithMediaAbove'   => array(
		'name'    => 'textWithMediaAbove',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M33.64 4.5H13.36a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84V5.36a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L21.6 16a1.89 1.89 0 00-2.48 0l-5.35 4.2V5.79zM13.79 25.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.64.18l2.39-1.72a.6.6 0 01.74 0L33.25 21v4.22z"></path><path d="M28.16 14.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM12.5 31.36h22v2.58h-22zM14.56 36.44h17.88v1.29H14.56zM20.66 40.55h5.69v1.95h-5.69z"></path></svg>',
	),
	'textWithMediaBelow'   => array(
		'name'    => 'textWithMediaBelow',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M33.64 20.5H13.36a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84v-20.3a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L21.6 32a1.89 1.89 0 00-2.48 0l-5.35 4.2V21.79zM13.79 41.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.64.18l2.39-1.72a.6.6 0 01.74 0L33.25 37v4.22z"></path><path d="M28.16 30.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM12.5 4.5h22v2.58h-22zM14.56 9.58h17.88v1.29H14.56zM20.66 13.68h5.69v1.95h-5.69z"></path></svg>',
	),
	'customMedia'          => array(
		'name'    => 'customMedia',
		'content' => '<svg height="14" enable-background="new 0 0 41 9" viewBox="0 0 41 9" xmlns="http://www.w3.org/2000/svg"><path d="m17.8 4.5c-.3-.2-.8-.4-1.3-.6s-1-.3-1.2-.5-.3-.4-.3-.6c0-.3.1-.6.3-.7s.5-.3.9-.3.8.1 1 .3.3.5.3.9h1.2c0-.4-.1-.8-.3-1.1s-.4-.7-.8-.8-.8-.3-1.3-.3c-.7 0-1.4.2-1.8.6-.5.4-.7.8-.7 1.4 0 .7.3 1.2 1 1.6.3.2.8.4 1.4.6s1 .3 1.2.5.3.4.3.7-.1.5-.3.7-.5.3-1 .3-.9-.1-1.1-.3-.4-.5-.4-.9h-1.2c0 .4.1.8.4 1.2s.6.6 1 .8.9.3 1.4.3c.8 0 1.4-.2 1.8-.5s.7-.8.7-1.4c0-.4-.1-.7-.2-1s-.6-.7-1-.9z"/><path d="m11.3 5.6c0 1-.5 1.5-1.4 1.5-.5 0-.8-.1-1.1-.4s-.3-.6-.3-1.1v-4.7h-1.3v4.7c0 .8.3 1.4.8 1.8s1.1.7 1.9.7 1.4-.2 1.9-.7.7-1 .7-1.8v-4.7h-1.2z"/><path d="m2.3 2.4c.3-.4.7-.6 1.2-.6s.8.1 1.1.3.4.6.4 1.1h1.2c0-.7-.3-1.3-.8-1.8s-1.1-.6-1.9-.6c-.6 0-1.1.1-1.5.4s-.8.7-1 1.2-.4 1.1-.4 1.8v.7c0 .7.1 1.2.4 1.7s.6.9 1 1.1.9.4 1.5.4c.8 0 1.5-.2 1.9-.6s.8-1 .8-1.8h-1.2c-.1.5-.2.9-.5 1.1s-.6.3-1 .3c-.5 0-.9-.2-1.2-.6s-.4-1-.4-1.8v-.6c-.1-.8.1-1.3.4-1.7z"/><path d="m38.6.9-2.1 5.4-2-5.4h-1.6v7.1h1.2v-2.3l-.1-3.2 2.1 5.5h.9l2.1-5.5-.2 3.2v2.3h1.3v-7.1z"/><path d="m19.4 1.9h2.2v6.1h1.2v-6.1h2.2v-1h-5.6z"/><path d="m30.2 1.2c-.4-.3-1-.4-1.5-.4s-1.1.1-1.5.4-.8.7-1 1.2-.4 1.1-.4 1.8v.4c0 .7.1 1.3.4 1.8s.6.9 1 1.2 1 .4 1.5.4c.6 0 1.1-.1 1.5-.4s.8-.7 1-1.2.4-1.1.4-1.8v-.4c0-.7-.1-1.3-.4-1.8s-.5-.9-1-1.2zm.2 3.4c0 .8-.1 1.4-.4 1.8s-.7.6-1.3.6c-.5 0-1-.2-1.3-.6s-.4-1-.4-1.8v-.4c0-.8.2-1.4.5-1.8s.7-.6 1.3-.6c.5 0 1 .2 1.3.6s.4 1 .4 1.8v.4z"/></svg>',
	),
	'whatsapp-square'      => array(
		'name'    => 'icons8-line-awesome/whatsapp',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" id="whatsapp" viewBox="0 0 512 512"><path d="M392.048 152.048c36.096 36.128 55.968 84.16 55.968 135.232-.048 105.392-85.823 191.136-191.2 191.136h-.08c-32-.016-63.455-8.032-91.375-23.264L64 481.727l27.12-99.055C74.385 353.696 65.586 320.8 65.6 287.12 65.65 181.744 151.424 96 256.8 96c51.153.016 99.153 19.92 135.248 56.048zM256.8 446.128c87.6 0 158.88-71.264 158.896-158.864.016-42.447-16.496-82.352-46.496-112.384s-69.904-46.576-112.353-46.592c-87.648 0-158.943 71.248-158.976 158.848 0 30.017 8.4 59.248 24.305 84.544l3.776 6.017-16.047 58.624 60.144-15.776 5.808 3.44c24.4 14.48 52.368 22.13 80.88 22.144h.064zm87.168-118.976c4.784 2.384 7.968 3.584 9.168 5.6 1.2 1.984 1.2 11.55-2.784 22.704-3.968 11.152-23.056 21.328-32.24 22.704-8.24 1.23-18.656 1.744-30.096-1.888-6.928-2.208-15.84-5.152-27.232-10.064-47.936-20.69-79.232-68.928-81.616-72.113-2.384-3.183-19.504-25.903-19.504-49.407 0-23.505 12.352-35.057 16.72-39.84 4.368-4.784 9.552-5.984 12.736-5.984 3.184 0 6.37.015 9.152.16 2.928.144 6.88-1.12 10.753 8.19 3.983 9.553 13.535 33.074 14.735 35.458s2 5.184.4 8.368c-1.6 3.183-2.4 5.183-4.784 7.967s-5.024 6.225-7.168 8.37c-2.4 2.382-4.88 4.96-2.095 9.743 2.783 4.784 12.368 20.43 26.575 33.088 18.24 16.272 33.633 21.328 38.416 23.712 4.784 2.383 7.568 1.984 10.352-1.2 2.784-3.184 11.936-13.936 15.12-18.72 3.184-4.768 6.368-3.985 10.752-2.384 4.37 1.584 27.856 13.15 32.64 15.536z"></path></svg>',
	),
	'yahoo-square'         => array(
		'name'    => 'icons8-line-awesome/yc-square',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" id="yc-square" viewBox="0 0 512 545.5"><path d="M80 112h352v352H80V112zm32 32v288h288V144H112zm72 64h32l40 68.5 40-68.5h32l-56 96v80h-32v-80z"></path></svg>',
	),
);

$momota_theme_divider_style = array(
	'tilt-flipped' => '<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none"  viewBox="0 0 1000 100">  <path id="path2" d="M 1000,0 H 0 v 100 z" class="svg-white-bg" /></svg>',
	'tilt'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M-0 0L1000 0 1000 100z"/></svg>',
);

$header_gradients = array(
	'front_header_default_overlay' =>
		array(
			'name'  => 'front_header_default_overlay',
			'angle' => '90',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => 'rgba(250, 250, 250, 1)',
							'position' => '46',
						),
					1 =>
						array(
							'color'    => 'rgba(250, 250, 250, 0)',
							'position' => '86',
						),
				),
		),
	'inner_header_default_overlay' =>
		array(
			'name'  => 'inner_header_default_overlay',
			'angle' => '90',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => 'rgba(250, 250, 250, 1)',
							'position' => '46',
						),
					1 =>
						array(
							'color'    => 'rgba(250, 250, 250, 0)',
							'position' => '86',
						),
				),
		),
);

$momota_gradients = array(
	'night_fade'  =>
		array(
			'name'  => 'night_fade',
			'angle' => '0',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => '#a18cd1',
							'position' => '0',
						),
					1 =>
						array(
							'color'    => '#fbc2eb',
							'position' => '100',
						),
				),
		),
	'juicy_peach' =>
		array(
			'name'  => 'juicy_peach',
			'angle' => '90',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => '#ffecd2',
							'position' => '0',
						),
					1 =>
						array(
							'color'    => '#fcb69f',
							'position' => '100',
						),
				),
		),
	'mean_fruit'  =>
		array(
			'name'  => 'mean_fruit',
			'angle' => '120',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => '#fccb90',
							'position' => '0',
						),
					1 =>
						array(
							'color'    => '#d57eeb',
							'position' => '100',
						),
				),
		),

);

$momota_theme_click_pen_to_edit_title =  'Smarter. Faster. Better.';
$momota_lorem_ipsum                   =  'Lorem ipsum dolor sit amet, at mei dolore tritani repudiandae. In his nemore temporibus consequuntur, vim ad prima vivendum consetetur.';

$momota_theme_action_button           = 'See features';
$momota_theme_action_button_secondary = 'Contact us';


return array(
	'default_icon'                      => $momota_theme_svg_icons['fort-awesome'],
	'icons'                             => $momota_theme_svg_icons,
	'divider_style'                     => $momota_theme_divider_style,
	'lorem_ipsum'                       => $momota_lorem_ipsum,
	'edit_this_text_in_customizer'      => $momota_theme_click_pen_to_edit_title,
	'gradients'                         => $momota_gradients,

	'assets_js_key'                     => 'kubioFrontendData',

	'front-header'                      => array(
		'navigation'   => array(
			'props' => array(
				'showTopBar' => false,
				'width'      => 'boxed',
				'sticky'     => true,
			),

			'style' => array(
				'padding' => array(
					'top' => array(
						'value' => 5,
						'unit'  => 'px',
					),
				),
			),
		),
		'header-menu'  => array(
			'props' => array(
				'hoverEffect' => array(
					'group' => array(
						'border' => array(
							'transition' => 'effect-borders-grow grow-from-left',
						),
					),
					'type'  => 'none',
				),
			),
			'style' => array(
				'descendants' => array(
					'innerMenu' => array(
						'justifyContent' => 'center',
					),
				),
			),
		),
		'logo'         => array(
			'props' => array(
				'layoutType' => 'text',
			),
		),
		'buttons'      => array(
			'show'  => true,
			'style' => array(
				'textAlign' => 'center',
			),
			'value' => array(
				array(
					'label'       => sprintf( $momota_theme_action_button, 1 ),
					'url'         => '#',
					'button_type' => '0',
					'index'       => 0,
				),
				array(
					'label'       => sprintf( $momota_theme_action_button_secondary, 1 ),
					'url'         => '#',
					'button_type' => '1',
					'index'       => 1,
				),
			),
		),
		'title'        => array(
			'show'  => true,
			'value' => $momota_theme_click_pen_to_edit_title,
			'style' => array(
				'descendants' => array(
					'text' => array(
						'textAlign' => 'center',
					),
				),
			),
		),
		'subtitle'     => array(
			'show'  => true,
			'value' => $momota_theme_click_pen_to_edit_title,
			'style' => array(
				'descendants' => array(
					'text' => array(
						'textAlign' => 'center',
					),
				),
			),
		),
		'hero'         => array(
			'style'             => array(
				'descendants' => array(
					'outer' => array(
						'background' => array(
							'type'      => 'image',
							'color'     => 'rgba(255,255,255,1)',
							'overlay'   =>
								array(
									'type'             => 'color',
									'color'            => array(
										'value' => 'rgba(0, 0, 0, 0.7)',
									),
									'gradient'         => $header_gradients['front_header_default_overlay'],
									'gradient_opacity' => 100,
									'shape'            =>
										array(
											'value'  => 'none',
											'isTile' => false,
										),
								),
							'slideshow' => array(
								'duration' => array( 'value' => 5000 ),
								'speed'    => array( 'value' => 1000 ),
								'slides'   => array(
									array(
										'url' => get_template_directory_uri() . '/resources/images/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg',
									),
								),
							),
							'video'     => array(
								'videoType'   => 'external',
								'externalUrl' => 'https://www.youtube.com/watch?v=xXRy-JQ8G0Y',
								'internalUrl' => get_template_directory_uri() . '/resources/videos/demo-video.mp4',
								'poster'      =>
									array(
										'url' => get_template_directory_uri() . '/resources/images/demo-video-cover.jpg',
									),
							),
							'image'     => array(
								array(
									'source'     => array(
										'url'      => get_template_directory_uri() . '/resources/images/background-image.jpg',
										'gradient' => $momota_gradients['night_fade'],
									),
									'position'   => 'center center',
									'size'       => 'cover',
									'attachment' => 'scroll',
								),
							),
						),

						'padding'    => array(
							'top'    => array(
								'value' => 220,
							),
							'bottom' => array(
								'value' => 220,
							),

						),

						'separators' => array(
							'separatorBottom' => array(
								'type'     => 'tilt',
								'color'    => '#FFFFFF',
								'height'   => array( 'value' => 100 ),
								'enabled'  => false,
								'negative' => false,
							),
						),
					),
				),
			),
			'hero_column_width' => 80,
			'props'             => array(
				'heroSection'  => array(
					'layout' => 'textOnly',
				),
				'useWhiteText' => false,
			),
			'image'             => array(
				'style'      => array(
					'descendants' => array(
						'image'      => array(
							'boxShadow' => array(
								'layers'  => array(
									array(
										'x'      => - 20,
										'y'      => 20,
										'spread' => 0,
										'blur'   => 10,
										'color'  => 'rgba(136, 136, 136, 1)',
									),
								),
								'enabled' => false,
							),
						),
						'frameImage' => array(
							'backgroundColor' => 'rgba(255, 255, 255, 1)',
							'width'           => 100,
							'height'          => 100,
							'transform'       => array(
								'translate' => array(
									'x_value' => 10,
									'y_value' => 10,
								),
							),
							'thickness'       => 10,
						),
					),
				),
				'props'      => array(
					'frame'              => array(
						'type' => 'border',
					),
					'showFrameOverImage' => true,
					'showFrameShadow'    => false,
					'enabledFrameOption' => false,
				),
				'localProps' => array(
					'url' => get_template_directory_uri() . '/resources/images/placeholder.png',
				),
			),
			'full_height'       => false,
		),
		'social_icons' => array(
			'show'       => true,
			'localProps' => array(
				'iconList' => array(
					array(
						'icon'       => $momota_theme_svg_icons['facebook'],
						'link_value' => '#',
						'index'      => 0,
					),
					array(
						'icon'       => $momota_theme_svg_icons['twitter-x'],
						'link_value' => '#',
						'index'      => 1,
					),
					array(
						'icon'       => $momota_theme_svg_icons['youtube'],
						'link_value' => '#',
						'index'      => 2,
					),
/*					array(
						'icon'       => $momota_theme_svg_icons['vimeo'],
						'link_value' => '#',
						'index'      => 3,
					),*/
				),
			),
		),
		'icon_list'    => array(
			'show'       => true,
			'localProps' => array(
				'iconList' => array(
					array(
						'icon'       => $momota_theme_svg_icons['map-marker'],
						'text'       => '123, Main Street, City, Country',
						'link_value' => 'https://maps.google.com/',
						'index'      => 0,
					),
					array(
						'icon'       => $momota_theme_svg_icons['phone'],
						'text'       => '+1 234 567 890',
						'link_value' => 'tel:+1 234 567 890',
						'index'      => 0,
					),
					array(
						'icon'       => $momota_theme_svg_icons['envelope'],
						'text'       => 'email@example.com',
						'link_value' => 'mailto:email@example.com',
						'index'      => 1,
					),
				),
			),
		),
	),

	'header'                            => array(
		'navigation'   => array(
			'props' => array(
				'showTopBar' => false,
				'width'      => 'boxed',
				'sticky'     => true,
			),
			'style' => array(
				'padding' => array(
					'top' => array(
						'value' => 5,
						'unit'  => 'px',
					),
				),
			),
		),
		'header-menu'  => array(
			'props' => array(
				'hoverEffect' => array(
					'group' => array(
						'border' => array(
							'transition' => 'effect-borders-grow grow-from-left',
						),
					),
					'type'  => 'none',
				),
			),
		),
		'logo'         => array(
			'props' => array(
				'layoutType' => 'text',
			),
		),
		'title'        => array(
			'show'  => true,
			'style' => array(
				'descendants' => array(
					'text' => array(
						'textAlign' => 'center',
					),
				),
			),
		),
		'hero'         => array(
			'style' => array(
				'descendants' => array(
					'outer' => array(
						'background' => array(
							'type'      => 'image',
							'color'     => 'rgba(255,255,255,1)',
							'overlay'   =>
								array(
									'type'             => 'color',
									'color'            => array(
										'value' => 'rgba(0, 0, 0, 0.7)',
									),
									'gradient'         => $header_gradients['inner_header_default_overlay'],
									'gradient_opacity' => 100,
									'shape'            =>
										array(
											'value'  => 'none',
											'isTile' => false,
										),
								),
							'slideshow' => array(
								'duration' => array( 'value' => 5000 ),
								'speed'    => array( 'value' => 1000 ),
								'slides'   => array(
									array(
										'url' => get_template_directory_uri() . '/resources/images/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg',
									),
								),
							),
							'video'     => array(
								'videoType'   => 'external',
								'externalUrl' => 'https://www.youtube.com/watch?v=xXRy-JQ8G0Y',
								'internalUrl' => get_template_directory_uri() . '/resources/videos/demo-video.mp4',
								'poster'      =>
									array(
										'url' => get_template_directory_uri() . '/resources/images/demo-video-cover.jpg',
									),
							),
							'image'     => array(
								array(
									'source'     => array(
										'url'      => get_template_directory_uri() . '/resources/images/background-image.jpg',
										'gradient' => $momota_gradients['night_fade'],
									),
									'position'   => 'center top',
									'size'       => 'cover',
									'attachment' => 'fixed',
								),
							),
						),

						'padding'    => array(
							'top'    => array(
								'value' => 100,
							),
							'bottom' => array(
								'value' => 100,
							),

						),

						'separators' => array(
							'separatorBottom' => array(
								'type'     => 'tilt',
								'color'    => '#FFF',
								'height'   => array( 'value' => 75 ),
								'enabled'  => false,
								'negative' => false,
							),
						),
					),
				),
			),
		),
		'social_icons' => array(
			'show'       => true,
			'localProps' => array(
				'icons' => array(
					array(
						'icon'       => $momota_theme_svg_icons['facebook'],
						'link_value' => '#',
						'index'      => 0,
					),
					array(
						'icon'       => $momota_theme_svg_icons['whatsapp-square'],
						'link_value' => '#',
						'index'      => 1,
					),
					array(
						'icon'       => $momota_theme_svg_icons['youtube'],
						'link_value' => '#',
						'index'      => 2,
					),
/*					array(
						'icon'       => $momota_theme_svg_icons['whatsapp-square'],
						'link_value' => '#',
						'index'      => 3,
					),*/
				),
			),
		),
		'icon_list'    => array(
			'show'       => true,
			'localProps' => array(
				'iconList' => array(
					array(
						'icon'       => $momota_theme_svg_icons['map-pin'],
						'text'       => '1557 Frosty Lane, Binghamton, NY',
						'link_value' => '#',
						'index'      => 0,
					),
					array(
						'icon'       => $momota_theme_svg_icons['phone-square'],
						'text'       => '+400 098 765 432',
						'link_value' => '#',
						'index'      => 1,
					),
					array(
						'icon'       => $momota_theme_svg_icons['envelope'],
						'text'       => 'email@example.com',
						'link_value' => '#',
						'index'      => 2,
					),
				),
			),
		),

	),
	'blog_post_thumb_placeholder_color' => 'rgb(175, 186, 207)',
	'blog_show_post_thumb_placeholder'  => true,
	'blog_posts_per_row'                => 2,
	'blog_enable_masonry'               => true
);
