<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
    <?php  ?>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header class="header">
    <div class="container">
        <?php if( get_custom_logo() ): ?>
            <div class="logo">
                <?php the_custom_logo(); ?>
            </div>
        <?php endif; ?>
        <h1 class="title"><a href="<?php echo esc_url( home_url('/') ) ?>"><?php bloginfo('name') ?></a></h1>
        <p class="description"><?php bloginfo('description') ?></p>

        <a href="#" class="menu_toggle mojix_sidr" data-name="main_menu" data-side="<?php echo (is_rtl()) ? 'right' : 'left'; ?>">
            <span></span>
            <span></span>
            <span></span>
        </a>

    </div><!--container-->

    <div id="main_menu">
        <?php
        if (has_nav_menu('main_menu')) {
            wp_nav_menu(array(
                'theme_location' => 'main_menu',
                'menu_class' => 'main_menu',
                'container' => false
            ));
        }
        ?>
    </div>


</header>