<?php
/**
 * Class Mojix
 * Theme main class
 */
class Mojix {
	/**
	 * @var string
	 * Theme version
	 */
	public static $version = '1.1.0';

	/**
	 * The single instance of the class.
	 *
	 * @var Mojix
	 */
	protected static $_instance = null;


    /**
     * Mojix constructor.
     */
    public function __construct() {
        // Setup theme
        add_action( 'after_setup_theme', array($this, 'setup') );

        // Enqueue scripts
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));

        // Add continue reading link
        add_filter( 'excerpt_more', array($this, 'excerpt_more') );

	    add_action( 'template_redirect', array($this, 'content_width'), 0 );

    }

	/**
	 * Main Class Instance.
	 *
	 * Ensures only one instance of this class is loaded or can be loaded.
	 *
	 * @static
	 * @return Mojix - Main instance.
	 */
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

    /**
     * Mojix theme setup
     */
    public function setup() {
        // load translation text domain
        load_theme_textdomain( 'mojix', get_template_directory() . '/languages' );

        // Title Tag Support
        add_theme_support( 'title-tag' );

        // Posts Thumbnail Support
        add_theme_support('post-thumbnails');

        // Register Nav menus
        register_nav_menus(
            array(
                'main_menu' => __( 'Main Menu', 'mojix'),
            )
        );

        // HTML5 Support
        add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        // Add theme support for Custom Logo.
        add_theme_support( 'custom-logo', array(
            'width'       => 140,
            'height'      => 100,
            'flex-width'  => true,
        ) );

    }

    /**
     * Load theme assets
     */
    public function enqueue_scripts() {

        // Theme stylesheet.
        wp_enqueue_style( 'mojix-style', get_stylesheet_uri() );
	    if ( get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );

        // Theme JS file
        wp_enqueue_script('jquery-sidr', get_template_directory_uri().'/assets/js/sidr.min.js', array('jquery'), '2.2.1', true);
        wp_enqueue_script('mojix-js', get_template_directory_uri().'/assets/js/mojix.min.js', array('jquery'), self::$version, true);

    }

	/**
	 * @param $more
	 *
	 * @return string
	 */
	public function excerpt_more($more) {
        return ' &hellip;';
    }

	/**
	 * theme content with
	 */
	public function content_width() {
		if ( ! isset( $content_width ) ) $content_width = 1200;
		$GLOBALS['content_width'] = $content_width;
	}

}
Mojix::get_instance();