(function($) {
    'use strict';

    jQuery(document).ready(function($) {

        // Sidr
        $('.mojix_sidr').each(function(index, el) {
            var side = $(this).data('side'),
                name = $(this).data('name');
            $(this).sidr({
                side: side,
                name: name,
                onOpenEnd: function(){
                    $('#'+name).addClass('mojix_sidr_open');
                },
                onCloseEnd: function(){
                    $('#'+name).removeClass('mojix_sidr_open');
                }
            });
        });

        var ua = navigator.userAgent,
            pickclick = (ua.match(/iPad/i) || ua.match(/iPhone/)) ? "touchstart" : "click";
        $("body").on(pickclick, function(event) {
            if(!$(event.target).is('.mojix_sidr_open, .mojix_sidr_open *')){
                if($('body').hasClass('sidr-open')) {
                    event.preventDefault();
                    var target = $('.mojix_sidr_open').attr('id');
                    $.sidr('close', target);
                }
            }
        });



    });
})(jQuery);
