<!doctype html> 
<html <?php language_attributes(); ?>>

<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php wp_title('|', true, 'right'); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<header id="global-header"<?php if ( get_header_image() != '' ) { ?> style="background: url(<?php header_image(); ?>) no-repeat center bottom; border-bottom: 0px;"<?php } ?>>
<div class="pagewidth clear">
<?php if( get_bloginfo( 'description' ) != '' ) { ?>

	<div id="site-title">
		<h1><a href="<?php echo home_url( '/' ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
		<p><?php bloginfo( 'description' ); ?></p>
	</div>
	<!-- /site-title -->

<?php } else { ?>

	<h1><a href="<?php echo home_url( '/' ); ?>"><?php bloginfo( 'name' ); ?></a></h1>

<?php } ?>
	<nav id="main-nav">
		<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => '', 'menu_class' => 'menu' ) ); ?>
	</nav>
	<!-- /main-nav -->

</div>
</header>
<!-- /global-header -->

