<?php
/*
 * Creates a nicely formatted and more specific title element text.
 */
function modish_wp_title( $title, $sep ) {

	if ( is_feed() )
		return $title;
	
	// Add the site name.
	$title .= get_bloginfo( 'name' );
	
	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";

	return $title;
}
add_filter( 'wp_title', 'modish_wp_title', 10, 2 );


/*
 * Modish theme basic setup.
 */
function modish_setup() {

	// Makes Modish available for translation.
	load_theme_textdomain( 'modish', get_template_directory() . '/languages' );

	// Adds RSS feed links to <head> for posts and comments. 
	add_theme_support( 'automatic-feed-links' );
	
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Modish Header Menu', 'modish' ),
	) );

	// This theme uses a custom image size for featured images, displayed on "standard" posts.
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 300, 300 );
	
	// This theme supports custom background color and image.
	$defaults = array(
	'default-color' => '', 
	'default-image' => '',
	'wp-head-callback' => '_custom_background_cb',
	'admin-head-callback' => '',
	'admin-preview-callback' => '' );  
	add_theme_support( 'custom-background', $defaults );

	// This theme uses a custom header background image.
	$args = array(
	'width'          => 1920,
	'flex-width'     => true,
	'flex-height'    => true,
	'header-text'    => false,
	'random-default' => true,);
	add_theme_support( 'custom-header', $args );

	// This theme styles the visual editor to resemble the theme style.
	add_editor_style( 'editor-style.css' );

	// Sets up the content width value based on the theme's design and stylesheet.
	if ( ! isset( $content_width ) )
	$content_width = 777;

}
add_action( 'after_setup_theme', 'modish_setup' );

/**
 * Enqueues scripts and styles for front-end.
 *
*/
function modish_scripts_styles() {
	global $wp_styles;

	// Adds JavaScript
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	//Loads the main stylesheet and Google web fonts.
	wp_enqueue_style( 'modish-style', get_stylesheet_uri() );
	wp_enqueue_style('googleFonts', '//fonts.googleapis.com/css?family=Raleway:200,400|Open+Sans:300,400');
}
add_action( 'wp_enqueue_scripts', 'modish_scripts_styles' );

/**
 * if lt IE 9
 */
function modish_head() {
?>
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/javascripts/html5.js" type="text/javascript"></script>
<![endif]-->
<?php
}
add_action( 'wp_head', 'modish_head');

/*
 * Register one Modish widgetized area.
 */
function modish_widgets_init() {
	register_sidebar( array(
		'name'     => __( 'Sidebar', 'modish' ),
		'id'      => 'sidebar1',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="widget-title">',
		'after_title'  => '</h2>',
	) );
}
add_action( 'widgets_init', 'modish_widgets_init' );
if ( ! function_exists( 'modish_get_the_content_with_formatting' ) ) {
function modish_get_the_content_with_formatting ($stripteaser = 0, $more_file = '') {
	$content = get_the_content($stripteaser, $more_file);
	$content = apply_filters('the_content', $content);
	$content = str_replace(']]>', ']]&gt;', $content);
	$content = preg_replace("/\< *[img][^\>]*[.]*\>/i","",$content,1);
	return $content;
}
}
if ( ! function_exists( 'modish_comments' ) ) {
function modish_comments($comment, $args, $depth) {
		$GLOBALS['comment'] = $comment;
		extract($args, EXTR_SKIP);

		if ( 'div' == $args['style'] ) {
			$tag = 'div';
			$add_below = 'comment';
		} else {
			$tag = 'li';
			$add_below = 'div-comment';
		}
?>
			<<?php echo $tag ?> <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
<?php if ( 'div' != $args['style'] ) : ?>
<?php endif; ?>
				<div class="comment-author vcard clear">
					<?php echo get_avatar($comment,$size='80'); ?>

					<h3><?php printf(__('%s', 'modish'), get_comment_author_link()) ?></h3>
					<span><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf( __('%1$s at %2$s', 'modish'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)', 'modish'),'  ','' ); ?></span>
				</div>
<?php if ($comment->comment_approved == '0') : ?>
<p style="color: #cc0000;"><?php _e('Your comment is awaiting moderation.', 'modish') ?></p>
<?php endif; ?>
<?php comment_text() ?>
				<p><?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?></p>
<?php if ( 'div' != $args['style'] ) : ?>
<?php endif; ?>
<?php }
}