<?php get_header(); ?>
<section id="title">
	<header>
<?php if (is_month()) { ?>
			<p><?php _e( 'Archive for:', 'modish' ); ?></p>
			<h1><?php the_time('F, Y'); ?></h1>
<?php } ?>
<?php if (is_category()) { ?>
			<p><?php _e( 'Category:', 'modish' ); ?></p>
			<h1><?php single_cat_title(); ?></h1>
<?php } ?>
<?php if (is_tag()) { ?>
			<p><?php _e( 'Tag:', 'modish' ); ?></p>
			<h1><?php single_cat_title(); ?></h1>
<?php } ?>
<?php if (is_author()) {
$curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));	
?>
			<p><?php _e( 'Posts by', 'modish' ); ?></p>
			<h1><?php echo $curauth->display_name; ?></h1>
<?php } ?>
	</header>
</section>
<!-- /title -->

<div class="pagewidth clear">

	<main id="left-column">
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
		<article id="post-<?php the_ID(); ?>" <?php post_class('home-article'); ?>>
			<header>
				<h1><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
				<p class="post-meta"><?php _e( 'By', 'modish' ); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta( 'display_name' ); ?></a> <?php _e( 'in', 'modish' ); ?> <?php the_category(', '); ?> <?php _e( '/', 'modish' ); ?> <?php the_time( 'F j, Y' ); ?> <?php _e( '/', 'modish' ); ?> <?php comments_popup_link( '0 Comments', '1 Comment', '% Comments', 'comments-link', 'Comments off' ); ?></p>
			</header>
			<?php the_content('Read on...'); ?>
			<p class="post-tags"><?php the_tags('', '',''); ?></p>
		</article>
		<!-- /<?php the_title(); ?> -->

<?php endwhile; ?>
		<div class="post-pages">
			<p class="previous"><?php previous_posts_link( 'Previous Page' ) ?></p>
			<p class="next"><?php next_posts_link( 'Next Page' ) ?></p>
		</div>
		<!-- /post-pages -->

<?php else: ?>
		<p><?php _e( 'Sorry, no posts matched your criteria.', 'modish' ); ?></p>

<?php endif; ?>
	</main>
	<!-- /left-column -->

<?php get_sidebar(); ?>

</div>
<!-- /pagewidth -->
<?php get_footer(); ?>