<?php

/**
 * Title: Process Steps 2
 * Slug: modestra/processs-step-2
 * Categories: modestra, about, services
 */
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"layout":{"type":"constrained","contentSize":"1180px"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--40)"><!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"64px"},"margin":{"top":"0px"}}}} -->
    <div class="wp-block-columns" style="margin-top:0px"><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
        <div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"},"position":{"type":"sticky","top":"0px"}},"layout":{"type":"constrained","contentSize":"780px","justifyContent":"left"}} -->
            <div class="wp-block-group"><!-- wp:heading -->
                <h2 class="wp-block-heading"><?php esc_html_e('How We Work', 'modestra') ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph -->
                <p><?php esc_html_e('Lorem ipsum is placeholder text commonly used in the graphic, print, and publishing industries for previewing layouts and visual mockups.', 'modestra') ?></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"style":{"spacing":{"blockGap":"60px"}}} -->
        <div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained","contentSize":"100%"}} -->
            <div class="wp-block-group" style="margin-top:0;margin-bottom:0"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column {"width":"100px"} -->
                    <div class="wp-block-column" style="flex-basis:100px"><!-- wp:heading {"level":1,"className":"is-style-modestra-heading-gradient-effect","style":{"typography":{"fontSize":"48px"}}} -->
                        <h1 class="wp-block-heading is-style-modestra-heading-gradient-effect" style="font-size:48px"><?php esc_html_e('01.', 'modestra') ?></h1>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:column -->

                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:heading {"level":4,"fontSize":"big"} -->
                        <h4 class="wp-block-heading has-big-font-size"><?php esc_html_e('Research', 'modestra') ?></h4>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph -->
                        <p><?php esc_html_e('In this initial phase, the focus is on understanding the client\'s goals, target audience, and market trends. This involves gathering data through consultations, competitor analysis, and user research to inform the project\'s direction.', 'modestra') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"layout":{"type":"constrained"}} -->
            <div class="wp-block-group"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column {"width":"100px"} -->
                    <div class="wp-block-column" style="flex-basis:100px"><!-- wp:heading {"level":1,"className":"is-style-modestra-heading-gradient-effect","style":{"typography":{"fontSize":"48px"}}} -->
                        <h1 class="wp-block-heading is-style-modestra-heading-gradient-effect" style="font-size:48px"><?php esc_html_e('02.', 'modestra') ?></h1>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:column -->

                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:heading {"level":4,"fontSize":"big"} -->
                        <h4 class="wp-block-heading has-big-font-size"><?php esc_html_e('Plan', 'modestra') ?></h4>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph -->
                        <p><?php esc_html_e('During the planning phase, the project scope, deliverables, timelines, and budget are defined. A detailed project plan is created, outlining tasks, milestones, and resource allocation to ensure a structured approach moving forward.', 'modestra') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"layout":{"type":"constrained"}} -->
            <div class="wp-block-group"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column {"width":"100px"} -->
                    <div class="wp-block-column" style="flex-basis:100px"><!-- wp:heading {"level":1,"className":"is-style-modestra-heading-gradient-effect","style":{"typography":{"fontSize":"48px"}}} -->
                        <h1 class="wp-block-heading is-style-modestra-heading-gradient-effect" style="font-size:48px"><?php esc_html_e('03.', 'modestra') ?></h1>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:column -->

                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:heading {"level":4,"fontSize":"big"} -->
                        <h4 class="wp-block-heading has-big-font-size"><?php esc_html_e('Build', 'modestra') ?></h4>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph -->
                        <p><?php esc_html_e('The build phase involves transforming the project plan into reality. Designers create wireframes and visual elements, while developers implement functionality through coding. Testing is also conducted to ensure everything works as intended.', 'modestra') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"layout":{"type":"constrained"}} -->
            <div class="wp-block-group"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column {"width":"100px"} -->
                    <div class="wp-block-column" style="flex-basis:100px"><!-- wp:heading {"level":1,"className":"is-style-modestra-heading-gradient-effect","style":{"typography":{"fontSize":"48px"}}} -->
                        <h1 class="wp-block-heading is-style-modestra-heading-gradient-effect" style="font-size:48px"><?php esc_html_e('04.', 'modestra') ?></h1>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:column -->

                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:heading {"level":4,"fontSize":"big"} -->
                        <h4 class="wp-block-heading has-big-font-size"><?php esc_html_e('Launch', 'modestra') ?></h4>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph -->
                        <p><?php esc_html_e('In the execution phase, the project is launched after final client review and approval. This includes deploying the solution and providing training and support to the client, ensuring they can effectively use the new system. Ongoing maintenance and optimization may also be addressed as needed.', 'modestra') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->