<?php

/**
 * Title: FAQ Layout with Dark Background
 * Slug: modestra/faq-list-dark
 * Categories: modestra-accordion
 */
?>
<!-- wp:group {"metadata":{"categories":["modestra-accordion"],"patternName":"modestra/faq-layout-3","name":"FAQ Section"},"style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"120px","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"backgroundColor":"dark-shade","layout":{"type":"constrained","contentSize":"780px"}} -->
<div class="wp-block-group has-dark-shade-background-color has-background" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--40);padding-bottom:120px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40","margin":{"bottom":"48px"}}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group" style="margin-bottom:48px"><!-- wp:heading {"textAlign":"center","level":5,"className":"is-style-modestra-heading-gradient-effect","style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"medium"} -->
        <h5 class="wp-block-heading has-text-align-center is-style-modestra-heading-gradient-effect has-heading-color-color has-text-color has-link-color has-medium-font-size"><?php esc_html_e('FAQ', 'modestra') ?></h5>
        <!-- /wp:heading -->

        <!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"xx-large"} -->
        <h1 class="wp-block-heading has-text-align-center has-light-color-color has-text-color has-link-color has-xx-large-font-size" style="font-style:normal;font-weight:600"><?php esc_html_e('We’ve Got You Covered!', 'modestra') ?></h1>
        <!-- /wp:heading -->
    </div>
    <!-- /wp:group -->

    <!-- wp:group {"style":{"spacing":{"margin":{"top":"0px"},"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group" style="margin-top:0px"><!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What is Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress refers to a feature that allows users to create and edit their website’s entire layout, including the header, footer, and other structural elements, using a visual editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What are the benefits of Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress allows users to create and edit their website more efficiently and with more control. It enables users to create unique and custom designs without needing to have advanced coding skills.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What is Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress refers to a feature that allows users to create and edit their website’s entire layout, including the header, footer, and other structural elements, using a visual editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What are the benefits of Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress allows users to create and edit their website more efficiently and with more control. It enables users to create unique and custom designs without needing to have advanced coding skills.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"is-style-default","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"16px","bottom":"16px","left":"20px","right":"20px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"medium"} -->
        <details class="wp-block-details is-style-default has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-medium-font-size" style="padding-top:16px;padding-right:20px;padding-bottom:16px;padding-left:20px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What are some popular WordPress themes that support Full Site Editing?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Some popular WordPress themes that support Full Site Editing include the FotaWP Theme, ReviveNews Theme, and the Hello Agency Theme. These themes have built-in support for Full Site Editing, allowing users to create custom designs without needing to know how to code.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->