<?php

/**
 * Title: FAQ Layout 3
 * Slug: modestra/faq-layout-3
 * Categories: modestra-accordion
 */
?>
<!-- wp:group {"metadata":{"categories":["modestra-accordion"],"patternName":"modestra/faq-section","name":"FAQ Section"},"style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"120px","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"backgroundColor":"primary-shade","layout":{"type":"constrained","contentSize":"780px"}} -->
<div class="wp-block-group has-primary-shade-background-color has-background" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--40);padding-bottom:120px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40","margin":{"bottom":"48px"}}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group" style="margin-bottom:48px"><!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"typography":{"textTransform":"uppercase"}},"textColor":"heading-color","fontSize":"normal"} -->
        <p class="has-text-align-center has-heading-color-color has-text-color has-link-color has-normal-font-size" style="text-transform:uppercase"><?php esc_html_e('FAQ', 'modestra') ?></p>
        <!-- /wp:paragraph -->

        <!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"xx-large"} -->
        <h1 class="wp-block-heading has-text-align-center has-xx-large-font-size" style="font-style:normal;font-weight:600"><?php esc_html_e('We’ve Got You Covered!', 'modestra') ?></h1>
        <!-- /wp:heading -->
    </div>
    <!-- /wp:group -->

    <!-- wp:group {"style":{"spacing":{"margin":{"top":"0px"},"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group" style="margin-top:0px"><!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What is Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress refers to a feature that allows users to create and edit their website’s entire layout, including the header, footer, and other structural elements, using a visual editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What are the benefits of Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress allows users to create and edit their website more efficiently and with more control. It enables users to create unique and custom designs without needing to have advanced coding skills.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What is Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress refers to a feature that allows users to create and edit their website’s entire layout, including the header, footer, and other structural elements, using a visual editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What are the benefits of Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Full Site Editing in WordPress allows users to create and edit their website more efficiently and with more control. It enables users to create unique and custom designs without needing to have advanced coding skills.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('How do I enable Full Site Editing in WordPress?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('To enable Full Site Editing in WordPress, you need to ensure that you are using a compatible WordPress theme that supports Full Site Editing. You will also need to install the latest version of WordPress and enable the Gutenberg editor.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->

        <!-- wp:details {"className":"modestra-faq-block","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"spacing":{"padding":{"top":"24px","bottom":"24px","left":"24px","right":"24px"}}},"backgroundColor":"light-color","textColor":"heading-color","fontSize":"normal","fontFamily":"unbounded"} -->
        <details class="wp-block-details modestra-faq-block has-heading-color-color has-light-color-background-color has-text-color has-background has-link-color has-unbounded-font-family has-normal-font-size" style="padding-top:24px;padding-right:24px;padding-bottom:24px;padding-left:24px;font-style:normal;font-weight:500">
            <summary><?php esc_html_e('What are some popular WordPress themes that support Full Site Editing?', 'modestra') ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground","fontSize":"normal","fontFamily":"urbanist"} -->
            <p class="has-foreground-color has-text-color has-link-color has-urbanist-font-family has-normal-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Some popular WordPress themes that support Full Site Editing include the FotaWP Theme, ReviveNews Theme, and the Hello Agency Theme. These themes have built-in support for Full Site Editing, allowing users to create custom designs without needing to know how to code.', 'modestra') ?></p>
            <!-- /wp:paragraph -->
        </details>
        <!-- /wp:details -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->