<?php

/**
 * Title: Highlight Features
 * Slug: modestra/about-highlight-features
 * Categories: about
 */
$modestra_url = trailingslashit(get_template_directory_uri());
$modestra_images = array(
    $modestra_url . 'assets/images/streaks_icon.png',
    $modestra_url . 'assets/images/about_9.jpg',
);
?>
<!-- wp:group {"metadata":{"categories":["about"],"patternName":"modestra/about-highlight-features","name":"Highlight Features"},"style":{"spacing":{"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40","top":"100px","bottom":"120px"}}},"backgroundColor":"primary-shade","layout":{"type":"constrained","contentSize":"1180px"}} -->
<div class="wp-block-group has-primary-shade-background-color has-background" style="padding-top:100px;padding-right:var(--wp--preset--spacing--40);padding-bottom:120px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:group {"layout":{"type":"constrained","contentSize":"840px","justifyContent":"left"}} -->
    <div class="wp-block-group"><!-- wp:heading {"textAlign":"left","level":1,"className":"is-style-modestra-heading-gradient-effect","style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color"} -->
        <h1 class="wp-block-heading has-text-align-left is-style-modestra-heading-gradient-effect has-heading-color-color has-text-color has-link-color"><?php esc_html_e('Benefits &amp; Features', 'modestra') ?></h1>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"textColor":"foreground"} -->
        <p class="has-text-align-left has-foreground-color has-text-color has-link-color"><?php esc_html_e('Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur.', 'modestra') ?></p>
        <!-- /wp:paragraph -->
    </div>
    <!-- /wp:group -->

    <!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"left":"64px"},"margin":{"top":"64px"},"padding":{"bottom":"0px"}},"border":{"bottom":{"width":"0px","style":"none"}}}} -->
    <div class="wp-block-columns are-vertically-aligned-center" style="border-bottom-style:none;border-bottom-width:0px;margin-top:64px;padding-bottom:0px"><!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
        <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%"><!-- wp:columns -->
            <div class="wp-block-columns"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:image {"id":4906,"width":"28px","height":"28px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|primary-white"}}} -->
                    <figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url($modestra_images[0]) ?>" alt="" class="wp-image-4906" style="object-fit:cover;width:28px;height:28px" /></figure>
                    <!-- /wp:image -->

                    <!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"18px"}},"textColor":"foreground"} -->
                    <p class="has-foreground-color has-text-color has-link-color" style="font-size:18px"><?php esc_html_e('Sed ut perspiciatis unde omnis iste natus accusantium dolore mque laudantium, totam rem aperiam.', 'modestra') ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:column -->

                <!-- wp:column -->
                <div class="wp-block-column"><!-- wp:image {"id":4906,"width":"28px","height":"28px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|primary-white"}}} -->
                    <figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url($modestra_images[0]) ?>" alt="" class="wp-image-4906" style="object-fit:cover;width:28px;height:28px" /></figure>
                    <!-- /wp:image -->

                    <!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"18px"}},"textColor":"foreground"} -->
                    <p class="has-foreground-color has-text-color has-link-color" style="font-size:18px"><?php esc_html_e('Sed ut perspiciatis unde omnis iste natus accusantium dolore mque laudantium, totam rem aperiam.', 'modestra') ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:column -->
            </div>
            <!-- /wp:columns -->

            <!-- wp:columns {"style":{"spacing":{"margin":{"top":"48px"}}}} -->
            <div class="wp-block-columns" style="margin-top:48px"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:image {"id":4906,"width":"28px","height":"28px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|primary-white"}}} -->
                    <figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url($modestra_images[0]) ?>" alt="" class="wp-image-4906" style="object-fit:cover;width:28px;height:28px" /></figure>
                    <!-- /wp:image -->

                    <!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"18px"}},"textColor":"foreground"} -->
                    <p class="has-foreground-color has-text-color has-link-color" style="font-size:18px"><?php esc_html_e('Sed ut perspiciatis unde omnis iste natus accusantium dolore mque laudantium, totam rem aperiam.', 'modestra') ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:column -->

                <!-- wp:column -->
                <div class="wp-block-column"><!-- wp:image {"id":4906,"width":"28px","height":"28px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|primary-white"}}} -->
                    <figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url($modestra_images[0]) ?>" alt="" class="wp-image-4906" style="object-fit:cover;width:28px;height:28px" /></figure>
                    <!-- /wp:image -->

                    <!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"18px"}},"textColor":"foreground"} -->
                    <p class="has-foreground-color has-text-color has-link-color" style="font-size:18px"><?php esc_html_e('Sed ut perspiciatis unde omnis iste natus accusantium dolore mque laudantium, totam rem aperiam.', 'modestra') ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:column -->
            </div>
            <!-- /wp:columns -->

            <!-- wp:buttons {"className":"is-style-buttons-hover-translate-effect","style":{"spacing":{"blockGap":"var:preset|spacing|30","margin":{"top":"48px","bottom":"0px"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
            <div class="wp-block-buttons is-style-buttons-hover-translate-effect" style="margin-top:48px;margin-bottom:0px"><!-- wp:button {"textColor":"light-color","gradient":"gradient-primary-secondary","className":"is-style-button-gradient-background-style","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"border":{"radius":"60px","width":"0px","style":"none"},"typography":{"textTransform":"none","fontStyle":"normal","fontWeight":"500"},"spacing":{"padding":{"left":"32px","right":"32px","top":"18px","bottom":"18px"}}},"fontSize":"normal"} -->
                <div class="wp-block-button has-custom-font-size is-style-button-gradient-background-style has-normal-font-size" style="font-style:normal;font-weight:500;text-transform:none"><a class="wp-block-button__link has-light-color-color has-gradient-primary-secondary-gradient-background has-text-color has-background has-link-color wp-element-button" style="border-style:none;border-width:0px;border-radius:60px;padding-top:18px;padding-right:32px;padding-bottom:18px;padding-left:32px"><?php esc_html_e('Book an Appointment', 'modestra') ?></a></div>
                <!-- /wp:button -->
            </div>
            <!-- /wp:buttons -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center"} -->
        <div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":4846,"sizeSlug":"full","linkDestination":"none","align":"right","style":{"border":{"radius":"40px"},"color":{"duotone":"var:preset|duotone|white-primary"}}} -->
            <figure class="wp-block-image alignright size-full has-custom-border"><img src="<?php echo esc_url($modestra_images[1]) ?>" alt="" class="wp-image-4846" style="border-radius:40px" /></figure>
            <!-- /wp:image -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->