<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="skip-content" role="main">

	<?php do_action( 'luzuk_modern_salon_above_slider' ); ?>

	<?php if( get_theme_mod('luzuk_modern_salon_slider_hide_show') != ''){ ?>
		<section id="slider">
			<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
			    <?php $luzuk_modern_salon_slider_pages = array();
			    for ( $count = 1; $count <= 4; $count++ ) {
			        $mod = intval( get_theme_mod( 'luzuk_modern_salon_slider'. $count ));
			        if ( 'page-none-selected' != $mod ) {
			          $luzuk_modern_salon_slider_pages[] = $mod;
			        }
			    }
		      	if( !empty($luzuk_modern_salon_slider_pages) ) :
			        $args = array(
			          	'post_type' => 'page',
			          	'post__in' => $luzuk_modern_salon_slider_pages,
			          	'orderby' => 'post__in'
			        );
		        	$query = new WP_Query( $args );
		        if ( $query->have_posts() ) :
		          	$i = 1;
		    	?>     
				    <div class="carousel-inner" role="listbox">
				      	<?php  while ( $query->have_posts() ) : $query->the_post(); ?>
					        <div <?php if($i == 1){echo 'class="carousel-item fade-in-image active"';} else{ echo 'class="carousel-item fade-in-image"';}?>>
					        	<div class="slide-imgbx ">
						        	<!-- <div class="sliderimg "> -->
										<img class="slide-mainimg" src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
										<?php
											$luzuk_modern_salon_slider_effect = get_theme_mod('luzuk_modern_salon_slider_effect', '') 
										?>	
										<div class="content <?php echo ($luzuk_modern_salon_slider_effect); ?>">
											<?php 
												$luzuk_modern_salon_slider_excerpt_length = get_theme_mod('luzuk_modern_salon_slider_excerpt_length','15');
											
												if( $luzuk_modern_salon_slider_excerpt_length != ''){?>
												<p class="mb-0"><?php $luzuk_modern_salon_excerpt = get_the_excerpt(); echo esc_html( luzuk_modern_salon_string_limit_words( $luzuk_modern_salon_excerpt, esc_attr(get_theme_mod('luzuk_modern_salon_slider_excerpt_length','15') ) )); ?></p>
											<?php } ?>
											<h2><?php the_title(); ?></h2>
											<a href="<?php echo esc_url(get_theme_mod('luzuk_modern_salon_sliderbtnlink')) ?>" class="read-btn sbtn1">
												<span><?php esc_html_e('Our Services','modern-salon'); ?></span>
											</a>
										</div>
										<!-- <div class="shape"></div> -->
						        </div>
								
					        </div>
				      	<?php $i++; endwhile; 
				      	wp_reset_postdata();?>
				    </div>
			    <?php else : ?>
			    	<div class="no-postfound"></div>
	      		<?php endif;
			    endif;?>
			    <!-- <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
			      	<span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-long-arrow-alt-left"></i></span>
			      	<span class="screen-reader-text"><//?php esc_html_e( 'Prev','modern-salon' );?></span>
			    </a>
			    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
			      	<span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-long-arrow-alt-right"></i></span>
			      	<span class="screen-reader-text"><//?php esc_html_e( 'Next','modern-salon' );?></span>
			    </a> -->
			</div>
			
		  	<div class="clearfix"></div>
		</section>
	<?php }?>
	
	<?php do_action('luzuk_modern_salon_below_slider'); ?>

		<section id="bannerdiscount-section">
			<div class="discount-area" id="discount">
				<div class="discount-areabx">
					<div class="marquee">
						<div class="marquee_text">
							<span class="inner-area-title">
								<svg width="10" height="10">
								<path id="Polygon_1" data-name="Polygon 1" d="M5,0,6.275,3.725,10,5,6.275,6.275,5,10,3.725,6.275,0,5,3.725,3.725Z"></path>
								</svg>
								<?php echo esc_html(get_theme_mod('luzuk_modern_salon_bannerdiscountoffertxt1')); ?>
							</span>
							<span class="inner-area-title">
								<svg width="10" height="10">
								<path id="Polygon_1" data-name="Polygon 1" d="M5,0,6.275,3.725,10,5,6.275,6.275,5,10,3.725,6.275,0,5,3.725,3.725Z"></path>
								</svg>
								<?php echo esc_html(get_theme_mod('luzuk_modern_salon_bannerdiscountoffertxt2')); ?>
							</span>
							<span class="inner-area-title">
								<svg width="10" height="10">
								<path id="Polygon_1" data-name="Polygon 1" d="M5,0,6.275,3.725,10,5,6.275,6.275,5,10,3.725,6.275,0,5,3.725,3.725Z"></path>
								</svg>
								<?php echo esc_html(get_theme_mod('luzuk_modern_salon_bannerdiscountoffertxt3')); ?>
							</span>
							<span class="inner-area-title">
								<svg width="10" height="10">
								<path id="Polygon_1" data-name="Polygon 1" d="M5,0,6.275,3.725,10,5,6.275,6.275,5,10,3.725,6.275,0,5,3.725,3.725Z"></path>
								</svg>
								<?php echo esc_html(get_theme_mod('luzuk_modern_salon_bannerdiscountoffertxt4')); ?>
							</span>
						</div>
					</div>
				</div>
			</div>
		</section>

	<?php do_action('luzuk_modern_salon_below_bannerdiscount_section'); ?>

	<?php if( get_theme_mod('luzuk_modern_salon_feature_category_settingleft') != '' ){?>
		<section id="feature-section" class="py-5">
			<div class="container"> 
				<div class="heading">
					<h2>
						<?php echo esc_html(get_theme_mod('luzuk_modern_salon_feature_head')); ?>
					</h2>
				</div>
				<div class="row m-0">  
					<div class=" f_left">
				<?php $luzuk_modern_salon_catData1 =  get_theme_mod('luzuk_modern_salon_feature_category_settingleft');
				if($luzuk_modern_salon_catData1){ 
					$args = array(
						'post_type' => 'post',
						'category_name' => $luzuk_modern_salon_catData1,
						'posts_per_page' => 3
					);
					$i=1; ?>
					<?php $query = new WP_Query( $args );
					if ( $query->have_posts() ) :
						while( $query->have_posts() ) : $query->the_post(); ?>
						<div class="single-feature-bx">
							<div class="feature-box">
								<div class="row m-0">
									<div class="col-lg-3 col-md-3 col-sm-3 col-3 pd-0">
										<div class="iconbx">
											<div class="icon">
												<i class="<?php echo esc_attr(get_theme_mod('luzuk_modern_salon_feature_iconleft' . $i, 'fas fa-cut')); ?>"></i>
											</div>
										</div>
									</div>
									<div class="col-lg-9 col-md-9 col-sm-9 col-9">
										<div class="feature-content">
											<a href="<?php the_permalink(); ?>"><h4><?php the_title_attribute(); ?></h4></a>
											<?php 
												$luzuk_modern_salon_feature_excerpt_length = get_theme_mod('luzuk_modern_salon_feature_excerpt_length','15');
											
												if( $luzuk_modern_salon_feature_excerpt_length != ''){?>
												<p class="mb-0"><?php $luzuk_modern_salon_excerpt = get_the_excerpt(); echo esc_html( luzuk_modern_salon_string_limit_words( $luzuk_modern_salon_excerpt, esc_attr(get_theme_mod('luzuk_modern_salon_feature_excerpt_length','15') ) )); ?></p>
											<?php } ?>
										</div>
									</div>
									<div class="clearfix"></div>
								</div>
							</div>
						</div>
						<?php $i++; endwhile; 
						wp_reset_postdata(); ?>
					<?php else : ?>
						<div class="no-postfound"></div>
					<?php endif; ?>
				<?php }?>
					</div>
					<div class="f_midd">
						<div class="feature-img">
						<?php 
							$luzuk_modern_salon_feature_image = get_theme_mod('luzuk_modern_salon_feature_image');

							if(!empty($luzuk_modern_salon_feature_image)){
								echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($luzuk_modern_salon_feature_image).'" class="img-responsive secondry-bg-img" />';
							}else{
								echo '<img alt="luzuk_modern_salon_feature_image" src="'.get_template_directory_uri().'/assets/images/feature.png" class="img-responsive" />';
							}
						?>
						</div>
					</div>
					<div class=" f_right">
						<?php $luzuk_modern_salon_catData1 =  get_theme_mod('luzuk_modern_salon_feature_category_settingright');
						if($luzuk_modern_salon_catData1){ 
							$args = array(
								'post_type' => 'post',
								'category_name' => $luzuk_modern_salon_catData1,
								'posts_per_page' => 3
							);
							$i=1; ?>
							<?php $query = new WP_Query( $args );
							if ( $query->have_posts() ) :
								while( $query->have_posts() ) : $query->the_post(); ?>
						<div class="single-feature-bx">
							<div class="feature-box">
								<div class="row m-0">
									<div class="col-lg-9 col-md-9 col-sm-9 col-9">
										<div class="feature-content">
											<a href="<?php the_permalink(); ?>"><h4><?php the_title_attribute(); ?></h4></a>
											<?php 
												$luzuk_modern_salon_feature_excerpt_length = get_theme_mod('luzuk_modern_salon_feature_excerpt_length','15');
											
												if( $luzuk_modern_salon_feature_excerpt_length != ''){?>
												<p class="mb-0"><?php $luzuk_modern_salon_excerpt = get_the_excerpt(); echo esc_html( luzuk_modern_salon_string_limit_words( $luzuk_modern_salon_excerpt, esc_attr(get_theme_mod('luzuk_modern_salon_feature_excerpt_length','15') ) )); ?></p>
											<?php } ?>
										</div>
									</div>
									<div class="col-lg-3 col-md-3 col-sm-3 col-3 pd-0">
										<div class="iconbx">
											<div class="icon">
												<i class="<?php echo esc_attr(get_theme_mod('luzuk_modern_salon_feature_iconright' . $i, 'fas fa-cut')); ?>"></i>
											</div>
										</div>
									</div>
									<div class="clearfix"></div>
								</div>
							</div>
						</div>
								<?php $i++; endwhile; 
								wp_reset_postdata(); ?>
							<?php else : ?>
								<div class="no-postfound"></div>
							<?php endif; ?>
						<?php }?>
					</div>
				</div>
			</div>
		</section>
	<?php }?>

	<?php do_action('luzuk_modern_salon_below_feature_section'); ?>

	<section id="aboutus-section" class="py-5">
		<div class="abt-oly"></div>
		<div class="container"> 
			<div class="row mr-0"> 
				
				<div class="col-lg-6 col-md-12 col-sm-12 r-abt">
					<h1><?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutusheading')); ?></h1>
					<h2><?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutustitle')); ?></h2>
					<p><?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutusdescription')); ?></p>
					<div class="row mr-0 fdsa"> 
						<div class="col-lg-6 col-md-6 col-sm-12">

							<div class="row tmbx"> 
								<div class="col-lg-2 col-md-1 col-sm-1 col-1 pl-0">
									<div class="icn">
										<i class="<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutuspoint1_icon')); ?>"></i>
									</div>
								</div>
								<div class="col-lg-10 col-md-11 col-sm-11 col-11 pd-0">
									<h4><?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutuspoint1')); ?></h4>
								</div>
							</div>

							<div class="row tmbx"> 
								<div class="col-lg-2 col-md-1 col-sm-1 col-1 pl-0">
									<div class="icn">
										<i class="<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutuspoint2_icon')); ?>"></i>
									</div>
								</div>
								<div class="col-lg-10 col-md-11 col-sm-11 col-11 pd-0">
									<h4><?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutuspoint2')); ?></h4>
								</div>
							</div>

							<div class="row tmbx"> 
								<div class="col-lg-2 col-md-1 col-sm-1 col-1 pl-0">
									<div class="icn">
										<i class="<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutuspoint3_icon')); ?>"></i>
									</div>
								</div>
								<div class="col-lg-10 col-md-11 col-sm-11 col-11 pd-0">
									<h4><?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutuspoint3')); ?></h4>
								</div>
							</div>

						</div>	
						<div class="col-lg-6 col-md-6 col-sm-12 cll-btn">
							<a href="tel:<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutus_phnnum')); ?>" class="read-btn">
								<div class="rbtn_oly"></div>
								<div class="row m-0">
									<div class="col-2 pd-0">
										<div class="p-icn">
											<i class="fa fa-phone" aria-hidden="true"></i>
										</div>
									</div>
									<div class="col-10">
										<div class="r-btn">
											<?php echo esc_html('CALL NOW','modern-salon'); ?><br>
											<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutus_phnnum')); ?>
										</div>
									</div>
								</div>
							</a>
						</div>			
					</div>	
					
				</div> 
				<div class="col-lg-6 col-md-12 col-sm-12">
					<div class="aboutus-image">
						<?php 
							$luzuk_modern_salon_aboutus_rightimage = get_theme_mod('luzuk_modern_salon_aboutus_rightimage');

							if(!empty($luzuk_modern_salon_aboutus_rightimage)){
								echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($luzuk_modern_salon_aboutus_rightimage).'" class="img-responsive secondry-bg-img" />';
							}else{
								echo '<img alt="luzuk_modern_salon_aboutus_rightimage" src="'.get_template_directory_uri().'/assets/images/about.jpg" class="img-responsive" />';
							}
						?>
						<div class="imgtxt">
							<div class="row m-0">
								<div class="col-lg-3 col-md-3 col-sm-3 col-3 pd-0">
									<h3 class="yearnum">
										<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutus_headingnum')); ?>											
									</h3>
								</div>
								<div class="col-lg-9 col-md-9 col-sm-9 col-9 ">
									<h2 class="yeartext">
										<?php echo esc_html(get_theme_mod('luzuk_modern_salon_aboutus_imageheadingtext')); ?>
									</h2>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>

	<?php do_action('luzuk_modern_salon_below_feature_section'); ?>

	<div class="container">
	  	<?php while ( have_posts() ) : the_post(); ?>
	  		<div class="lz-content">
	        	<?php the_content(); ?>
	        </div>
	    <?php endwhile; // end of the loop. ?>
	</div>
</main>

<?php get_footer(); ?>