<?php
/**
 * Modern Salon: Customizer
 *
 * @subpackage Modern Salon
 * @since 1.0
 */

use WPTRT\Customize\Section\Luzuk_Modern_Salon_Button;

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Luzuk_Modern_Salon_Button::class );

	$manager->add_section(
		new Luzuk_Modern_Salon_Button( $manager, 'luzuk_modern_salon_pro', [
			'title' => __( 'Modern Salon Pro', 'modern-salon' ),
			'priority' => 0,
			'button_text' => __( 'Go Pro', 'modern-salon' ),
			'button_url'  => esc_url( 'https://www.luzuk.com/products/salon-wp-theme/', 'modern-salon')
		] )
	);

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'modern-salon-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'modern-salon-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

function luzuk_modern_salon_customize_register( $wp_customize ) {

	$wp_customize->add_setting('luzuk_modern_salon_logo_size',array(
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','modern-salon'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('luzuk_modern_salon_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('luzuk_modern_salon_logo_padding',array(
		'label' => __('Logo Margin','modern-salon'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('luzuk_modern_salon_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','modern-salon'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_modern_salon_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','modern-salon'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_modern_salon_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','modern-salon'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_modern_salon_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
 	));
 	$wp_customize->add_control('luzuk_modern_salon_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','modern-salon'),
		'section' => 'title_tagline',
    ));

	$wp_customize->add_setting('luzuk_modern_salon_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_modern_salon_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','modern-salon'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_site_title_color', array(
		'label' => 'Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('luzuk_modern_salon_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_modern_salon_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','modern-salon'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_site_tagline_color', array(
		'label' => 'Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'luzuk_modern_salon_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'modern-salon' ),
		'description' => __( 'Description of what this panel does.', 'modern-salon' ),
	) );

	$wp_customize->add_section( 'luzuk_modern_salon_theme_options_section', array(
    	'title'      => __( 'General Settings', 'modern-salon' ),
		'priority'   => 30,
		'panel' => 'luzuk_modern_salon_panel_id'
	) );

	$wp_customize->add_setting('luzuk_modern_salon_theme_options',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_modern_salon_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','modern-salon'),
		'section' => 'luzuk_modern_salon_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','modern-salon'),
		   'Right Sidebar' => __('Right Sidebar','modern-salon'),
		   'One Column' => __('One Column','modern-salon'),
		   'Grid Layout' => __('Grid Layout','modern-salon')
		),
	));

	$wp_customize->add_setting('luzuk_modern_salon_single_post_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_modern_salon_single_post_sidebar',array(
        'type' => 'select',
        'label' => __('Single Post Sidebar Layout','modern-salon'),
        'section' => 'luzuk_modern_salon_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','modern-salon'),
            'Right Sidebar' => __('Right Sidebar','modern-salon'),
            'One Column' => __('One Column','modern-salon')
        ),
	));

	$wp_customize->add_setting('luzuk_modern_salon_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_modern_salon_page_sidebar',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','modern-salon'),
        'section' => 'luzuk_modern_salon_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','modern-salon'),
            'Right Sidebar' => __('Right Sidebar','modern-salon'),
            'One Column' => __('One Column','modern-salon')
        ),
	));

	$wp_customize->add_setting('luzuk_modern_salon_archive_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_modern_salon_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','modern-salon'),
        'section' => 'luzuk_modern_salon_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','modern-salon'),
            'Right Sidebar' => __('Right Sidebar','modern-salon'),
            'One Column' => __('One Column','modern-salon'),
            'Grid Layout' => __('Grid Layout','modern-salon')
        ),
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	
	$wp_customize->add_control( 'luzuk_modern_salon_boxfull_width', array(
		'label'    => __( 'Section Width', 'modern-salon' ),
		'section'  => 'luzuk_modern_salon_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'modern-salon'),
			'container-fluid' => __('Full Width', 'modern-salon'),
			'none' => __('None', 'modern-salon')
		),
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	$wp_customize->add_control( 'luzuk_modern_salon_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'modern-salon' ),
		'section'  => 'luzuk_modern_salon_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'modern-salon'),
			'fadeInUp' => __('fadeInUp', 'modern-salon'),
			'zoomIn'    => __('zoomIn', 'modern-salon'),
			'None'    => __('None', 'modern-salon')
		),
	));

	//Header
	$wp_customize->add_section( 'luzuk_modern_salon_header' , array(
    	'title'    => __( 'Header Section', 'modern-salon' ),
		'priority' => null,
		'panel' => 'luzuk_modern_salon_panel_id'
	) );

	$wp_customize->add_setting('luzuk_modern_salon_header_btntext',array(
    	'default' => 'Book Now',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_header_btntext',array(
	   	'type' => 'text',
	   	'label' => __('Header Button Text','modern-salon'),
	   	'section' => 'luzuk_modern_salon_header',
	));

	$wp_customize->add_setting('luzuk_modern_salon_header_btnlink',array(
    	'default' => '#',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_header_btnlink',array(
	   	'type' => 'text',
	   	'label' => __('Header Button Link','modern-salon'),
	   	'section' => 'luzuk_modern_salon_header',
	));


	$wp_customize->add_setting( 'luzuk_modern_salon_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_menuicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_menuicon_color', array(
		'label' => 'Menu Icon Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_menuhover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_menuhover_color', array(
		'label' => 'Menu Hover Color',
		'section' => 'luzuk_modern_salon_header',
	)));


	$wp_customize->add_setting( 'luzuk_modern_salon_submenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_submenu_color', array(
		'label' => 'Submenu Text Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_submenubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_submenubg_color', array(
		'label' => 'Submenu BG Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_submenuhover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_submenuhover_color', array(
		'label' => 'Submenu Text Hover Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_submenubghrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_submenubghrv_color', array(
		'label' => 'Submenu BG Hover Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_headerbtntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_headerbtntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_headerbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_headerbtnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_headerbtnbganimation_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_headerbtnbganimation_color', array(
		'label' => 'Button BG Animation Color',
		'section' => 'luzuk_modern_salon_header',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_btntexthrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_btntexthrv_color', array(
		'label' => 'Button Text Hover Color',
		'section' => 'luzuk_modern_salon_header',
	)));


	//home page slider
	$wp_customize->add_section( 'luzuk_modern_salon_slider_section' , array(
    	'title'    => __( 'Slider Settings', 'modern-salon' ),
		'description'=> __('<b>Note :</b> Please Add Image in 600*510 Ratio.','modern-salon'),
		'priority' => null,
		'panel' => 'luzuk_modern_salon_panel_id'
	) );

	$wp_customize->add_setting('luzuk_modern_salon_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_modern_salon_slider_hide_show',array(
	   	'type' => 'checkbox',
	   	'label' => __('Show / Hide Slider','modern-salon'),
	   	'section' => 'luzuk_modern_salon_slider_section',
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices'
	));
	$wp_customize->add_control( 'luzuk_modern_salon_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'modern-salon' ),
		'section'  => 'luzuk_modern_salon_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'modern-salon'),
			'bounceInRight' => __('bounceInRight', 'modern-salon'),
			'bounceInUp'    => __('bounceInUp', 'modern-salon'),
			'bounceInDown'    => __('bounceInDown', 'modern-salon'),
			'zoomIn'  => __('zoomIn', 'modern-salon'),
			'zoomOut' => __('zoomOut', 'modern-salon'),
			'fadeInDown'    => __('fadeInDown', 'modern-salon'),
			'fadeInUp'    => __('fadeInUp', 'modern-salon'),
			'fadeInLeft'  => __('fadeInLeft', 'modern-salon'),
			'fadeInRight' => __('fadeInRight', 'modern-salon'),
			'flip-up'    => __('flip-up', 'modern-salon'),
			'none'    => __('none', 'modern-salon')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'luzuk_modern_salon_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'luzuk_modern_salon_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'luzuk_modern_salon_slider' . $count, array(
			'label' => __('Select Slider Image Page', 'modern-salon' ),
			'section' => 'luzuk_modern_salon_slider_section',
			'type' => 'dropdown-pages'
		));
	}


	$wp_customize->add_setting('luzuk_modern_salon_slider_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Description Excerpt Length','modern-salon'),
		'section' => 'luzuk_modern_salon_slider_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_sliderbtnlink',array(
    	'default' => '#',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('luzuk_modern_salon_sliderbtnlink',array(
	   	'type' => 'url',
	   	'label' => __('Slider Button Link','modern-salon'),
	   	'section' => 'luzuk_modern_salon_slider_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_slider_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_slider_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','modern-salon'),
		'section' => 'luzuk_modern_salon_slider_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_slider_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_slider_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','modern-salon'),
		'section' => 'luzuk_modern_salon_slider_section',
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_slider_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_slider_title_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_modern_salon_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_slider_subtitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_slider_subtitle_color', array(
		'label' => 'Sub Title Color',
		'section' => 'luzuk_modern_salon_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_slider_btntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_slider_btntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_modern_salon_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_slider_btnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_modern_salon_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_slider_btntexthrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_slider_btntexthrv_color', array(
		'label' => 'Button Hover Color',
		'section' => 'luzuk_modern_salon_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_sliderbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_sliderbg_color', array(
		'label' => 'Content Bg Color',
		'section' => 'luzuk_modern_salon_slider_section',
	)));

	//bannerdiscount Section
	$wp_customize->add_section('luzuk_modern_salon_bannerdiscount_section',array(
		'title'	=> __('Banner Discount Section','modern-salon'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','modern-salon'),
		'panel' => 'luzuk_modern_salon_panel_id',
	));

	$wp_customize->add_setting('luzuk_modern_salon_bannerdiscountoffertxt1',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_bannerdiscountoffertxt1',array(
	   	'type' => 'text',
	   	'label' => __('Offer Text 1','modern-salon'),
	   	'section' => 'luzuk_modern_salon_bannerdiscount_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_bannerdiscountoffertxt2',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_bannerdiscountoffertxt2',array(
	   	'type' => 'text',
	   	'label' => __('Offer Text 2','modern-salon'),
	   	'section' => 'luzuk_modern_salon_bannerdiscount_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_bannerdiscountoffertxt3',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_bannerdiscountoffertxt3',array(
	   	'type' => 'text',
	   	'label' => __('Offer Text 3','modern-salon'),
	   	'section' => 'luzuk_modern_salon_bannerdiscount_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_bannerdiscountoffertxt4',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_bannerdiscountoffertxt4',array(
	   	'type' => 'text',
	   	'label' => __('Offer Text 4','modern-salon'),
	   	'section' => 'luzuk_modern_salon_bannerdiscount_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_bannerdiscountoffertxt_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_bannerdiscountoffertxt_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','modern-salon'),
		'section' => 'luzuk_modern_salon_bannerdiscount_section',
	));
	
	$wp_customize->add_setting( 'luzuk_modern_salon_bannerdiscount_icon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_bannerdiscount_icon_color', array(
		'label' => 'Icon Color',
		'section' => 'luzuk_modern_salon_bannerdiscount_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_bannerdiscount_text_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_bannerdiscount_text_color', array(
		'label' => 'Text Color',
		'section' => 'luzuk_modern_salon_bannerdiscount_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_bannerdiscount_bg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_bannerdiscount_bg_color', array(
		'label' => 'BG Color',
		'section' => 'luzuk_modern_salon_bannerdiscount_section',
	)));



	//feature Section
	$wp_customize->add_section('luzuk_modern_salon_feature_section',array(
		'title'	=> __('Feature Section','modern-salon'),
		'description'=> __('<b>Note :</b> This section will appear below the Banner Discount Section.','modern-salon'),
		'panel' => 'luzuk_modern_salon_panel_id',
	));


	$wp_customize->add_setting('luzuk_modern_salon_feature_head',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_feature_head',array(
	   	'type' => 'text',
	   	'label' => __('Heading','modern-salon'),
	   	'section' => 'luzuk_modern_salon_feature_section',
	));


	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('luzuk_modern_salon_feature_category_settingleft',array(
		'default' => 'select',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices',
	));
	$wp_customize->add_control('luzuk_modern_salon_feature_category_settingleft',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Left Side Posts','modern-salon'),
		'section' => 'luzuk_modern_salon_feature_section',
	));

	for ($i=1; $i <= 3; $i++) { 
		$wp_customize->add_setting('luzuk_modern_salon_feature_iconleft' . $i, array(
		   'default' => 'fas fa-cut',
		   'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control(new luzuk_modern_salon_Fontawesome_Icon_Chooser($wp_customize, 'luzuk_modern_salon_feature_iconleft' . $i, array(
		   'section' => 'luzuk_modern_salon_feature_section',
		   'type' => 'icon',
		   'label' => esc_html__('Feature Left Icon ', 'modern-salon') . $i
	   )));
 }

	
	$wp_customize->add_setting(
    	'luzuk_modern_salon_feature_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'luzuk_modern_salon_feature_image',
	        array(
			    'label'   		=> __('Center Image','modern-salon'),
				'description'   		=> __('Image size 400*400','modern-salon'),
	            'section' => 'luzuk_modern_salon_feature_section',
	            'settings' => 'luzuk_modern_salon_feature_image',
	        )
	    )
	);

	
	$wp_customize->add_setting('luzuk_modern_salon_feature_category_settingright',array(
		'default' => 'select',
		'sanitize_callback' => 'luzuk_modern_salon_sanitize_choices',
	));
	$wp_customize->add_control('luzuk_modern_salon_feature_category_settingright',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Right Side Post','modern-salon'),
		'section' => 'luzuk_modern_salon_feature_section',
	));

	for ($i=1; $i <= 3; $i++) { 
	   	$wp_customize->add_setting('luzuk_modern_salon_feature_iconright' . $i, array(
	      	'default' => 'fas fa-cut',
	      	'sanitize_callback' => 'sanitize_text_field'
	   	));
	   	$wp_customize->add_control(new luzuk_modern_salon_Fontawesome_Icon_Chooser($wp_customize, 'luzuk_modern_salon_feature_iconright' . $i, array(
	      	'section' => 'luzuk_modern_salon_feature_section',
	      	'type' => 'icon',
	      	'label' => esc_html__('Feature Right Icon ', 'modern-salon') . $i
	  	)));
	}

	$wp_customize->add_setting('luzuk_modern_salon_feature_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_float'
	));
	$wp_customize->add_control('luzuk_modern_salon_feature_excerpt_length',array(
		'type' => 'number',
		'label' => __('Description Excerpt Length','modern-salon'),
		'section' => 'luzuk_modern_salon_feature_section',
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_feature_heading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_feature_heading_color', array(
		'label' => 'Heading Color',
		'section' => 'luzuk_modern_salon_feature_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_feature_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_feature_title_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_modern_salon_feature_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_feature_description_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_feature_description_color', array(
		'label' => 'Description Color',
		'section' => 'luzuk_modern_salon_feature_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_feature_icon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_feature_icon_color', array(
		'label' => 'Icon Color',
		'section' => 'luzuk_modern_salon_feature_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_feature_iconbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_feature_iconbg_color', array(
		'label' => 'Icon BG Color',
		'section' => 'luzuk_modern_salon_feature_section',
	)));



	//Aboutus Section
	$wp_customize->add_section('luzuk_modern_salon_aboutus_section',array(
		'title'	=> __('Aboutus Settings','modern-salon'),
		'description'=> __('<b>Note :</b> This section will appear below the Feature.','modern-salon'),
		'panel' => 'luzuk_modern_salon_panel_id',
	));

	$wp_customize->add_setting(
    	'luzuk_modern_salon_aboutus_rightimage',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'luzuk_modern_salon_aboutus_rightimage',
	        array(
			    'label'   		=> __('Left Image','modern-salon'),
				'description'   		=> __('Image size 400*400','modern-salon'),
	            'section' => 'luzuk_modern_salon_aboutus_section',
	            'settings' => 'luzuk_modern_salon_aboutus_rightimage',
	        )
	    )
	);

	$wp_customize->add_setting('luzuk_modern_salon_aboutus_headingnum',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutus_headingnum',array(
	   	'type' => 'text',
	   	'label' => __('Year Number','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutus_imageheadingtext',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutus_imageheadingtext',array(
	   	'type' => 'text',
	   	'label' => __('Year Text','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutusheading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutusheading',array(
	   	'type' => 'text',
	   	'label' => __('Heading','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutustitle',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutustitle',array(
	   	'type' => 'text',
	   	'label' => __('Title','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutusdescription',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutusdescription',array(
	   	'type' => 'text',
	   	'label' => __('Description','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutuspoint1_icon',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutuspoint1_icon',array(
	   	'type' => 'text',
	   	'label' => __('List 1 Icon (like fas fa-check)','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutuspoint1',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutuspoint1',array(
	   	'type' => 'text',
	   	'label' => __('List 1','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutuspoint2_icon',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutuspoint2_icon',array(
	   	'type' => 'text',
	   	'label' => __('List 2 Icon (like fas fa-check)','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutuspoint2',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutuspoint2',array(
	   	'type' => 'text',
	   	'label' => __('List 2','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutuspoint3_icon',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutuspoint3_icon',array(
	   	'type' => 'text',
	   	'label' => __('List 3 Icon (like fas fa-check)','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_modern_salon_aboutuspoint3',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('luzuk_modern_salon_aboutuspoint3',array(
	   	'type' => 'text',
	   	'label' => __('List 3','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));
	

	$wp_customize->add_setting('luzuk_modern_salon_aboutus_phnnum',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_modern_salon_aboutus_phnnum',array(
	   	'type' => 'text',
	   	'label' => __('Phone Number','modern-salon'),
	   	'section' => 'luzuk_modern_salon_aboutus_section',
	));


	$wp_customize->add_setting( 'luzuk_modern_salon_aboutusheading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutusheading_color', array(
		'label' => 'Heading Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutustitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutustitle_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutusdescription_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutusdescription_color', array(
		'label' => 'Description Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutuspointicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutuspointicon_color', array(
		'label' => 'Points Icon Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));


	$wp_customize->add_setting( 'luzuk_modern_salon_aboutuspointtext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutuspointtext_color', array(
		'label' => 'Points Text Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutusbtntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutusbtntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutusbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutusbtnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutusbtntexthrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutusbtntexthrv_color', array(
		'label' => 'Button Text Hover Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_aboutusbtnanimation_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_aboutusbtnanimation_color', array(
		'label' => 'Button Animation Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_yearnumber_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_yearnumber_color', array(
		'label' => 'Year Number Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_yearnumberbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_yearnumberbg_color', array(
		'label' => 'Year Number BG Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_yeartext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_yeartext_color', array(
		'label' => 'Year Text Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_yeartextbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_yeartextbg_color', array(
		'label' => 'Year Text BG Color',
		'section' => 'luzuk_modern_salon_aboutus_section',
	)));
	


	//Footer
    $wp_customize->add_section( 'luzuk_modern_salon_footer', array(
    	'title'  => __( 'Footer Settings', 'modern-salon' ),
		'priority' => null,
		'panel' => 'luzuk_modern_salon_panel_id'
	) );

	$wp_customize->add_setting('luzuk_modern_salon_show_back_totop',array(
       'default' => true,
       'sanitize_callback'	=> 'luzuk_modern_salon_sanitize_checkbox'
    ));
    $wp_customize->add_control('luzuk_modern_salon_show_back_totop',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Back to Top','modern-salon'),
       'section' => 'luzuk_modern_salon_footer'
    ));

    $wp_customize->add_setting('luzuk_modern_salon_footer_copy',array(
		'default' => 'Modern Salon WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('luzuk_modern_salon_footer_copy',array(
		'label'	=> __('Copyright Text','modern-salon'),
		'section' => 'luzuk_modern_salon_footer',
		'setting' => 'luzuk_modern_salon_footer_copy',
		'type' => 'text'
	));

	$wp_customize->add_setting( 'luzuk_modern_salon_footertext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footertext_color', array(
		'label' => 'Top Footer Text Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerlisticon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerlisticon_color', array(
		'label' => 'Top Footer List Icon Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerbg_color', array(
		'label' => 'Top Footer BG Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerbttombg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerbttombg_color', array(
		'label' => 'Bottom Footer BG Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footercopyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footercopyright_color', array(
		'label' => 'Copyright Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerscrolltotoptext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerscrolltotoptext_color', array(
		'label' => 'Scroll To Top Text Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerscrolltotopbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerscrolltotopbg_color', array(
		'label' => 'Scroll To Top BG Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerscrolltotoptxthover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerscrolltotoptxthover_color', array(
		'label' => 'Scroll To Top Text Hover Color',
		'section' => 'luzuk_modern_salon_footer',
	)));

	$wp_customize->add_setting( 'luzuk_modern_salon_footerscrolltotopbghover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_modern_salon_footerscrolltotopbghover_color', array(
		'label' => 'Scroll To Top BG Hover Color',
		'section' => 'luzuk_modern_salon_footer',
	)));




	

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'luzuk_modern_salon_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'luzuk_modern_salon_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'luzuk_modern_salon_customize_register' );

function luzuk_modern_salon_customize_partial_blogname() {
	bloginfo( 'name' );
}

function luzuk_modern_salon_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if (class_exists('WP_Customize_Control')) {

   	class Luzuk_Modern_Salon_Fontawesome_Icon_Chooser extends WP_Customize_Control {

      	public $type = 'icon';

      	public function render_content() { ?>
	     	<label>
	            <span class="customize-control-title">
	               <?php echo esc_html($this->label); ?>
	            </span>

	            <?php if ($this->description) { ?>
	                <span class="description customize-control-description">
	                   <?php echo wp_kses_post($this->description); ?>
	                </span>
	            <?php } ?>

	            <div class="modern-salon-selected-icon">
	                <i class="fa <?php echo esc_attr($this->value()); ?>"></i>
	                <span><i class="fa fa-angle-down"></i></span>
	            </div>

	            <ul class="modern-salon-icon-list clearfix">
	                <?php
	                $luzuk_modern_salon_font_awesome_icon_array = luzuk_modern_salon_font_awesome_icon_array();
	                foreach ($luzuk_modern_salon_font_awesome_icon_array as $luzuk_modern_salon_font_awesome_icon) {
	                   $icon_class = $this->value() == $luzuk_modern_salon_font_awesome_icon ? 'icon-active' : '';
	                   echo '<li class=' . esc_attr($icon_class) . '><i class="' . esc_attr($luzuk_modern_salon_font_awesome_icon) . '"></i></li>';
	                }
	                ?>
	            </ul>
	            <input type="hidden" value="<?php $this->value(); ?>" <?php $this->link(); ?> />
	        </label>
	        <?php
      	}
  	}
}
function luzuk_modern_salon_customizer_script() {
   wp_enqueue_style( 'font-awesome-1', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css');
}
add_action( 'customize_controls_enqueue_scripts', 'luzuk_modern_salon_customizer_script' );