<?php
/**
 * The header for our theme
 *
 * @subpackage Modern Salon
 * @since 1.0
 * @version 0.1
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}?>

<a class="screen-reader-text skip-link" href="#skip-content"><?php esc_html_e( 'Skip to content', 'modern-salon' ); ?></a>

<div id="header">
	<!-- <div class="container"> -->
		<div class="main-header">
			<div class="row mx-0">
				<div class="col-lg-3 col-md-6 col-sm-11">
					<div class="logo text-lg-left text-center">
						<?php if ( has_custom_logo() ) : ?>
		            		<?php the_custom_logo(); ?>
			            <?php endif; ?>
		             	<?php if (get_theme_mod('luzuk_modern_salon_show_site_title',true)) {?>
		          			<?php $blog_info = get_bloginfo( 'name' ); ?>
			                <?php if ( ! empty( $blog_info ) ) : ?>
			                  	<?php if ( is_front_page() && is_home() ) : ?>
			                    	<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			                  	<?php else : ?>
		                      		<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
		                  		<?php endif; ?>
			                <?php endif; ?>
			            <?php }?>
			            <?php if (get_theme_mod('luzuk_modern_salon_show_tagline',true)) {?>
			                <?php $description = get_bloginfo( 'description', 'display' );
		                  	if ( $description || is_customize_preview() ) : ?>
			                  	<p class="site-description"><?php echo esc_html($description); ?></p>
		              		<?php endif; ?>
		          		<?php }?>
					</div>
				</div>
				<div class="col-lg-9 col-md-6 col-sm-12 R-hd">
					<!-- <div class="rhd-oly"></div> -->
					<div class="row mr-0">
						<div class="col-lg-8 col-md-6 col-sm-12 ">
							<div class="menu-bar">
								<div class="toggle-menu responsive-menu text-md-left text-center">
									<?php if(has_nav_menu('primary')){ ?>
										<button onclick="luzuk_modern_salon_open()" role="tab" class="mobile-menu"><i class="fas fa-bars"></i><span class="screen-reader-text"><?php esc_html_e('Open Menu','modern-salon'); ?></span></button>
									<?php }?>
								</div>
								<div id="sidelong-menu" class="nav sidenav">
									<nav id="primary-site-navigation" class="nav-menu" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'modern-salon' ); ?>">
										<?php if(has_nav_menu('primary')){
											wp_nav_menu( array( 
												'theme_location' => 'primary',
												'container_class' => 'main-menu-navigation clearfix' ,
												'menu_class' => 'clearfix',
												'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
												'fallback_cb' => 'wp_page_menu',
											) ); 
										} ?>
										<a href="javascript:void(0)" class="closebtn responsive-menu" onclick="luzuk_modern_salon_close()"><i class="fas fa-times"></i><span class="screen-reader-text"><?php esc_html_e('Close Menu','modern-salon'); ?></span></a>
									</nav>
									
								</div>
							</div>
						</div>
						<div class="col-lg-4 col-md-6 col-sm-12 contact pd-0">
							<a href="<?php echo esc_html(get_theme_mod('luzuk_modern_salon_header_btnlink')); ?>" >
								<?php echo esc_html( get_theme_mod( 'luzuk_modern_salon_header_btntext', 'Book Now' ) ); ?>
							</a>		
						</div>				
					</div>
				</div>
			</div>
		</div>
	<!-- </div> -->
</div>

<?php if(is_singular()) {?>
	<div id="inner-pages-header">
		<div class="header-overlay"></div>
	    <div class="header-content">
		    <div class="container"> 
		      	<h1><?php single_post_title(); ?></h1>
		      	<div class="innheader-border"></div>
		      	<div class="theme-breadcrumb mt-2">
					<?php luzuk_modern_salon_breadcrumb();?>
				</div>
		    </div>
		</div>
	</div>
<?php } ?>