<?php
if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>',
	));

global $wp_version;
if ($wp_version < 2) $nosettings = true;
else $nosettings = false;

if (!$nosettings) {
	include(dirname(__FILE__).'/themetoolkit.php');
	themetoolkit('modern_blue', array('colorscheme' => 'Color Scheme {checkbox|blue|blue|Blue|pink|pink|Pink|green|green|Green|white|white|White} ## Check off the ones that you would like a possibility of seeing randomly selected.  If you do not select any, the blue option will be used.', 'gravatars' => 'Gravatars {checkbox|show_gravatars|true|Show Gravatars} ## This option and the next are not used in wp2.5+', 'gravatar_rating' => 'Gravatar Rating {radio|G|G|PG|PG|R|R|X|X}', 'lightbox' => 'Lightbox {checkbox|use_slimbox|true|Yes}'), __FILE__);
	global $modern_blue,$gravatar_rating;
	if (!$modern_blue->is_installed()|| !$modern_blue->option['gravatar_rating'] || !($modern_blue->option['blue'] || $modern_blue->option['pink'] || $modern_blue->option['green'] || $modern_blue->option['white'])) {
		$set_defaults['blue'] = 'blue';
		if (!$modern_blue->is_installed() || !$modern_blue->option['gravatar_rating']) {
			$set_defaults['gravatar_rating'] = 'G';
			$set_defaults['show_gravatars'] = 'true';
			$set_defaults['use_slimbox'] = 'true';
		}
		$modern_blue->store_options($set_defaults);
	}
	$colorchoices = array();
	if ($modern_blue->option['blue'] == 'blue')
		$colorchoices[] = 'blue';
	if ($modern_blue->option['pink'] == 'pink')
		$colorchoices[] = 'pink';
	if ($modern_blue->option['green'] == 'green')
		$colorchoices[] = 'green';
	if ($modern_blue->option['white'] == 'white')
		$colorchoices[] = 'white';
	$randomcolortemplate = $colorchoices[rand(0,count($colorchoices)-1)];
	$show_gravatars = (!get_option('show_avatars')) ? $modern_blue->option['show_gravatars'] : get_option('show_avatars');
	$gravatar_rating = (!get_option('avatar_rating')) ? $modern_blue->option['gravatar_rating'] : get_option('avatar_rating');
	$use_slimbox = $modern_blue->option['use_slimbox'];
} else {
	$show_gravatars = 'true';
	$gravatar_rating = 'G';
	$randomcolortemplate = 'blue';
	$use_slimbox = false;
}
global $use_slimbox;
function slimbox_template_head() {
	echo '<script type="text/javascript" src="'.get_bloginfo('template_directory').'/js/slimbox.js"></script>'."\n";
	echo '<link rel="stylesheet" type="text/css" href="'.get_bloginfo('template_directory').'/slimbox.css" media="screen" />'."\n";
}
if ($use_slimbox)
	add_action('wp_head', 'slimbox_template_head');

function stylesheet_template() {
	global $randomcolortemplate;
	switch ($randomcolortemplate):
	case '':
	case 'blue':
		bloginfo('stylesheet_url');
		break;
	default:
		echo get_bloginfo('template_directory').'/style-'.$randomcolortemplate.'.css';
	endswitch;
}

function template_color() {
	global $randomcolortemplate;
	switch ($randomcolortemplate):
	case '':
		return 'blue';
	default:
		return $randomcolortemplate;
	endswitch;
}

function browse_happy_template() {
	$getit = __( 'WordPress recommends a better browser' );
//	echo '<p><a href="http://browsehappy.com/" title="'.$getit.'"><img src="'.get_bloginfo('template_directory').'/images/browsehappy.gif" alt="Browse Happy" /></a></p>';
}
if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)
	add_action('wp_footer','browse_happy_template');

global $show_gravatars;
function nogravatar_stylesheet() {
	echo '<style type="text/css">ol.commentlist li {-moz-border-radius-topright:10px !important;-khtml-border-top-right-radius:10px !important;-webkit-border-top-right-radius:10px !important;border-top-right-radius:10px !important;}</style>'."\n";
}
if (!$show_gravatars)
	add_action('wp_head', 'nogravatar_stylesheet');

function gravatar_email($email) {
	if (!function_exists('get_avatar')) {
	global $gravatar_rating, $show_gravatars;
	if (!$show_gravatars)
		return;
	$size = 48;
	$rating = (!get_option('avatar_rating')) ? $gravatar_rating : get_option('avatar_rating');
	$default = get_bloginfo('template_directory').'/images/'.template_color().'/comment-gravatar.jpg';
	$out = "http://www.gravatar.com/avatar/".md5(strtolower($email)).".jpg";
	$out .= "?r=".$gravatar_rating;
	$out .="&amp;s=".$size;
	$out .= "&amp;d=".urlencode($default);
	echo "<img alt='' src='".$out."' class='avatar avatar-48' width='48' height='48' />";
	} else {
	echo get_avatar($email, '48', get_bloginfo('template_directory').'/images/'.template_color().'/comment-gravatar.jpg');
	}
}

function gravatar() {
	global $comment, $show_gravatars, $gravatar_rating;
	if (!function_exists('get_avatar')) {
	if (!$show_gravatars)
		return;
	$size = 48;
	$rating = (!get_option('avatar_rating')) ? $gravatar_rating : get_option('avatar_rating');
	$default = get_bloginfo('template_directory').'/images/'.template_color().'/comment-gravatar.jpg';
	$out = "http://www.gravatar.com/avatar/".md5(strtolower($comment->comment_author_email)).".jpg";
	$out .= "?r=".$rating;
	$out .="&amp;s=".$size;
	$out .= "&amp;d=".urlencode($default);
	echo "<img alt='' src='".$out."' class='avatar avatar-48' width='48' height='48' />";
	} else {
	echo get_avatar($comment->comment_author_email, '48', get_bloginfo('template_directory').'/images/'.template_color().'/comment-gravatar.jpg');
	}
}

function gravatar_post() {
	if (!function_exists('get_avatar')) {
	global $show_gravatars, $gravatar_rating;
	if (!$show_gravatars)
		return;
	$rating = (!get_option('avatar_rating')) ? $gravatar_rating : get_option('avatar_rating');
	$size = 80;
	$default = get_bloginfo('template_directory').'/images/'.template_color().'/author-gravatar.jpg';
	$out = "http://www.gravatar.com/avatar/".md5(strtolower(get_the_author_email())).".jpg";
	$out .= "?r=".$rating;
	$out .="&amp;s".$size;
	$out .= "&amp;d=".urlencode($default);
	echo "<img alt='' src='".$out."' class='avatar avatar-80' width='80' height='80' />";
	} else {
	echo get_avatar(get_the_author_email(), '80', get_bloginfo('template_directory').'/images/'.template_color().'/author-gravatar.jpg');
	}
}

function search_because_of_404() {
	if (!is_404())
		return;
	$home = get_bloginfo('home').'/';
	$url = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
	$error404 = str_replace($home,'',$url);
	$searchstring = str_replace(array('/','-',' ','_'),' ',urldecode($error404));
	$searchstring = trim($searchstring);
	$searchstring = $home.'?s='.str_replace(' ','+',$searchstring);
	echo $searchstring;
}

function commentword() {
	$commentwords = array('said','wrote','replied','thought','commented');
	echo $commentwords[rand(0,4)];
}

if (!function_exists('the_title_attribute')) {
	function the_title_attribute() {
		$title = get_the_title();

		if ( strlen($title) == 0 )
			return;

		$title = attribute_escape(strip_tags($title));

		echo $title;
	}
	if (!function_exists('attribute_escape')) {
		function attribute_escape($text) {
			$safe_text = wp_specialchars($text, true);
			return apply_filters('attribute_escape', $safe_text, $text);
		}
	}
}

if (!function_exists('get_previous_posts_page_link')) {
	function get_previous_posts_page_link() {
		global $paged;

		if ( !is_single() ) {
			$nextpage = intval($paged) - 1;
			if ( $nextpage < 1 )
				$nextpage = 1;
			return get_pagenum_link($nextpage);
		}
	}
}

if (!function_exists('get_next_posts_page_link')) {
	function get_next_posts_page_link($max_page = 0) {
		global $paged;

		if ( !is_single() ) {
			if ( !$paged )
				$paged = 1;
			$nextpage = intval($paged) + 1;
			if ( !$max_page || $max_page >= $nextpage )
				return get_pagenum_link($nextpage);
		}
	}
}

if (!function_exists('the_tags')) {
	function is_tag() {
		return false;
	}
	function the_tags() {
		return;
	}
}

function userlevel_highlight_class($preview = 0) {
	global $user_level, $current_user, $oddcomment;
	if ($oddcomment !== '') $oddcomment = 'class="alt" ';
	if ($preview == 0) {
		global $comment;
		$userinfo = get_userdata($comment->user_id);
		$user_level = $userinfo->user_level;
	} else {
		get_currentuserinfo();
		if ($current_user && !$user_level) $user_level = $current_user->data->user_level;
	}
	if ($user_level>7) echo 'class="admin" ';
	elseif ($user_level>2) echo 'class="editor" ';
	elseif ($user_level>1) echo 'class="author" ';
	else echo $oddcomment;
	$oddcomment = ( empty( $oddcomment ) ) ? 'class="alt" ' : '';
}

function fix_gallery_template($nothing, $attr) {
	global $post, $use_slimbox;

	// Allow plugins to overwrite this function
	if ( $nothing != '' )
		return $nothing;

	$attachments = get_children("post_parent=$post->ID&post_type=attachment&post_mime_type=image&orderby=\"menu_order ASC, ID ASC\"");

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $id => $attachment )
			$output .= wp_get_attachment_link($id, 'thumbnail', true) . "\n";
		return $output;
	}

	$output = '</p><div class="gallery">';

	foreach ( $attachments as $id => $attachment ) {
		$link = wp_get_attachment_link($id, 'thumbnail', true);
		if ($use_slimbox)
			$link = str_replace(array('<a ', '<img src="'), array('<a rel="lightbox[post-'.$post->ID.']" ', '<img alt="'.$attachment->post_title.'" src="'), wp_get_attachment_link($id, 'thumbnail', false));
		$output .= "
			<div>
				$link
			</div>";
		if ( ++$i % 3 == 0 )
			$output .= '<br class="clear" />';
	}

	$output .= "
			<br class=\"clear\" />
		</div>\n<p>";

	return $output;
}

//add_filter('post_gallery', 'fix_gallery_template', 10, 2);

function clean_empty_p_template($content) {
	return str_replace('<p></p>', '', $content);
}

//add_filter('the_content', 'clean_empty_p_template');


//http://weblogtoolscollection.com/archives/2008/03/08/managing-trackbacks-and-pingbacks-in-your-wordpress-theme/
add_filter('comments_array', 'filterComments', 0);
add_filter('the_posts', 'filterPostComments', 0);
//Updates the comment number for posts with trackbacks
function filterPostComments($posts) {
	foreach ($posts as $key => $p) {
		if ($p->comment_count <= 0) { return $posts; }
		$comments = get_approved_comments((int)$p->ID);
		$comments = array_filter($comments, "stripTrackback");
		$posts[$key]->comment_count = sizeof($comments);
	}
	return $posts;
}
//Updates the count for comments and trackbacks
function filterComments($comms) {
global $comments, $trackbacks;
	$comments = array_filter($comms,"stripTrackback");
	$trackbacks = array_filter($comms, "stripComment");
	return $comments;
}
function countTrackbacks() {
	global $trackbacks;
	$trackbacksonly = array_filter($trackbacks, "isTrackback");
	return sizeof($trackbacksonly);
}
function countPingbacks() {
	global $trackbacks;
	return sizeof($trackbacks) - countTrackbacks();
}
//Strips out trackbacks/pingbacks
function stripTrackback($var) {
	if ($var->comment_type == 'trackback' || $var->comment_type == 'pingback') return false;
	return true;
}
//Strips out comments
function stripComment($var) {
	if ($var->comment_type != 'trackback' && $var->comment_type != 'pingback') return false;
	return true;
}

function isTrackback($var) {
	if ($var->comment_type == 'trackback') return true;
	return false;
}

?>
