<?php
/* Load translation */
load_theme_textdomain('mmcrisp');

if (array_key_exists('_mmcrispsubmit_check', $_POST)) 
{
     processform();
}


/* Register widgets */
register_sidebar(array('name'=>'SidebarWidget','before_widget' => '<li>',
        'after_widget' => '</li>', 'before_title' => '<h3>',
        'after_title' => '</h3>'));
register_sidebar(array('name'=>'Footer Left','before_widget' => '<div class="footerWidget">',
        'after_widget' => '</div>', 'before_title' => '<h3>',
        'after_title' => '</h3>'));
register_sidebar(array('name'=>'Footer Middle','before_widget' => '<div class="footerWidget">',
        'after_widget' => '</div>', 'before_title' => '<h3>',
        'after_title' => '</h3>'));
register_sidebar(array('name'=>'Footer Right','before_widget' => '<div class="footerWidget">',
        'after_widget' => '</div>', 'before_title' => '<h3>',
        'after_title' => '</h3>'));
        
/* Menu */
add_action( 'init', 'register_my_menu' );

function register_my_menu() 
{
	register_nav_menu( 'primary-menu', __('Menu'));
}

/* Enqueue scripts */
function init_scripts() {
    wp_enqueue_script('jquery');
    wp_enqueue_script('hoverintent',
 	get_bloginfo('template_url') . '/superfish-1.4.8/js/hoverIntent.js',
 	array('jquery')); 
 	wp_enqueue_script('superfish',
 	get_bloginfo('template_url') . '/superfish-1.4.8/js/superfish.js',
 	array('jquery'));           
}    
 
add_action('init', 'init_scripts');

/* Admin */
add_action('admin_menu', 'add_mmcrispMenu');

function add_mmcrispMenu()
{
	add_options_page(__('Theme MMCrisp','mmcrisp'), 'MMCrisp', 'edit_theme_options', 'mmcrispAdminMenu', 'mmcrispAdminMenu');
}

function mmcrispAdminMenu()
{
	$options = get_mmcrispOptions();
?>
	<form id="mmcrisp-settings" action="" method="post">
	<h2><?php _e('Settings for MMCrisp','mmcrisp'); ?></h2>
	<table>
		<tr>
			<td><label for="site_title"><?php _e('Show site title','mmcrisp'); ?></label></td><td><input name="site_title" id="site_title" type="checkbox" value="1" <?php echo $options['site_title']?'checked':'';?>/></td>
		</tr>
		<tr>
			<td><label for="comments_on_pages"><?php _e('Show comments on pages','mmcrisp'); ?></label></td><td><input name="comments_on_pages" id="comments_on_pages" type="checkbox" value="1" <?php echo $options['comments_on_pages']?'checked':'';?>/></td>
		</tr>
		<tr>
			<td><label for="comments_on_others"><?php _e('Show comments on others','mmcrisp'); ?></label></td><td><input name="comments_on_others" id="comments_on_others" type="checkbox" value="1" <?php echo $options['comments_on_others']?'checked':'';?>/></td>
		</tr>
		<tr>
			<td><label for="widget_footer"><?php _e('Show widget footer','mmcrisp'); ?></label></td><td><input name="widget_footer" id="widget_footer" type="checkbox" value="1" <?php echo $options['widget_footer']?'checked':'';?>/></td>
		</tr>
		<tr>
			<td><label for="nomoreie6"><?php _e('Show "No More IE6" message','mmcrisp'); ?></label></td><td><input name="nomoreie6" id="nomoreie6" type="checkbox" value="1" <?php echo $options['nomoreie6']?'checked':'';?>/></td>
		</tr>
	</table>
	<input type="hidden" name="_mmcrispsubmit_check" id="_mmcrispsubmit_check" value="1" />
	<input type="submit" value="<?php _e('Save settings','mmcrisp');?>"/>
	</form>
<?php
}

function get_mmcrispOptions()
{
	$defaultOptions = array('site_title'=>true,
							'comments_on_pages'=>false,
							'comments_on_others'=>true,
							'widget_footer'=>true,
							'nomoreie6'=>false);
	
	return get_option('mmcrisp',$defaultOptions);
}

function processForm(){

	$options = get_mmcrispOptions();

	$options['site_title'] = $_POST['site_title']==1?true:false;
	$options['comments_on_pages'] = $_POST['comments_on_pages']==1?true:false;
	$options['comments_on_others'] = $_POST['comments_on_others']==1?true:false;
	$options['widget_footer'] = $_POST['widget_footer']==1?true:false;
	$options['nomoreie6'] = $_POST['nomoreie6']==1?true:false;
	
	update_option('mmcrisp',$options);
}

/* This callback is derived from the twenty-ten(GPL) theme */
if ( ! function_exists( 'twentyten_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own twentyten_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since Twenty Ten 1.0
 */
function twentyten_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo get_avatar( $comment, 40 ); ?>
			<?php printf( __( '%s <span class="says">says:</span>', 'mmcrisp' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'mmcrisp' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'mmcrisp' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'mmcrisp' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'mmcrisp' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __('(Edit)', 'mmcrisp'), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif;
?>