<?php

define('ACF_LITE',true);


if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_link',
		'title' => 'Link',
		'fields' => array (
			array (
				'key' => 'field_53e121e24d145',
				'label' => 'Add Link ( required )',
				'name' => 'add_link',
				'type' => 'text',
				'instructions' => 'Url validated',
				'default_value' => '',
				'placeholder' => 'Ex : burak-aydin.com',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => 100,
			),
			array (
				'key' => 'field_53e1227b4d146',
				'label' => 'How to appear ( required )',
				'name' => 'how_to_appear',
				'type' => 'text',
				'instructions' => 'Add link name to this post.',
				'default_value' => '',
				'placeholder' => 'Ex : My Personal Page',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => 100,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'link',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'comments',
				4 => 'revisions',
				5 => 'featured_image',
				6 => 'tags',
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_quote',
		'title' => 'Quote',
		'fields' => array (
			array (
				'key' => 'field_53e12a716b74b',
				'label' => 'Quote Content ( required )',
				'name' => 'quote_content',
				'type' => 'textarea',
				'default_value' => '',
				'placeholder' => 'ex : Imagination is more important than knowledge.',
				'maxlength' => '',
				'rows' => '',
				'formatting' => 'none',
			),
			array (
				'key' => 'field_53e12d156b74c',
				'label' => 'Owner ( required )',
				'name' => 'owner',
				'type' => 'text',
				'instructions' => 'Who said this quote',
				'default_value' => '',
				'placeholder' => 'ex : Albert Einstein',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'quote',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'featured_image',
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_slider-option',
		'title' => 'Slider Option',
		'fields' => array (
			array (
				'key' => 'field_53e1eeaad85a8',
				'label' => 'Add Slider',
				'name' => '',
				'type' => 'message',
				'message' => 'You can add to slider this post. Slider consist of 3 image, 3 text and 1 button.',
			),
			array (
				'key' => 'field_53e20f45cf6b1',
				'label' => 'Add Slider',
				'name' => 'slider_check',
				'type' => 'true_false',
				'instructions' => 'Enable Slider ?',
				'message' => 'add this post to slider ?',
				'default_value' => 0,
			),
			array (
				'key' => 'field_53e1eee3d85a9',
				'label' => 'Image 1',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e1ef27d85aa',
				'label' => 'Image',
				'name' => 'image_one',
				'type' => 'image',
				'instructions' => 'Add the Image 1',
				'save_format' => 'object',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_53e2118580de7',
				'label' => 'Image 2',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e2115e80de6',
				'label' => 'Image',
				'name' => 'image_two',
				'type' => 'image',
				'instructions' => 'Add the Image 2',
				'save_format' => 'object',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_53e2119c80de8',
				'label' => 'Image 3',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e211a380de9',
				'label' => 'Image',
				'name' => 'image_three',
				'type' => 'image',
				'instructions' => 'Add the image 3',
				'save_format' => 'object',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_53e216ecd71af',
				'label' => 'Text 1',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e21707d71b0',
				'label' => 'Text 1',
				'name' => 'text_one',
				'type' => 'text',
				'instructions' => 'Type some text. ( Character limit\'s 50 )',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => 50,
			),
			array (
				'key' => 'field_53e21742d71b1',
				'label' => 'Text 2',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e2174bd71b2',
				'label' => 'Text 2',
				'name' => 'text_two',
				'type' => 'text',
				'instructions' => 'Type some text ( Character limit\'s 50 )',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_53e2176fd71b3',
				'label' => 'Text 3',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e21778d71b4',
				'label' => 'Text 3',
				'name' => 'text_three',
				'type' => 'text',
				'instructions' => 'Type some text ( Character limit\'s 50 )',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_53e21795d71b5',
				'label' => 'Link',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_53e217c3d71b6',
				'label' => 'Link Text',
				'name' => 'link_title',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => 'ex : Go to my shop',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_53e217e6d71b7',
				'label' => 'Link',
				'name' => 'button_link',
				'type' => 'text',
				'instructions' => 'Url Validated',
				'default_value' => '',
				'placeholder' => 'ex : burak-aydin.com',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'standard',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'image',
					'order_no' => 0,
					'group_no' => 1,
				),
			),
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'video',
					'order_no' => 0,
					'group_no' => 2,
				),
			),
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'audio',
					'order_no' => 0,
					'group_no' => 3,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_status',
		'title' => 'Status',
		'fields' => array (
			array (
				'key' => 'field_53e130eedaea2',
				'label' => 'Status Content',
				'name' => 'status_content',
				'type' => 'textarea',
				'instructions' => 'Character limit is 250',
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => 250,
				'rows' => '',
				'formatting' => 'none',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'status',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
				0 => 'the_content',
				1 => 'custom_fields',
				2 => 'featured_image',
				3 => 'tags',
			),
		),
		'menu_order' => 0,
	));
}

?>