<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'misbah-one-page' ); ?></a>

<?php if(get_theme_mod('misbah_one_page_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'misbah_one_page_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'misbah-one-page' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'misbah_one_page_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<div class="topheader py-2">
	<div class="container">
		<div class="row">
			<div class="col-lg-10 col-md-10 col-sm-10 col-12 align-self-center">
			</div>
			<div class="col-lg-1 col-md-1 col-sm-1 col-6 align-self-center">
				<div class="header-search text-start text-md-end">
		        	<?php if ( get_theme_mod('misbah_one_page_search_box_enable', true) == true ) : ?>
		                <a class="open-search-form" href="#search-form"><i class="fa fa-search" aria-hidden="true"></i></a>
		                <div class="search-form"><?php get_search_form();?></div>
		        	<?php endif; ?>
		        </div>
			</div>
			<div class="col-lg-1 col-md-1 col-sm-1 col-6 align-self-center">
				<div class="offcanvas-div d-flex">
					<button type="button" data-bs-toggle="offcanvas" data-bs-target="#demo">
						<i class="fas fa-bars"></i>
					</button>
					<div class="offcanvas offcanvas-start" id="demo">
						<div class="offcanvas-header"> 
							<button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
						</div>
						<div class="offcanvas-body">
							<div class="logo">
					    		<div class="logo-image">
					    			<?php the_custom_logo(); ?>
						    	</div>
						    	<div class="logo-content">
							    	<?php
							    		if ( get_theme_mod('misbah_one_page_display_header_title', true) == true ) :
								      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
								      			echo esc_attr(get_bloginfo('name'));
								      		echo '</a>';
								      	endif;

								      	if ( get_theme_mod('misbah_one_page_display_header_text', false) == true ) :
							      			echo '<span>'. esc_attr(get_bloginfo('description')) . '</span>';
							      		endif;
						    		?>
								</div>
							</div>
							<div id="site-navigation" class="header my-5">
								<div class="top-menu-wrapper">
								    <div class="navigation_header">
								        <div class="toggle-nav mobile-menu">
								            <button onclick="misbah_one_page_openNav()">
								                <span class="dashicons dashicons-menu"></span>
								            </button>
								        </div>
								        <div id="mySidenav" class="nav sidenav">
								            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'misbah-one-page' ); ?>">
								                <?php {
								                    wp_nav_menu(
								                        array(
								                            'theme_location' => 'main-menu',
								                            'container_class' => 'navi clearfix navbar-nav',
								                            'menu_class'     => 'menu clearfix',
								                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								                            'fallback_cb'    => 'wp_page_menu',
								                        )
								                    );
								                } ?>
								            </nav>
								            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="misbah_one_page_closeNav()">
								                <span class="dashicons dashicons-no"></span>
								            </a>
								        </div>
								    </div>
								</div>
							</div>
							<?php $misbah_one_page_settings = get_theme_mod( 'misbah_one_page_social_links_settings' ); ?>
							<div class="social-links">
								<?php if ( is_array($misbah_one_page_settings) || is_object($misbah_one_page_settings) ){ ?>
									<h4 class="mb-3"><?php esc_html_e('Follow Us','misbah-one-page'); ?></h4>
							    	<?php foreach( $misbah_one_page_settings as $misbah_one_page_setting ) { ?>
								        <a href="<?php echo esc_url( $misbah_one_page_setting['link_url'] ); ?>">
								            <i class="<?php echo esc_attr( $misbah_one_page_setting['link_text'] ); ?> me-2"></i>
								        </a>
							    	<?php } ?>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>