<?php if ( get_theme_mod('misbah_one_page_blog_box_enable',false) ) : ?>

<?php $misbah_one_page_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('misbah_one_page_blog_slide_category'),
  'posts_per_page' => get_theme_mod('misbah_one_page_blog_slide_number'),
); ?>

<div class="slider">
  <div class="owl-carousel">
    <?php $misbah_one_page_arr_posts = new WP_Query( $misbah_one_page_args );
    if ( $misbah_one_page_arr_posts->have_posts() ) :
      while ( $misbah_one_page_arr_posts->have_posts() ) :
        $misbah_one_page_arr_posts->the_post();
        ?>
        <div class="blog_inner_box">
          <div class="row">
            <div class="col-lg-5 col-md-6 col-sm-6">
              <?php
                if ( has_post_thumbnail() ) :
                  the_post_thumbnail();
                else:
                  ?>
                  <div class="slider-alternate">
                    <img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/banner.png'; ?>">
                  </div>
                  <?php
                endif;
              ?>
            </div>
            <div class="col-lg-7 col-md-6 col-sm-6 position-relative">
              <div class="blog_box pt-3 pt-md-0 wow zoomIn">
                <?php if ( get_theme_mod('misbah_one_page_title_unable_disable',true) ) : ?>
                  <h3 class="my-3"><?php the_title(); ?></h3>
                <?php endif; ?>
                <p><?php echo wp_trim_words( get_the_content(), 30 ); ?></p>
                <?php if ( get_theme_mod('misbah_one_page_button_unable_disable',true) ) : ?>
                  <p class="slider-button mt-4">
                    <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Know More','misbah-one-page'); ?></a>
                  </p>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      <?php
    endwhile;
    wp_reset_postdata();
    endif; ?>
  </div>  
</div>

<?php endif; ?>