<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_misbah_one_page_dismissed_notice_handler', 'misbah_one_page_ajax_notice_handler' );

/**
 * AJAX handler to store the state of dismissible notices.
 */
function misbah_one_page_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        // Pick up the notice "type" - passed via jQuery (the "data-notice" attribute on the notice)
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        // Store it in the options table
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function misbah_one_page_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_misbah-one-page-guide-page' &&
            $current_screen->id !== 'appearance_page_misbahonepage-wizard'
        ) {
            $misbah_one_page_comments_theme = wp_get_theme();
            ?>
            <div class="misbah-one-page-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="misbah-one-page-notice">
                    <div class="misbah-one-page-notice-content">
                        <div class="misbah-one-page-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'misbah-one-page'); ?>
                                <?php echo esc_html( $misbah_one_page_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'misbah-one-page'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'misbah-one-page'),
                                    $misbah_one_page_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=misbah-one-page-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'misbah-one-page'); ?>
                            </a>
                            <a class="button button-primary" href="<?php echo esc_url( MISBAH_ONE_PAGE_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'misbah-one-page'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=misbahonepage-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'misbah-one-page'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="misbah-one-page-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'misbah-one-page'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'misbah_one_page_deprecated_hook_admin_notice' );


function misbah_one_page_admin_enqueue_scripts() {
	wp_enqueue_style( 'misbah-one-page-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'misbah-one-page-admin-script', get_template_directory_uri() . '/js/misbah-one-page-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'misbah-one-page-admin-script', 'misbah_one_page_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'misbah_one_page_admin_enqueue_scripts' );

add_action( 'admin_menu', 'misbah_one_page_getting_started' );
function misbah_one_page_getting_started() {
	add_theme_page( esc_html__('Get Started', 'misbah-one-page'), esc_html__('Get Started', 'misbah-one-page'), 'edit_theme_options', 'misbah-one-page-guide-page', 'misbah_one_page_test_guide');
}

if ( ! defined( 'MISBAH_ONE_PAGE_DOCS_FREE' ) ) {
define('MISBAH_ONE_PAGE_DOCS_FREE',__('https://demo.misbahwp.com/docs/misbah-one-page-free-docs/','misbah-one-page'));
}
if ( ! defined( 'MISBAH_ONE_PAGE_DOCS_PRO' ) ) {
define('MISBAH_ONE_PAGE_DOCS_PRO',__('https://demo.misbahwp.com/docs/misbah-one-page-pro-docs/','misbah-one-page'));
}
if ( ! defined( 'MISBAH_ONE_PAGE_BUY_NOW' ) ) {
define('MISBAH_ONE_PAGE_BUY_NOW',__('https://www.misbahwp.com/products/one-page-wordpress-theme','misbah-one-page'));
}
if ( ! defined( 'MISBAH_ONE_PAGE_SUPPORT_FREE' ) ) {
define('MISBAH_ONE_PAGE_SUPPORT_FREE',__('https://wordpress.org/support/theme/misbah-one-page','misbah-one-page'));
}
if ( ! defined( 'MISBAH_ONE_PAGE_REVIEW_FREE' ) ) {
define('MISBAH_ONE_PAGE_REVIEW_FREE',__('https://wordpress.org/support/theme/misbah-one-page/reviews/#new-post','misbah-one-page'));
}
if ( ! defined( 'MISBAH_ONE_PAGE_DEMO_PRO' ) ) {
define('MISBAH_ONE_PAGE_DEMO_PRO',__('https://demo.misbahwp.com/misbah-one-page/','misbah-one-page'));
}
if( ! defined( 'MISBAH_ONE_PAGE_THEME_BUNDLE' ) ) {
define('MISBAH_ONE_PAGE_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','misbah-one-page'));
}

function misbah_one_page_test_guide() { ?>
	<?php $misbah_one_page_theme = wp_get_theme(); ?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( MISBAH_ONE_PAGE_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'misbah-one-page' ) ?></a>			
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'misbah-one-page' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( MISBAH_ONE_PAGE_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'misbah-one-page' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( MISBAH_ONE_PAGE_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'misbah-one-page' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','misbah-one-page'); ?><?php echo esc_html( $misbah_one_page_theme ); ?>  <span><?php esc_html_e('Version: ', 'misbah-one-page'); ?><?php echo esc_html($misbah_one_page_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','misbah-one-page'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','misbah-one-page'); ?></p>
					<a class="button button-primary import" href="themes.php?page=misbahonepage-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','misbah-one-page'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $misbah_one_page_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$misbah_one_page_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $misbah_one_page_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="postboxx donate">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'misbah-one-page' ); ?></h3>
				<div class="insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','misbah-one-page'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( MISBAH_ONE_PAGE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'misbah-one-page' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( MISBAH_ONE_PAGE_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'misbah-one-page' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( MISBAH_ONE_PAGE_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'misbah-one-page' ) ?></a>
					</div>
				</div>
				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'misbah-one-page' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'misbah-one-page'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','misbah-one-page'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','misbah-one-page'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','misbah-one-page'); ?></span></p>
				<div id="admin_pro_linkss">
					<a class="blue-button-1" href="<?php echo esc_url( MISBAH_ONE_PAGE_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Buy All Themes - $89', 'misbah-one-page' ) ?></a>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','misbah-one-page'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','misbah-one-page'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','misbah-one-page'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','misbah-one-page'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>		    
	  		</div>
			</div>
		</div>
	</div>
<?php } ?>