<?php

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'misbah_one_page_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'misbah-one-page' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'misbah-one-page' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'misbah-one-page' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'misbah_one_page_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'misbah-one-page' ),
	) );

	Kirki::add_section( 'misbah_one_page_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'misbah-one-page' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_all_headings_typography',
		'section'     => 'misbah_one_page_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'misbah_one_page_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'misbah-one-page' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'misbah-one-page' ),
		'section'     => 'misbah_one_page_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_body_content_typography',
		'section'     => 'misbah_one_page_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'misbah_one_page_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'misbah-one-page' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'misbah-one-page' ),
		'section'     => 'misbah_one_page_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'misbah_one_page_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'misbah-one-page' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'misbah_one_page_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'misbah-one-page' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'misbah_one_page_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'misbah-one-page' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'misbah_one_page_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'misbah-one-page' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'misbah_one_page_dark_colors',
	    'section'     => 'misbah_one_page_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'misbah-one-page' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'misbah_one_page_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'misbah-one-page' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'misbah_one_page_section_404', array(
		'panel'          => 'misbah_one_page_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'misbah-one-page' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'misbah_one_page_404_heading',
	    'section'     => 'misbah_one_page_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'misbah-one-page' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'misbah_one_page_404_page_title',
		'section'  => 'misbah_one_page_section_404',
		'default'  => esc_html__('404 Not Found', 'misbah-one-page'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'misbah_one_page_404_text',
	    'section'     => 'misbah_one_page_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'misbah-one-page' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'misbah_one_page_404_page_content',
		'section'  => 'misbah_one_page_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'misbah-one-page'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'misbah_one_page_no_result', array(
		'panel'          => 'misbah_one_page_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'misbah-one-page' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'misbah_one_page_not_found_heading',
	    'section'     => 'misbah_one_page_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'misbah-one-page' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'misbah_one_page_no_results_page_title',
		'section'  => 'misbah_one_page_no_result',
		'default'  => esc_html__('404 Not Found', 'misbah-one-page'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'misbah_one_page_not_found_text',
	    'section'     => 'misbah_one_page_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'misbah-one-page' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'misbah_one_page_no_results_page_content',
		'section'  => 'misbah_one_page_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'misbah-one-page'),
		'priority' => 10,
	] );


	// PANEL

	Kirki::add_panel( 'misbah_one_page_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'misbah-one-page' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'misbah_one_page_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'misbah-one-page' ),
	    'panel'          => 'misbah_one_page_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_global_colors',
		'section'     => 'misbah_one_page_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'misbah_one_page_first_color',
		'label'       => __( 'Choose Your First Color', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_color',
		'default'     => '#28B4E9',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'misbah_one_page_second_color',
		'label'       => __( 'Choose Your Second Color', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_color',
		'default'     => '#000000',
	] );

	// Additional Settings

	Kirki::add_section( 'misbah_one_page_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'misbah-one-page' ),
	    'panel'          => 'misbah_one_page_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'misbah_one_page_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'misbah_one_page_scroll_top_position',
			'label'       => esc_html__( 'Alignment for Scroll To Top', 'misbah-one-page' ),
			'section'     => 'misbah_one_page_additional_settings',
			'default'     => 'Right',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'misbah-one-page' ),
				'Center' => esc_html__( 'Center', 'misbah-one-page' ),
				'Right'  => esc_html__( 'Right', 'misbah-one-page' ),
			],
		]
		);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'misbah_one_page_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'misbah-one-page' ),
		'section'  => 'misbah_one_page_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'menu_text_transform_misbah_one_page',
		'label'       => esc_html__( 'Menus Text Transform', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default'     => 'CAPITALISE',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'CAPITALISE' => esc_html__( 'CAPITALISE', 'misbah-one-page' ),
			'UPPERCASE' => esc_html__( 'UPPERCASE', 'misbah-one-page' ),
			'LOWERCASE' => esc_html__( 'LOWERCASE', 'misbah-one-page' ),
		],
	]);

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default' => 'None',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'None' => __('None','misbah-one-page'),
            'Zoominn' => __('Zoom Inn','misbah-one-page'),
            
		],
	] );

		Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'misbah_one_page_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'misbah_one_page_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','misbah-one-page'),
            'cube-loader' => __('Type 2','misbah-one-page'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','misbah-one-page'),
            'Right Sidebar' => __('Right Sidebar','misbah-one-page'),
            'One Column' => __('One Column','misbah-one-page')
		],
	] );
	


	if ( class_exists("woocommerce")){

	// Woocommerce Settings

	Kirki::add_section( 'misbah_one_page_woocommerce_settings', array(
			'title'          => esc_html__( 'Woocommerce Settings', 'misbah-one-page' ),
			'panel'          => 'misbah_one_page_panel_id',
			'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_woocommerce_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'misbah_one_page_shop_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'misbah_one_page_product_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'misbah_one_page_related_product_setting',
		'label'       => esc_html__( 'Here you can enable or disable your related products.', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Number(
	[
		'settings' => 'misbah_one_page_per_columns',
		'label'    => esc_html__( 'Product Per Row', 'misbah-one-page' ),
		'section'  => 'misbah_one_page_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'misbah_one_page_product_per_page',
		'label'    => esc_html__( 'Product Per Page', 'misbah-one-page' ),
		'section'  => 'misbah_one_page_woocommerce_settings',
		'default'  => 9,
		'choices'  => [
			'min'  => 1,
			'max'  => 15,
			'step' => 1,
		],
	]
	);

		new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number_per_row',
		'label'    => esc_html__( 'Related Product Per Column', 'misbah-one-page' ),
		'section'  => 'misbah_one_page_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number',
		'label'    => esc_html__( 'Related Product Per Page', 'misbah-one-page' ),
		'section'  => 'misbah_one_page_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 10,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_shop_page_layout',
		'label'       => esc_html__( 'Shop Page Layout Setting', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','misbah-one-page'),
            'Right Sidebar' => __('Right Sidebar','misbah-one-page')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_product_page_layout',
		'label'       => esc_html__( 'Product Page Layout Setting', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','misbah-one-page'),
            'Right Sidebar' => __('Right Sidebar','misbah-one-page')
		],
	] );

		new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'misbah_one_page_woocommerce_pagination_position',
		'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_woocommerce_settings',
		'default'     => 'Center',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'misbah-one-page' ),
			'Center' => esc_html__( 'Center', 'misbah-one-page' ),
			'Right'  => esc_html__( 'Right', 'misbah-one-page' ),
		],
	]
	);

}	

	// POST SECTION

	Kirki::add_section( 'misbah_one_page_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'misbah-one-page' ),
	    'panel'          => 'misbah_one_page_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'misbah_one_page_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'misbah-one-page' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'misbah-one-page' ),
		'section'  => 'misbah_one_page_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'misbah-one-page' ),
			'option2' => esc_html__( 'Post Meta', 'misbah-one-page' ),
			'option3' => esc_html__( 'Post Title', 'misbah-one-page' ),
			'option4' => esc_html__( 'Post Content', 'misbah-one-page' ),
			'option5' => esc_html__( 'Post Button', 'misbah-one-page' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'misbah_one_page_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_post',
		'default'     => 10,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'misbah_one_page_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','misbah-one-page'),
            'Right Sidebar' => __('Right Sidebar','misbah-one-page'),
            'Three Column' => __('Three Column','misbah-one-page'),
            'Four Column' => __('Four Column','misbah-one-page'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','misbah-one-page'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','misbah-one-page'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','misbah-one-page')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','misbah-one-page'),
            'Right Sidebar' => __('Right Sidebar','misbah-one-page'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','misbah-one-page'),
            'Right Sidebar' => __('Right Sidebar','misbah-one-page'),
            'Three Column' => __('Three Column','misbah-one-page'),
            'Four Column' => __('Four Column','misbah-one-page'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','misbah-one-page'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','misbah-one-page'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','misbah-one-page')
		],
	] );

	// Breadcrumb
	Kirki::add_section( 'misbah_one_page_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'misbah-one-page' ),
	    'panel'          => 'misbah_one_page_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_enable_breadcrumb_heading',
		'section'     => 'misbah_one_page_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'misbah_one_page_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'misbah-one-page' ),
        'section'  => 'misbah_one_page_bradcrumb',
    ] );


	// HEADER SECTION

	Kirki::add_section( 'misbah_one_page_section_header', array(
	    'title'          => esc_html__( 'Header Settings', 'misbah-one-page' ),
	    'panel'          => 'misbah_one_page_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_section_header',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_search_box_enable',
		'label'       => esc_html__( 'Search Button Enable / Disable', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_section_header',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_enable_socail_link',
		'section'     => 'misbah_one_page_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'misbah_one_page_section_header',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'misbah-one-page' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'misbah-one-page' ),
		'settings'     => 'misbah_one_page_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'misbah-one-page' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'misbah-one-page' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'misbah-one-page' ),
				'description' => esc_html__( 'Add the social icon url here.', 'misbah-one-page' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );

	// SLIDER SECTION

	Kirki::add_section( 'misbah_one_page_blog_slide_section', array(
        'title'          => esc_html__( 'Slider Settings', 'misbah-one-page' ),
        'panel'          => 'misbah_one_page_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_enable_heading',
		'section'     => 'misbah_one_page_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_blog_slide_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_title_unable_disable',
		'label'       => esc_html__( 'Slide Title Enable / Disable', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_blog_slide_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_button_unable_disable',
		'label'       => esc_html__( 'Slide Button Enable / Disable', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_blog_slide_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_slider_heading',
		'section'     => 'misbah_one_page_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slider', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'misbah_one_page_blog_slide_number',
		'label'       => esc_html__( 'Number of slides to show', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_blog_slide_section',
		'default'     => 0,
		'choices'     => [
			'min'  => 1,
			'max'  => 5,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'misbah_one_page_blog_slide_category',
		'label'       => esc_html__( 'Select the category to show slider ( Image Dimension 1600 x 600 )', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_blog_slide_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'misbah-one-page' ),
		'priority'    => 10,
		'choices'     => misbah_one_page_get_categories_select(),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_footer_enable_heading_22',
		'section'     => 'misbah_one_page_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Content Alignment', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_slider_content_alignment',
		'label'       => esc_html__( 'Slider Content Alignment', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_blog_slide_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'misbah-one-page' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'misbah-one-page' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'misbah-one-page' ),

		],
	] );

	//PROJECTS SECTION

	Kirki::add_section( 'misbah_one_page_project_section', array(
	    'title'          => esc_html__( 'Our Project Settings', 'misbah-one-page' ),
	    'panel'          => 'misbah_one_page_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_project_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	    'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_enable_heading',
		'section'     => 'misbah_one_page_project_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Our Project',  'misbah-one-page' ) . '</h3>',
		'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_projects_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'misbah-one-page' ),
		'section'     => 'misbah_one_page_project_section',
		'default'     => false,
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'misbah-one-page' ),
			'off' => esc_html__( 'Disable',  'misbah-one-page' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_projects_text_heading',
		'section'     => 'misbah_one_page_project_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Project Section', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Heading', 'misbah-one-page' ),
		'settings' => 'misbah_one_page_projects_heading',
		'section'  => 'misbah_one_page_project_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Text', 'misbah-one-page' ),
		'settings' => 'misbah_one_page_projects_heading_text',
		'section'  => 'misbah_one_page_project_section',
		'default'  => '',
		'priority' => 10,
	] );	

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'misbah_one_page_projects_number',
		'label'       => esc_html__( 'Number of Tabs to show', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_project_section',
		'default'     => '',
		'choices'     => [
			'min'  => 0,
			'max'  => 80,
			'step' => 1,
		],
	] );

	$misbah_one_page_featured_post = get_theme_mod('misbah_one_page_projects_number','');
    	for ( $j = 1; $j <= $misbah_one_page_featured_post; $j++ ) :

    	Kirki::add_field( 'theme_config_id', [
	        'type'        => 'text',
	        'settings'    => 'misbah_one_page_projects_text' .$j,
	        'label'       => esc_html__( 'Tab Text ', 'misbah-one-page' ).$j,
	        'section'     => 'misbah_one_page_project_section',
	        'default'     => '',
	    ] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'select',
			'settings'    => 'misbah_one_page_projects_category'.$j,
			'label'       => esc_html__( 'Select the category to show project ', 'misbah-one-page' ).$j,
			'section'     => 'misbah_one_page_project_section',
			'default'     => '',
			'placeholder' => esc_html__( 'Select an category...', 'misbah-one-page' ),
			'priority'    => 10,
			'choices'     => misbah_one_page_get_categories_select(),
		] );

	endfor;

	// FOOTER SECTION

	Kirki::add_section( 'misbah_one_page_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'misbah-one-page' ),
        'panel'          => 'misbah_one_page_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'misbah-one-page' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( MISBAH_ONE_PAGE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'misbah-one-page' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'misbah_one_page_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'misbah-one-page' ) . '</div>',
	] );

		Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_footer_enable_heading',
		'section'     => 'misbah_one_page_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'misbah_one_page_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'misbah-one-page' ),
			'off' => esc_html__( 'Disable', 'misbah-one-page' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_footer_text_heading',
		'section'     => 'misbah_one_page_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'misbah-one-page' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'misbah_one_page_footer_text',
		'section'  => 'misbah_one_page_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'misbah_one_page_footer_text_heading_2',
	'section'     => 'misbah_one_page_footer_section',
	'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'misbah-one-page' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'misbah_one_page_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'misbah-one-page' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'misbah-one-page' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'misbah-one-page' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'misbah-one-page' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'misbah_one_page_footer_text_heading_1',
	'section'     => 'misbah_one_page_footer_section',
	'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'misbah-one-page' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'misbah_one_page_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'misbah-one-page' ),
		'section'     => 'misbah_one_page_footer_section',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'misbah_one_page_enable_footer_socail_link',
		'section'     => 'misbah_one_page_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'misbah-one-page' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'misbah_one_page_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'misbah-one-page' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'misbah-one-page' ),
		'settings'     => 'misbah_one_page_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'misbah-one-page' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'misbah-one-page' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'misbah-one-page' ),
				'description' => esc_html__( 'Add the social icon url here.', 'misbah-one-page' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}

/*
 *  Customizer Notifications
 */

$misbah_one_page_config_customizer = array(
    'recommended_plugins' => array( 
        'kirki' => array(
            'recommended' => true,
            'description' => sprintf( 
                /* translators: %s: plugin name */
                esc_html__( 'If you want to show all the sections of the FrontPage, please install and activate %s plugin', 'misbah-one-page' ), 
                '<strong>' . esc_html__( 'Kirki Customizer', 'misbah-one-page' ) . '</strong>'
            ),
        ),
    ),
    'misbah_one_page_recommended_actions'       => array(),
    'misbah_one_page_recommended_actions_title' => esc_html__( 'Recommended Actions', 'misbah-one-page' ),
    'misbah_one_page_recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'misbah-one-page' ),
    'misbah_one_page_install_button_label'      => esc_html__( 'Install and Activate', 'misbah-one-page' ),
    'misbah_one_page_activate_button_label'     => esc_html__( 'Activate', 'misbah-one-page' ),
    'misbah_one_page_deactivate_button_label'   => esc_html__( 'Deactivate', 'misbah-one-page' ),
);

Misbah_One_Page_Customizer_Notify::init( apply_filters( 'misbah_one_page_customizer_notify_array', $misbah_one_page_config_customizer ) );