<?php

class Misbah_One_Page_Customizer_Notify {

	private $config = array(); // Declare $config property
	
	private $misbah_one_page_recommended_actions;
	
	private $recommended_plugins;
	
	private static $instance;
	
	private $misbah_one_page_recommended_actions_title;
	
	private $misbah_one_page_recommended_plugins_title;
	
	private $dismiss_button;
	
	private $misbah_one_page_install_button_label;
	
	private $misbah_one_page_activate_button_label;
	
	private $misbah_one_page_deactivate_button_label;

	
	public static function init( $config ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Misbah_One_Page_Customizer_Notify ) ) {
			self::$instance = new Misbah_One_Page_Customizer_Notify;
			if ( ! empty( $config ) && is_array( $config ) ) {
				self::$instance->config = $config;
				self::$instance->setup_config();
				self::$instance->setup_actions();
			}
		}

	}

	
	public function setup_config() {

		global $misbah_one_page_customizer_notify_recommended_plugins;
		global $misbah_one_page_customizer_notify_misbah_one_page_recommended_actions;

		global $misbah_one_page_install_button_label;
		global $misbah_one_page_activate_button_label;
		global $misbah_one_page_deactivate_button_label;

		$this->misbah_one_page_recommended_actions = isset( $this->config['misbah_one_page_recommended_actions'] ) ? $this->config['misbah_one_page_recommended_actions'] : array();
		$this->recommended_plugins = isset( $this->config['recommended_plugins'] ) ? $this->config['recommended_plugins'] : array();

		$this->misbah_one_page_recommended_actions_title = isset( $this->config['misbah_one_page_recommended_actions_title'] ) ? $this->config['misbah_one_page_recommended_actions_title'] : '';
		$this->misbah_one_page_recommended_plugins_title = isset( $this->config['misbah_one_page_recommended_plugins_title'] ) ? $this->config['misbah_one_page_recommended_plugins_title'] : '';
		$this->dismiss_button            = isset( $this->config['dismiss_button'] ) ? $this->config['dismiss_button'] : '';

		$misbah_one_page_customizer_notify_recommended_plugins = array();
		$misbah_one_page_customizer_notify_misbah_one_page_recommended_actions = array();

		if ( isset( $this->recommended_plugins ) ) {
			$misbah_one_page_customizer_notify_recommended_plugins = $this->recommended_plugins;
		}

		if ( isset( $this->misbah_one_page_recommended_actions ) ) {
			$misbah_one_page_customizer_notify_misbah_one_page_recommended_actions = $this->misbah_one_page_recommended_actions;
		}

		$misbah_one_page_install_button_label    = isset( $this->config['misbah_one_page_install_button_label'] ) ? $this->config['misbah_one_page_install_button_label'] : '';
		$misbah_one_page_activate_button_label   = isset( $this->config['misbah_one_page_activate_button_label'] ) ? $this->config['misbah_one_page_activate_button_label'] : '';
		$misbah_one_page_deactivate_button_label = isset( $this->config['misbah_one_page_deactivate_button_label'] ) ? $this->config['misbah_one_page_deactivate_button_label'] : '';

	}

	
	public function setup_actions() {

		// Register the section
		add_action( 'customize_register', array( $this, 'misbah_one_page_plugin_notification_customize_register' ) );

		// Enqueue scripts and styles
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'misbah_one_page_customizer_notify_scripts_for_customizer' ), 0 );

		/* ajax callback for dismissable recommended actions */
		add_action( 'wp_ajax_quality_customizer_notify_dismiss_action', array( $this, 'misbah_one_page_customizer_notify_dismiss_recommended_action_callback' ) );

		add_action( 'wp_ajax_ti_customizer_notify_dismiss_recommended_plugins', array( $this, 'misbah_one_page_customizer_notify_dismiss_recommended_plugins_callback' ) );

	}

	
	public function misbah_one_page_customizer_notify_scripts_for_customizer() {

		wp_enqueue_style( 'misbah-one-page-customizer-notify-css', get_template_directory_uri() . '/core/includes/customizer-notice/css/misbah-one-page-customizer-notify.css', array());

		wp_enqueue_style( 'plugin-install' );
		wp_enqueue_script( 'plugin-install' );
		wp_add_inline_script( 'plugin-install', 'var pagenow = "customizer";' );

		wp_enqueue_script( 'updates' );

		wp_enqueue_script( 'misbah-one-page-customizer-notify-js', get_template_directory_uri() . '/core/includes/customizer-notice/js/misbah-one-page-customizer-notify.js', array( 'customize-controls' ));
		wp_localize_script(
			'misbah-one-page-customizer-notify-js', 'misbahonepageCustomizercompanionObject', array(
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_template_directory_uri(),
				'base_path'          => admin_url(),
				'activating_string'  => __( 'Activating', 'misbah-one-page' ),
			)
		);

	}

	
	public function misbah_one_page_plugin_notification_customize_register( $wp_customize ) {

		
		require_once get_template_directory() . '/core/includes/customizer-notice/misbah-one-page-customizer-notify-section.php';

		$wp_customize->register_section_type( 'Misbah_One_Page_Customizer_Notify_Section' );

		$wp_customize->add_section(
			new Misbah_One_Page_Customizer_Notify_Section(
				$wp_customize,
				'misbah-one-page-customizer-notify-section',
				array(
					'title'          => $this->misbah_one_page_recommended_actions_title,
					'plugin_text'    => $this->misbah_one_page_recommended_plugins_title,
					'dismiss_button' => $this->dismiss_button,
					'priority'       => 0,
				)
			)
		);

	}

	
	public function misbah_one_page_customizer_notify_dismiss_recommended_action_callback() {

		global $misbah_one_page_customizer_notify_misbah_one_page_recommended_actions;

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */ 

		if ( ! empty( $action_id ) ) {
			
			if ( get_option( 'misbah_one_page_customizer_notify_show' ) ) {

				$misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions = get_option( 'misbah_one_page_customizer_notify_show' );
				switch ( $_GET['todo'] ) {
					case 'add':
						$misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions[ $action_id ] = true;
						break;
					case 'dismiss':
						$misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions[ $action_id ] = false;
						break;
				}
				update_option( 'misbah_one_page_customizer_notify_show', $misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions );

				
			} else {
				$misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions = array();
				if ( ! empty( $misbah_one_page_customizer_notify_misbah_one_page_recommended_actions ) ) {
					foreach ( $misbah_one_page_customizer_notify_misbah_one_page_recommended_actions as $misbah_one_page_lite_customizer_notify_recommended_action ) {
						if ( $misbah_one_page_lite_customizer_notify_recommended_action['id'] == $action_id ) {
							$misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions[ $misbah_one_page_lite_customizer_notify_recommended_action['id'] ] = false;
						} else {
							$misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions[ $misbah_one_page_lite_customizer_notify_recommended_action['id'] ] = true;
						}
					}
					update_option( 'misbah_one_page_customizer_notify_show', $misbah_one_page_customizer_notify_show_misbah_one_page_recommended_actions );
				}
			}
		}
		die(); 
	}

	
	public function misbah_one_page_customizer_notify_dismiss_recommended_plugins_callback() {

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */

		if ( ! empty( $action_id ) ) {

			$misbah_one_page_lite_customizer_notify_show_recommended_plugins = get_option( 'misbah_one_page_customizer_notify_show_recommended_plugins' );

			switch ( $_GET['todo'] ) {
				case 'add':
					$misbah_one_page_lite_customizer_notify_show_recommended_plugins[ $action_id ] = false;
					break;
				case 'dismiss':
					$misbah_one_page_lite_customizer_notify_show_recommended_plugins[ $action_id ] = true;
					break;
			}
			update_option( 'misbah_one_page_customizer_notify_show_recommended_plugins', $misbah_one_page_lite_customizer_notify_show_recommended_plugins );
		}
		die(); 
	}

}
