<?php
/**
 * Right Buttons Panel.
 *
 * @package mirrors_interior
 */
?>
<div class="panel-right">
	<div class="pro-btn theme-btn">
		<div class="screenshot">
			<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/pro-screenshot.png'; ?>" />
		</div>
		<br>
		<div class="theme-info">
			<h3><?php esc_html_e( 'Mirrors Interior WordPress Theme', 'mirrors-interior' ); ?></h3>
			<div class="theme-price">
				<span class="price-text"><?php esc_html_e( 'Price:', 'mirrors-interior' ); ?></h6>
				<del><?php esc_html_e( '$49', 'mirrors-interior' ); ?></del>
				<span><?php esc_html_e( '$39', 'mirrors-interior' ); ?></span>
			</div>
			<div class="panelbutton">
				<a class="button button-primary" href="<?php echo esc_url( MIRRORS_INTERIOR_PREMIUM_PAGE ); ?>" title="<?php esc_attr_e( 'Go Pro', 'mirrors-interior' ); ?>" target="_blank"><?php esc_html_e( 'Try Premium', 'mirrors-interior' ); ?></a>

				<a class="button button-primary" href="<?php echo esc_url( MIRRORS_INTERIOR_PRO_DEMO ); ?>" title="<?php esc_attr_e( 'Live Demo', 'mirrors-interior' ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'mirrors-interior' ); ?></a>
			</div>
			<a class="button button-primary pro-doc" href="<?php echo esc_url( MIRRORS_INTERIOR_PREMIUM_DOCUMENTATION ); ?>" title="<?php esc_attr_e( 'Pro Documentation', 'mirrors-interior' ); ?>" target="_blank"><?php esc_html_e( 'Pro Documentation', 'mirrors-interior' ); ?></a>
		</div>
	</div>
	<div class="pro-btn bundle-btn">
		<div class="bundle-img">
			<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/bundle.png'; ?>" />
		</div>
		<br>
		<h3><?php esc_html_e( 'WP Theme Bundle', 'mirrors-interior' ); ?></h3>
		<p><?php esc_html_e( 'Get access to a collection of premium WordPress themes in one bundle. Enjoy effortless website building, full customization, and dedicated customer support for a smooth, professional web experience.', 'mirrors-interior' ); ?></p>
		<a class="button button-primary" href="<?php echo esc_url( MIRRORS_INTERIOR_BUNDLE_PAGE ); ?>" title="<?php esc_attr_e( 'Go Pro', 'mirrors-interior' ); ?>" target="_blank">
            <?php esc_html_e( 'Exclusive Theme Bundle - $79', 'mirrors-interior' ); ?>
        </a>
	</div>
</div>