<?php
/**
 * Help Panel.
 *
 * @package mirrors_interior
 */
?>

<div id="help-panel" class="panel-left visible">
    <div id="#help-panel" class="steps">  
        <h4 class="c">
            <?php esc_html_e( 'Quick Setup for Home Page', 'mirrors-interior' ); ?>
            <a href="<?php echo esc_url( MIRRORS_INTERIOR_THEME_DOCUMENTATION ); ?>" class="button button-primary" style="margin-left: 5px; margin-right: 10px;" target="_blank"><?php esc_html_e( 'Free Theme Documentation', 'mirrors-interior' ); ?></a>
        </h4>
        <hr class="quick-set">
        <p><?php esc_html_e( '1) Go to the dashboard. navigate to pages, add a new one, and label it "home" or whatever else you like.The page has now been created.', 'mirrors-interior' ); ?></p>
        <p><?php esc_html_e( '2) Go back to the dashboard and then select Settings.', 'mirrors-interior' ); ?></p>
        <p><?php esc_html_e( '3) Then Go to readings in the setting.', 'mirrors-interior' ); ?></p>
        <p><?php esc_html_e( '4) There are 2 options your latest post or static page.', 'mirrors-interior' ); ?></p>
        <p><?php esc_html_e( '5) Select static page and select from the dropdown you wish to use as your home page, save changes.', 'mirrors-interior' ); ?></p>
        <p><?php esc_html_e( '6) You can set the home page in this manner.', 'mirrors-interior' ); ?></p>
        <br>
        <h4><?php esc_html_e( 'Setup Banner Section', 'mirrors-interior' ); ?></h4>
        <hr class="quick-set">
         <p><?php esc_html_e( '1) Go to Appereance > then Go to Customizer.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '2) In Customizer > Go to Front Page Options > Go to Banner Section.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '3) For Setup Banner Section you have to create post in dashboard first.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '4) In Banner Section > Enable the Toggle button > and fill the following details.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '5) In this way you can set Banner Section.', 'mirrors-interior' ); ?></p>
        <br>
        <h4><?php esc_html_e( 'Setup Product Section', 'mirrors-interior' ); ?></h4>
        <hr class="quick-set">
         <p><?php esc_html_e( '1) Go to Products > Add New, and create products under the category you want to display.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '2) Make sure to assign a category to each product (e.g., Mirrors, Interior, etc.).', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '3) Go to Appearance > Customize > Front Page Options > Mirrors Product Section.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '4) In the Mirrors Product Section, Enable the Toggle button, add a heading, and select the product category you created.', 'mirrors-interior' ); ?></p>
         <p><?php esc_html_e( '5) In this way you can set Mirrors Product Section.', 'mirrors-interior' ); ?></p> 
        <br>
    </div>
    <div class="custom-setting">
        <h4><?php esc_html_e( 'Quick Customizer Settings', 'mirrors-interior' ); ?></h4>
        <span><a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a></span>
    </div>
    <hr>
   <div class="setting-box">
        <div class="custom-links">
            <div class="icon-box">
                <img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/img1.png'; ?>" />
            </div>
            <h5><?php esc_html_e( 'Site Logo', 'mirrors-interior' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=custom_logo' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/img2.png'; ?>" />
            </div>
            <h5><?php esc_html_e( 'Color Picker', 'mirrors-interior' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=primary_color' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/img3.png'; ?>" />
            </div>
            <h5><?php esc_html_e( 'Theme Options', 'mirrors-interior' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[panel]=mirrors_interior_theme_options' ) ); ?>"target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a>
            
        </div>
    </div>
    <div class="setting-box">
        <div class="custom-links">
            <div class="icon-box">
                <img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/img4.png'; ?>" />
            </div>
            <h5><?php esc_html_e( 'Header Image ', 'mirrors-interior' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=header_image' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/img5.png'; ?>" />
            </div>
            <h5><?php esc_html_e( 'Footer Option ', 'mirrors-interior' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=mirrors_interior_footer_copyright_text' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/img6.png'; ?>" />
            </div>
            <h5><?php esc_html_e( 'Front Page Option', 'mirrors-interior' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[panel]=mirrors_interior_front_page_options' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'mirrors-interior' ); ?></a>
            
        </div>
    </div>
</div>