<?php
function mirrors_interior_get_all_google_fonts() {
    $mirrors_interior_webfonts_json = get_template_directory() . '/theme-library/google-webfonts.json';
    if ( ! file_exists( $mirrors_interior_webfonts_json ) ) {
        return array();
    }

    $mirrors_interior_fonts_json_data = file_get_contents( $mirrors_interior_webfonts_json );
    if ( false === $mirrors_interior_fonts_json_data ) {
        return array();
    }

    $mirrors_interior_all_fonts = json_decode( $mirrors_interior_fonts_json_data, true );
    if ( json_last_error() !== JSON_ERROR_NONE ) {
        return array();
    }

    $mirrors_interior_google_fonts = array();
    foreach ( $mirrors_interior_all_fonts as $mirrors_interior_font ) {
        $mirrors_interior_google_fonts[ $mirrors_interior_font['family'] ] = array(
            'family'   => $mirrors_interior_font['family'],
            'variants' => $mirrors_interior_font['variants'],
        );
    }
    return $mirrors_interior_google_fonts;
}


function mirrors_interior_get_all_google_font_families() {
    $mirrors_interior_google_fonts  = mirrors_interior_get_all_google_fonts();
    $mirrors_interior_font_families = array();
    foreach ( $mirrors_interior_google_fonts as $mirrors_interior_font ) {
        $mirrors_interior_font_families[ $mirrors_interior_font['family'] ] = $mirrors_interior_font['family'];
    }
    return $mirrors_interior_font_families;
}

function mirrors_interior_get_fonts_url() {
    $mirrors_interior_fonts_url = '';
    $mirrors_interior_fonts     = array();

    $mirrors_interior_all_fonts = mirrors_interior_get_all_google_fonts();

    if ( ! empty( get_theme_mod( 'mirrors_interior_site_title_font', 'Raleway' ) ) ) {
        $mirrors_interior_fonts[] = get_theme_mod( 'mirrors_interior_site_title_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'mirrors_interior_site_description_font', 'Raleway' ) ) ) {
        $mirrors_interior_fonts[] = get_theme_mod( 'mirrors_interior_site_description_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'mirrors_interior_header_font', 'Epilogue' ) ) ) {
        $mirrors_interior_fonts[] = get_theme_mod( 'mirrors_interior_header_font', 'Epilogue' );
    }

    if ( ! empty( get_theme_mod( 'mirrors_interior_content_font', 'Century Gothic' ) ) ) {
        $mirrors_interior_fonts[] = get_theme_mod( 'mirrors_interior_content_font', 'Century Gothic' );
    }

    $mirrors_interior_fonts = array_unique( $mirrors_interior_fonts );

    foreach ( $mirrors_interior_fonts as $mirrors_interior_font ) {
        $mirrors_interior_variants      = $mirrors_interior_all_fonts[ $mirrors_interior_font ]['variants'];
        $mirrors_interior_font_family[] = $mirrors_interior_font . ':' . implode( ',', $mirrors_interior_variants );
    }

    $mirrors_interior_query_args = array(
        'family' => urlencode( implode( '|', $mirrors_interior_font_family ) ),
    );

    if ( ! empty( $mirrors_interior_font_family ) ) {
        $mirrors_interior_fonts_url = add_query_arg( $mirrors_interior_query_args, 'https://fonts.googleapis.com/css' );
    }

    return $mirrors_interior_fonts_url;
}