<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package mirrors_interior
 */


function mirrors_interior_customize_css() {
    ?>
    <style type="text/css">
        :root {
            --primary-color: <?php echo esc_html( get_theme_mod( 'primary_color', '#c70404' ) ); ?>;
        }
    </style>
    <?php
}
add_action( 'wp_head', 'mirrors_interior_customize_css' );


function mirrors_interior_enqueue_selected_fonts() {
    $mirrors_interior_fonts_url = mirrors_interior_get_fonts_url();
    if (!empty($mirrors_interior_fonts_url)) {
        wp_enqueue_style('mirrors-interior-google-fonts', $mirrors_interior_fonts_url, array(), null);
    }
}
add_action('wp_enqueue_scripts', 'mirrors_interior_enqueue_selected_fonts');

function mirrors_interior_layout_customizer_css() {
    $mirrors_interior_margin = get_theme_mod('mirrors_interior_layout_width_margin', 50);
    ?>
    <style type="text/css">
        body.site-boxed--layout #page  {
            margin: 0 <?php echo esc_attr($mirrors_interior_margin); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_layout_customizer_css');

function mirrors_interior_blog_layout_customizer_css() {
    // Retrieve the blog layout option
    $mirrors_interior_blog_layout_option = get_theme_mod('mirrors_interior_blog_layout_option_setting', 'Left');

    // Initialize custom CSS variable
    $mirrors_interior_custom_css = '';

    // Generate custom CSS based on the layout option
    if ($mirrors_interior_blog_layout_option === 'Default') {
        $mirrors_interior_custom_css .= '.mag-post-detail { text-align: center; }';
    } elseif ($mirrors_interior_blog_layout_option === 'Left') {
        $mirrors_interior_custom_css .= '.mag-post-detail { text-align: left; }';
    } elseif ($mirrors_interior_blog_layout_option === 'Right') {
        $mirrors_interior_custom_css .= '.mag-post-detail { text-align: right; }';
    }

    // Output the combined CSS
    ?>
    <style type="text/css">
        <?php echo wp_kses($mirrors_interior_custom_css, array( 'style' => array(), 'text-align' => array() )); ?>
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_blog_layout_customizer_css');

// Featured Image Dimension
function mirrors_interior_custom_featured_image_css() {
    $mirrors_interior_dimension = get_theme_mod('mirrors_interior_blog_post_featured_image_dimension', 'default');
    $mirrors_interior_width = get_theme_mod('mirrors_interior_blog_post_featured_image_custom_width', '');
    $mirrors_interior_height = get_theme_mod('mirrors_interior_blog_post_featured_image_custom_height', '');
    
    if ($mirrors_interior_dimension === 'custom' && $mirrors_interior_width && $mirrors_interior_height) {
        $mirrors_interior_custom_css = "body:not(.single-post) .mag-post-single .mag-post-img img { width: {$mirrors_interior_width}px !important; height: {$mirrors_interior_height}px !important; }";
        wp_add_inline_style('mirrors-interior-style', $mirrors_interior_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'mirrors_interior_custom_featured_image_css');

// Featured Image Border Radius
function mirrors_interior_featured_image_border_radius_css() {
    $mirrors_interior_featured_image_border_radius = get_theme_mod('mirrors_interior_featured_image_border_radius', 10);
    ?>
    <style type="text/css">  
        .mag-post-single img {
            border-radius: <?php echo esc_attr($mirrors_interior_featured_image_border_radius); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_featured_image_border_radius_css');

function mirrors_interior_sidebar_width_customizer_css() {
    $mirrors_interior_sidebar_width = get_theme_mod('mirrors_interior_sidebar_width', '30');
    ?>
    <style type="text/css">
        .right-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: auto <?php echo esc_attr($mirrors_interior_sidebar_width); ?>%;
        }
        .left-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: <?php echo esc_attr($mirrors_interior_sidebar_width); ?>% auto;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_sidebar_width_customizer_css');

if ( ! function_exists( 'mirrors_interior_get_page_title' ) ) {
    function mirrors_interior_get_page_title() {
        $mirrors_interior_title = '';

        if (is_404()) {
            $mirrors_interior_title = esc_html__('Page Not Found', 'mirrors-interior');
        } elseif (is_search()) {
            $mirrors_interior_title = esc_html__('Search Results for: ', 'mirrors-interior') . esc_html(get_search_query());
        } elseif (is_home() && !is_front_page()) {
            $mirrors_interior_title = esc_html__('Blogs', 'mirrors-interior');
        } elseif (function_exists('is_shop') && is_shop()) {
            $mirrors_interior_title = esc_html__('Shop', 'mirrors-interior');
        } elseif (is_page()) {
            $mirrors_interior_title = get_the_title();
        } elseif (is_single()) {
            $mirrors_interior_title = get_the_title();
        } elseif (is_archive()) {
            $mirrors_interior_title = get_the_archive_title();
        } else {
            $mirrors_interior_title = get_the_archive_title();
        }

        return apply_filters('mirrors_interior_page_title', $mirrors_interior_title);
    }
}

if ( ! function_exists( 'mirrors_interior_has_page_header' ) ) {
    function mirrors_interior_has_page_header() {
        // Default to true (display header)
        $mirrors_interior_return = true;

        // Custom conditions for disabling the header
        if ('hide-all-devices' === get_theme_mod('mirrors_interior_page_header_visibility', 'all-devices')) {
            $mirrors_interior_return = false;
        }

        // Apply filters and return
        return apply_filters('mirrors_interior_display_page_header', $mirrors_interior_return);
    }
}

if ( ! function_exists( 'mirrors_interior_page_header_style' ) ) {
    function mirrors_interior_page_header_style() {
        $mirrors_interior_style = get_theme_mod('mirrors_interior_page_header_style', 'default');
        return apply_filters('mirrors_interior_page_header_style', $mirrors_interior_style);
    }
}

function mirrors_interior_page_title_customizer_css() {
    $mirrors_interior_layout_option = get_theme_mod('mirrors_interior_page_header_layout', 'left');
    ?>
    <style type="text/css">
        .asterthemes-wrapper.page-header-inner {
            <?php if ($mirrors_interior_layout_option === 'flex') : ?>
                display: flex;
                justify-content: space-between;
                align-items: center;
            <?php else : ?>
                text-align: <?php echo esc_attr($mirrors_interior_layout_option); ?>;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_page_title_customizer_css');

function mirrors_interior_pagetitle_height_css() {
    $mirrors_interior_height = get_theme_mod('mirrors_interior_pagetitle_height', 50);
    ?>
    <style type="text/css">
        header.page-header {
            padding: <?php echo esc_attr($mirrors_interior_height); ?>px 0;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_pagetitle_height_css');

function mirrors_interior_site_logo_width() {
    $mirrors_interior_site_logo_width = get_theme_mod('mirrors_interior_site_logo_width', 200);
    ?>
    <style type="text/css">
        .site-logo img {
            max-width: <?php echo esc_attr($mirrors_interior_site_logo_width); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_site_logo_width');

function mirrors_interior_menu_font_size_css() {
    $mirrors_interior_menu_font_size = get_theme_mod('mirrors_interior_menu_font_size', 15);
    ?>
    <style type="text/css">
        .main-navigation a {
            font-size: <?php echo esc_attr($mirrors_interior_menu_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_menu_font_size_css');

function mirrors_interior_sidebar_widget_font_size_css() {
    $mirrors_interior_sidebar_widget_font_size = get_theme_mod('mirrors_interior_sidebar_widget_font_size', 24);
    ?>
    <style type="text/css">
        h2.wp-block-heading,aside#secondary .widgettitle,aside#secondary .widget-title {
            font-size: <?php echo esc_attr($mirrors_interior_sidebar_widget_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_sidebar_widget_font_size_css');

// Woocommerce Related Products Settings
function mirrors_interior_related_product_css() {
    $mirrors_interior_related_product_show_hide = get_theme_mod('mirrors_interior_related_product_show_hide', true);

    if ( $mirrors_interior_related_product_show_hide != true) {
        ?>
        <style type="text/css">
            .related.products {
                display: none;
            }
        </style>
        <?php
    }
}
add_action('wp_head', 'mirrors_interior_related_product_css');

// Woocommerce Product Sale Position 
function mirrors_interior_product_sale_position_customizer_css() {
    $mirrors_interior_layout_option = get_theme_mod('mirrors_interior_product_sale_position', 'left');
    ?>
    <style type="text/css">
        .woocommerce ul.products li.product .onsale{
            <?php if ($mirrors_interior_layout_option === 'left') : ?>
                right: auto;
                left: 15px;
            <?php else : ?>
                left: auto;
                right: 15px;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_product_sale_position_customizer_css');

//Footer Social Icon Alignment
function mirrors_interior_footer_icons_alignment_css() {
    $mirrors_interior_footer_social_align = get_theme_mod( 'mirrors_interior_footer_social_align', 'center' );   
    ?>
    <style type="text/css">
        .socialicons {
            text-align: <?php echo esc_attr( $mirrors_interior_footer_social_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .socialicons {
                text-align: center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'mirrors_interior_footer_icons_alignment_css' );

//Copyright Alignment
function mirrors_interior_footer_copyright_alignment_css() {
    $mirrors_interior_footer_bottom_align = get_theme_mod( 'mirrors_interior_footer_bottom_align', 'center' );   
    ?>
    <style type="text/css">
        .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
            justify-content: <?php echo esc_attr( $mirrors_interior_footer_bottom_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
                justify-content: center;
                text-align:center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'mirrors_interior_footer_copyright_alignment_css' );

//Copyright Font Size
function mirrors_interior_copyright_font_size_css() {
    $mirrors_interior_copyright_font_size = get_theme_mod('mirrors_interior_copyright_font_size', 16);
    ?>
    <style type="text/css">
        .site-footer-bottom .site-info span {
            font-size: <?php echo esc_attr($mirrors_interior_copyright_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_copyright_font_size_css');

// Preloader Background Color Setting
function mirrors_interior_preloader_background_colors_css() {
    $mirrors_interior_preloader_background_color_setting = get_theme_mod('mirrors_interior_preloader_background_color_setting', '');
        // Only output CSS if a color is set
        if (empty($mirrors_interior_preloader_background_color_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-color: <?php echo esc_attr($mirrors_interior_preloader_background_color_setting); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_preloader_background_colors_css');

// Preloader Background Image Setting
function mirrors_interior_preloader_background_image_css() {
    $mirrors_interior_preloader_background_image_setting = get_theme_mod('mirrors_interior_preloader_background_image_setting', '');
        // Only output CSS if the background image is set
        if (empty($mirrors_interior_preloader_background_image_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-image: url('<?php echo esc_url($mirrors_interior_preloader_background_image_setting); ?>');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }
    </style>
    <?php
}
add_action('wp_head', 'mirrors_interior_preloader_background_image_css');

//Footer Heading Alignment
function mirrors_interior_footer_heading_alignment_css() {
    $mirrors_interior_footer_header_align = get_theme_mod( 'mirrors_interior_footer_header_align', 'left' );   
    ?>
    <style type="text/css">
        .site-footer h4, footer#colophon h2.wp-block-heading, footer#colophon .widgettitle, footer#colophon .widget-title {
            text-align: <?php echo esc_attr( $mirrors_interior_footer_header_align ); ?> 
        }
    </style>
    <?php
}
add_action( 'wp_head', 'mirrors_interior_footer_heading_alignment_css' );