<?php

/**
 * Dynamic CSS
 */
function mirrors_interior_dynamic_css() {
	$primary_color = get_theme_mod( 'primary_color', '#c70404' );

	$mirrors_interior_site_title_font       = get_theme_mod( 'mirrors_interior_site_title_font', 'Raleway' );
	$mirrors_interior_site_description_font = get_theme_mod( 'mirrors_interior_site_description_font', 'Raleway' );
	$mirrors_interior_header_font           = get_theme_mod( 'mirrors_interior_header_font', 'Epilogue' );
	$mirrors_interior_content_font             = get_theme_mod( 'mirrors_interior_content_font', 'Century Gothic' );

	// Enqueue Google Fonts
	$fonts_url = mirrors_interior_get_fonts_url();
	if ( ! empty( $fonts_url ) ) {
		wp_enqueue_style( 'mirrors-interior-google-fonts', esc_url( $fonts_url ), array(), null );
	}

	$mirrors_interior_custom_css  = '';
	$mirrors_interior_custom_css .= '
    /* Color */
    :root {
        --primary-color: ' . esc_attr( $primary_color ) . ';
        --header-text-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
    }
    ';

	$mirrors_interior_custom_css .= '
    /* Typography */
    :root {
        --font-heading: "' . esc_attr( $mirrors_interior_header_font ) . '", serif;
        --font-main: -apple-system, BlinkMacSystemFont, "' . esc_attr( $mirrors_interior_content_font ) . '", "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    body,
	button, input, select, optgroup, textarea, p {
        font-family: "' . esc_attr( $mirrors_interior_content_font ) . '", serif;
	}

	.site-identity p.site-title, h1.site-title a, h1.site-title, p.site-title a, .site-branding h1.site-title a {
        font-family: "' . esc_attr( $mirrors_interior_site_title_font ) . '", serif;
	}
    
	p.site-description {
        font-family: "' . esc_attr( $mirrors_interior_site_description_font ) . '", serif !important;
	}
    ';

	wp_add_inline_style( 'mirrors-interior-style', $mirrors_interior_custom_css );
}
add_action( 'wp_enqueue_scripts', 'mirrors_interior_dynamic_css', 99 );