<?php

/**
 * WooCommerce Settings
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_woocommerce_settings',
	array(
		'panel' => 'mirrors_interior_theme_options',
		'title' => esc_html__( 'WooCommerce Settings', 'mirrors-interior' ),
	)
);

//WooCommerce - Products per page.
$wp_customize->add_setting( 'mirrors_interior_products_per_page', array(
    'default'           => 9,
    'sanitize_callback' => 'absint',
));

$wp_customize->add_control( 'mirrors_interior_products_per_page', array(
    'type'        => 'number',
    'section'     => 'mirrors_interior_woocommerce_settings',
    'label'       => __( 'Products Per Page', 'mirrors-interior' ),
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 50,
        'step' => 1,
    ),
));

//WooCommerce - Products per row.
$wp_customize->add_setting( 'mirrors_interior_products_per_row', array(
    'default'           => '3',
    'sanitize_callback' => 'mirrors_interior_sanitize_choices',
) );

$wp_customize->add_control( 'mirrors_interior_products_per_row', array(
    'label'    => __( 'Products Per Row', 'mirrors-interior' ),
    'section'  => 'mirrors_interior_woocommerce_settings',
    'settings' => 'mirrors_interior_products_per_row',
    'type'     => 'select',
    'choices'  => array(
        '2' => '2',
		'3' => '3',
		'4' => '4',
    ),
) );

//WooCommerce - Show / Hide Related Product.
$wp_customize->add_setting(
	'mirrors_interior_related_product_show_hide',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_related_product_show_hide',
		array(
			'label'   => esc_html__( 'Show / Hide Related product', 'mirrors-interior' ),
			'section' => 'mirrors_interior_woocommerce_settings',
		)
	)
);

//WooCommerce - Product Sale Position.
$wp_customize->add_setting(
	'mirrors_interior_product_sale_position', 
	array(
		'default' => 'left',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'mirrors_interior_product_sale_position', 
	array(
		'label' => __('Product Sale Position', 'mirrors-interior'),
		'section' => 'mirrors_interior_woocommerce_settings',
		'settings' => 'mirrors_interior_product_sale_position',
		'type' => 'radio',
		'choices' => 
	array(
		'left' => __('Left', 'mirrors-interior'),
		'right' => __('Right', 'mirrors-interior'),
	),
));