<?php

/**
 * Typography Settings
 *
 * @package mirrors_interior
 */

// Typography Settings
$wp_customize->add_section(
    'mirrors_interior_typography_setting',
    array(
        'panel' => 'mirrors_interior_theme_options',
        'title' => esc_html__( 'Typography Settings', 'mirrors-interior' ),
    )
);

$wp_customize->add_setting(
    'mirrors_interior_site_title_font',
    array(
        'default'           => 'Raleway',
        'sanitize_callback' => 'mirrors_interior_sanitize_google_fonts',
    )
);

$wp_customize->add_control(
    'mirrors_interior_site_title_font',
    array(
        'label'    => esc_html__( 'Site Title Font Family', 'mirrors-interior' ),
        'section'  => 'mirrors_interior_typography_setting',
        'settings' => 'mirrors_interior_site_title_font',
        'type'     => 'select',
        'choices'  => mirrors_interior_get_all_google_font_families(),
    )
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'mirrors_interior_site_description_font',
	array(
		'default'           => 'Raleway',
		'sanitize_callback' => 'mirrors_interior_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'mirrors_interior_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'mirrors-interior' ),
		'section'  => 'mirrors_interior_typography_setting',
		'settings' => 'mirrors_interior_site_description_font',
		'type'     => 'select',
		'choices'  => mirrors_interior_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'mirrors_interior_header_font',
	array(
		'default'           => 'Epilogue',
		'sanitize_callback' => 'mirrors_interior_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'mirrors_interior_header_font',
	array(
		'label'    => esc_html__( 'Heading Font Family', 'mirrors-interior' ),
		'section'  => 'mirrors_interior_typography_setting',
		'settings' => 'mirrors_interior_header_font',
		'type'     => 'select',
		'choices'  => mirrors_interior_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'mirrors_interior_content_font',
	array(
		'default'           => 'Century Gothic',
		'sanitize_callback' => 'mirrors_interior_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'mirrors_interior_content_font',
	array(
		'label'    => esc_html__( 'Content Font Family', 'mirrors-interior' ),
		'section'  => 'mirrors_interior_typography_setting',
		'settings' => 'mirrors_interior_content_font',
		'type'     => 'select',
		'choices'  => mirrors_interior_get_all_google_font_families(),
	)
);
