<?php

/**
 * Header Options
 *
 * @package mirrors_interior
 */

// ---------------------------------------- GENERAL OPTIONBS ----------------------------------------------------


// ---------------------------------------- PRELOADER ----------------------------------------------------

$wp_customize->add_section(
	'mirrors_interior_general_options',
	array(
		'panel' => 'mirrors_interior_theme_options',
		'title' => esc_html__( 'General Options', 'mirrors-interior' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_preloader_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_preloader_separator', array(
	'label' => __( 'Enable / Disable Site Preloader Section', 'mirrors-interior' ),
	'section' => 'mirrors_interior_general_options',
	'settings' => 'mirrors_interior_preloader_separator',
) ) );

// General Options - Enable Preloader.
$wp_customize->add_setting(
	'mirrors_interior_enable_preloader',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_preloader',
		array(
			'label'   => esc_html__( 'Enable Preloader', 'mirrors-interior' ),
			'section' => 'mirrors_interior_general_options',
		)
	)
);

// Preloader Style Setting
$wp_customize->add_setting(
    'mirrors_interior_preloader_style',
    array(
        'default'           => 'style1',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'mirrors_interior_preloader_style',
    array(
        'type'     => 'select',
        'label'    => esc_html__('Select Preloader Styles', 'mirrors-interior'),
		'active_callback' => 'mirrors_interior_is_preloader_style',
        'section'  => 'mirrors_interior_general_options',
        'choices'  => array(
            'style1' => esc_html__('Style 1', 'mirrors-interior'),
            'style2' => esc_html__('Style 2', 'mirrors-interior'),
            'style3' => esc_html__('Style 3', 'mirrors-interior'),
        ),
    )
);


// Preloader Background Color Setting
$wp_customize->add_setting(
	'mirrors_interior_preloader_background_color_setting',
	 array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 'mirrors_interior_preloader_background_color_setting', 
		array(
			'label' => __('Preloader Background Color', 'mirrors-interior'),
			'active_callback' => 'mirrors_interior_is_preloader_style',
			'section' => 'mirrors_interior_general_options',
		)
	)
);

// Preloader Background Image Setting
$wp_customize->add_setting(
	'mirrors_interior_preloader_background_image_setting', 
	array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize, 'mirrors_interior_preloader_background_image_setting',
		 array(
			'label' => __('Preloader Background Image', 'mirrors-interior'),
			'active_callback' => 'mirrors_interior_is_preloader_style',
			'section' => 'mirrors_interior_general_options',
		)
	)
);

// ---------------------------------------- PAGINATION ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_pagination_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_pagination_separator', array(
	'label' => __( 'Enable / Disable Pagination Section', 'mirrors-interior' ),
	'section' => 'mirrors_interior_general_options',
	'settings' => 'mirrors_interior_pagination_separator',
) ) );


// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'mirrors_interior_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'mirrors-interior' ),
			'section'  => 'mirrors_interior_general_options',
			'settings' => 'mirrors_interior_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'mirrors_interior_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
	)
);

$wp_customize->add_control(
	'mirrors_interior_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'mirrors-interior' ),
		'section'         => 'mirrors_interior_general_options',
		'settings'        => 'mirrors_interior_pagination_type',
		'active_callback' => 'mirrors_interior_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'mirrors-interior' ),
			'numeric' => __( 'Numeric', 'mirrors-interior' ),
		),
	)
);


// ---------------------------------------- BREADCRUMB ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_breadcrumb_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_breadcrumb_separators', array(
	'label' => __( 'Enable / Disable Breadcrumb Section', 'mirrors-interior' ),
	'section' => 'mirrors_interior_general_options',
	'settings' => 'mirrors_interior_breadcrumb_separators',
)));


// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'mirrors_interior_enable_breadcrumb',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'mirrors-interior' ),
			'section' => 'mirrors_interior_general_options',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'mirrors_interior_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'mirrors_interior_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'mirrors-interior' ),
		'active_callback' => 'mirrors_interior_is_breadcrumb_enabled',
		'section'         => 'mirrors_interior_general_options',
	)
);



// ---------------------------------------- Website layout ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_layuout_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_layuout_separator', array(
	'label' => __( 'Website Layout Setting', 'mirrors-interior' ),
	'section' => 'mirrors_interior_general_options',
	'settings' => 'mirrors_interior_layuout_separator',
)));


$wp_customize->add_setting(
	'mirrors_interior_website_layout',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_website_layout',
		array(
			'label'   => esc_html__('Boxed Layout', 'mirrors-interior'),
			'section' => 'mirrors_interior_general_options',
		)
	)
);


$wp_customize->add_setting('mirrors_interior_layout_width_margin', array(
	'default'           => 50,
	'sanitize_callback' => 'mirrors_interior_sanitize_range_value',
));

$wp_customize->add_control(new Mirrors_Interior_Customize_Range_Control($wp_customize, 'mirrors_interior_layout_width_margin', array(
		'label'       => __('Set Width', 'mirrors-interior'),
		'description' => __('Adjust the width around the website layout by moving the slider. Use this setting to customize the appearance of your site to fit your design preferences.', 'mirrors-interior'),
		'section'     => 'mirrors_interior_general_options',
		'settings'    => 'mirrors_interior_layout_width_margin',
		'active_callback' => 'mirrors_interior_is_layout_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 130,
			'step' => 1,
		),
)));



// ---------------------------------------- HEADER OPTIONS ----------------------------------------------------	


$wp_customize->add_section(
	'mirrors_interior_header_options',
	array(
		'panel' => 'mirrors_interior_theme_options',
		'title' => esc_html__( 'Header Options', 'mirrors-interior' ),
	)
);

// Add setting for sticky header
$wp_customize->add_setting(
	'mirrors_interior_enable_sticky_header',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => false,
	)
);

// Add control for sticky header setting
$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_sticky_header',
		array(
			'label'   => esc_html__( 'Enable Sticky Header', 'mirrors-interior' ),
			'section' => 'mirrors_interior_header_options',
		)
	)
);

// Header Options - Enable Topbar.
$wp_customize->add_setting(
	'mirrors_interior_enable_topbar',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_topbar',
		array(
			'label'   => esc_html__( 'Enable Topbar', 'mirrors-interior' ),
			'section' => 'mirrors_interior_header_options',
		)
	)
);

// Header Options - Welcome Text.
$wp_customize->add_setting(
	'mirrors_interior_welcome_topbar_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'mirrors_interior_welcome_topbar_text',
	array(
		'label'           => esc_html__( 'Topbar Text', 'mirrors-interior' ),
		'section'         => 'mirrors_interior_header_options',
		'type'            => 'text',
		'active_callback' => 'mirrors_interior_is_topbar_enabled',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_menu_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_menu_separator', array(
	'label' => __( 'Menu Settings', 'mirrors-interior' ),
	'section' => 'mirrors_interior_header_options',
	'settings' => 'mirrors_interior_menu_separator',
)));

$wp_customize->add_setting( 'mirrors_interior_menu_font_size', array(
    'default'           => 15,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'mirrors_interior_menu_font_size', array(
    'type'        => 'number',
    'section'     => 'mirrors_interior_header_options',
    'label'       => __( 'Menu Font Size ', 'mirrors-interior' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));


$wp_customize->add_setting( 'mirrors_interior_menu_text_transform', array(
    'default'           => 'capitalize', // Default value for text transform
    'sanitize_callback' => 'sanitize_text_field',
) );

// Add control for menu text transform
$wp_customize->add_control( 'mirrors_interior_menu_text_transform', array(
    'type'     => 'select',
    'section'  => 'mirrors_interior_header_options', // Adjust the section as needed
    'label'    => __( 'Menu Text Transform', 'mirrors-interior' ),
    'choices'  => array(
        'none'       => __( 'None', 'mirrors-interior' ),
        'capitalize' => __( 'Capitalize', 'mirrors-interior' ),
        'uppercase'  => __( 'Uppercase', 'mirrors-interior' ),
        'lowercase'  => __( 'Lowercase', 'mirrors-interior' ),
    ),
) );

// Menu Text Color 
$wp_customize->add_setting(
	'mirrors_interior_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'mirrors_interior_menu_text_color', 
		array(
			'label' => __('Menu Color', 'mirrors-interior'),
			'section' => 'mirrors_interior_header_options',
		)
	)
);

// Sub Menu Text Color 
$wp_customize->add_setting(
	'mirrors_interior_sub_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'mirrors_interior_sub_menu_text_color', 
		array(
			'label' => __('Sub Menu Color', 'mirrors-interior'),
			'section' => 'mirrors_interior_header_options',
		)
	)
);

// ----------------------------------------SITE IDENTITY----------------------------------------------------


// Site Logo - Enable Setting.
$wp_customize->add_setting(
	'mirrors_interior_enable_site_logo',
	array(
		'default'           => true, // Default is to display the logo.
		'sanitize_callback' => 'mirrors_interior_sanitize_switch', // Sanitize using a custom switch function.
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_site_logo',
		array(
			'label'    => esc_html__( 'Enable Site Logo', 'mirrors-interior' ),
			'section'  => 'title_tagline', // Section to add this control.
			'settings' => 'mirrors_interior_enable_site_logo',
		)
	)
);

// Site Title - Enable Setting.
$wp_customize->add_setting(
	'mirrors_interior_enable_site_title_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_site_title_setting',
		array(
			'label'    => esc_html__( 'Enable Site Title', 'mirrors-interior' ),
			'section'  => 'title_tagline',
			'settings' => 'mirrors_interior_enable_site_title_setting',
		)
	)
);

$wp_customize->add_setting( 'mirrors_interior_site_title_size', array(
    'default'           => 40, // Default font size in pixels
    'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
) );

// Add control for site title size
$wp_customize->add_control( 'mirrors_interior_site_title_size', array(
    'type'        => 'number',
    'section'     => 'title_tagline', // You can change this section to your preferred section
    'label'       => __( 'Site Title Font Size ', 'mirrors-interior' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
) );

// Tagline - Enable Setting.
$wp_customize->add_setting(
	'mirrors_interior_enable_tagline_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_tagline_setting',
		array(
			'label'    => esc_html__( 'Enable Tagline', 'mirrors-interior' ),
			'section'  => 'title_tagline',
			'settings' => 'mirrors_interior_enable_tagline_setting',
		)
	)
);

$wp_customize->add_setting('mirrors_interior_site_logo_width', array(
    'default'           => 200,
    'sanitize_callback' => 'mirrors_interior_sanitize_range_value',
));

$wp_customize->add_control(new Mirrors_Interior_Customize_Range_Control($wp_customize, 'mirrors_interior_site_logo_width', array(
    'label'       => __('Adjust Site Logo Width', 'mirrors-interior'),
    'description' => __('This setting controls the Width of Site Logo', 'mirrors-interior'),
    'section'     => 'title_tagline',
    'settings'    => 'mirrors_interior_site_logo_width',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 400,
        'step' => 5,
    ),
)));
