<?php

/**
 * Single Post Options
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_single_post_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'mirrors-interior' ),
		'panel' => 'mirrors_interior_theme_options',
	)
);


// Post Options - Show / Hide Date.
$wp_customize->add_setting(
	'mirrors_interior_single_post_hide_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_single_post_hide_date',
		array(
			'label'   => esc_html__( 'Show / Hide Date', 'mirrors-interior' ),
			'section' => 'mirrors_interior_single_post_options',
		)
	)
);

// Post Options - Show / Hide Author.
$wp_customize->add_setting(
	'mirrors_interior_single_post_hide_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_single_post_hide_author',
		array(
			'label'   => esc_html__( 'Show / Hide Author', 'mirrors-interior' ),
			'section' => 'mirrors_interior_single_post_options',
		)
	)
);

// Post Options - Show / Hide Comments.
$wp_customize->add_setting(
	'mirrors_interior_single_post_hide_comments',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_single_post_hide_comments',
		array(
			'label'   => esc_html__( 'Show / Hide Comments', 'mirrors-interior' ),
			'section' => 'mirrors_interior_single_post_options',
		)
	)
);

// Post Options - Show / Hide Time.
$wp_customize->add_setting(
	'mirrors_interior_single_post_hide_time',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_single_post_hide_time',
		array(
			'label'   => esc_html__( 'Show / Hide Time', 'mirrors-interior' ),
			'section' => 'mirrors_interior_single_post_options',
		)
	)
);

// Post Options - Show / Hide Category.
$wp_customize->add_setting(
	'mirrors_interior_single_post_hide_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_single_post_hide_category',
		array(
			'label'   => esc_html__( 'Show / Hide Category', 'mirrors-interior' ),
			'section' => 'mirrors_interior_single_post_options',
		)
	)
);

// Post Options - Show / Hide Tag.
$wp_customize->add_setting(
	'mirrors_interior_post_hide_tags',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_post_hide_tags',
		array(
			'label'   => esc_html__( 'Show / Hide Tag', 'mirrors-interior' ),
			'section' => 'mirrors_interior_single_post_options',
		)
	)
);

// Post Options - Comment Title.
$wp_customize->add_setting(
	'mirrors_interior_blog_post_comment_title',
	array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'mirrors_interior_blog_post_comment_title',
	array(
		'label'	=> __('Comment Title','mirrors-interior'),
		'input_attrs' => array(
			'placeholder' => __( 'Leave a Reply', 'mirrors-interior' ),
		),
		'section'=> 'mirrors_interior_single_post_options',
		'type'=> 'text'
	)
);