<?php

/**
 * Sidebar Position
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'mirrors-interior' ),
		'panel' => 'mirrors_interior_theme_options',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_global_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_global_sidebar_separator', array(
	'label' => __( 'Global Sidebar Position', 'mirrors-interior' ),
	'section' => 'mirrors_interior_sidebar_position',
	'settings' => 'mirrors_interior_global_sidebar_separator',
)));

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'mirrors_interior_sidebar_position',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'mirrors_interior_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'mirrors-interior' ),
		'section' => 'mirrors_interior_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'mirrors-interior' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'mirrors-interior' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'mirrors-interior' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_post_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_post_sidebar_separator', array(
	'label' => __( 'Post Sidebar Position', 'mirrors-interior' ),
	'section' => 'mirrors_interior_sidebar_position',
	'settings' => 'mirrors_interior_post_sidebar_separator',
)));


// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'mirrors_interior_post_sidebar_position',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'mirrors_interior_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'mirrors-interior' ),
		'section' => 'mirrors_interior_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'mirrors-interior' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'mirrors-interior' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'mirrors-interior' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_page_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_page_sidebar_separator', array(
	'label' => __( 'Page Sidebar Position', 'mirrors-interior' ),
	'section' => 'mirrors_interior_sidebar_position',
	'settings' => 'mirrors_interior_page_sidebar_separator',
)));


// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'mirrors_interior_page_sidebar_position',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'mirrors_interior_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'mirrors-interior' ),
		'section' => 'mirrors_interior_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'mirrors-interior' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'mirrors-interior' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'mirrors-interior' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_sidebar_width_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_sidebar_width_separator', array(
	'label' => __( 'Sidebar Width Setting', 'mirrors-interior' ),
	'section' => 'mirrors_interior_sidebar_position',
	'settings' => 'mirrors_interior_sidebar_width_separator',
)));


$wp_customize->add_setting( 'mirrors_interior_sidebar_width', array(
	'default'           => '30',
	'sanitize_callback' => 'mirrors_interior_sanitize_range_value',
) );

$wp_customize->add_control(new Mirrors_Interior_Customize_Range_Control($wp_customize, 'mirrors_interior_sidebar_width', array(
	'section'     => 'mirrors_interior_sidebar_position',
	'label'       => __( 'Adjust Sidebar Width', 'mirrors-interior' ),
	'description' => __( 'Adjust the width of the sidebar.', 'mirrors-interior' ),
	'input_attrs' => array(
		'min'  => 10,
		'max'  => 50,
		'step' => 1,
	),
)));

$wp_customize->add_setting( 'mirrors_interior_sidebar_widget_font_size', array(
    'default'           => 24,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'mirrors_interior_sidebar_widget_font_size', array(
    'type'        => 'number',
    'section'     => 'mirrors_interior_sidebar_position',
    'label'       => __( 'Sidebar Widgets Heading Font Size ', 'mirrors-interior' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));