<?php

/**
 * Related Post Options
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_related_post_options',
	array(
		'title' => esc_html__( 'Related Post Options', 'mirrors-interior' ),
		'panel' => 'mirrors_interior_theme_options',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_related_post_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_related_post_separator', array(
	'label' => __( 'Enable / Disable Related Post Section', 'mirrors-interior' ),
	'section' => 'mirrors_interior_related_post_options',
	'settings' => 'mirrors_interior_related_post_separator',
) ) );

// Post Options - Show / Hide Related Posts.
$wp_customize->add_setting(
	'mirrors_interior_post_hide_related_posts',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_post_hide_related_posts',
		array(
			'label'   => esc_html__( 'Show / Hide Related Posts', 'mirrors-interior' ),
			'section' => 'mirrors_interior_related_post_options',
		)
	)
);


// Register setting for number of related posts
$wp_customize->add_setting(
	'mirrors_interior_related_posts_count',
	array(
		'default'           => 3,
		'sanitize_callback' => 'absint', // Ensure it's an integer
	)
);

// Add control for number of related posts
$wp_customize->add_control(
	'mirrors_interior_related_posts_count',
	array(
		'type'        => 'number',
		'label'       => esc_html__( 'Number of Related Posts to Display', 'mirrors-interior' ),
		'section'     => 'mirrors_interior_related_post_options',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 5, // Adjust maximum based on your preference
			'step' => 1,
		),
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'mirrors_interior_post_related_post_label',
	array(
		'default'           => 'Related Posts',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'mirrors_interior_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'mirrors-interior' ),
		'section'  => 'mirrors_interior_related_post_options',
		'settings' => 'mirrors_interior_post_related_post_label',
		'type'     => 'text',
	)
);