<?php

/**
 * Pige Title Options
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_page_title_options',
	array(
		'panel' => 'mirrors_interior_theme_options',
		'title' => esc_html__( 'Page Title', 'mirrors-interior' ),
	)
);

$wp_customize->add_setting(
    'mirrors_interior_page_header_visibility',
    array(
        'default'           => 'all-devices',
        'sanitize_callback' => 'mirrors_interior_sanitize_select',
    )
);

$wp_customize->add_control(
    new WP_Customize_Control(
        $wp_customize,
        'mirrors_interior_page_header_visibility',
        array(
            'label'    => esc_html__( 'Page Header Visibility', 'mirrors-interior' ),
            'type'     => 'select',
            'section'  => 'mirrors_interior_page_title_options',
            'settings' => 'mirrors_interior_page_header_visibility',
            'priority' => 10,
            'choices'  => array(
                'all-devices'        => esc_html__( 'Show on all devices', 'mirrors-interior' ),
                'hide-tablet'        => esc_html__( 'Hide on Tablet', 'mirrors-interior' ),
                'hide-mobile'        => esc_html__( 'Hide on Mobile', 'mirrors-interior' ),
                'hide-tablet-mobile' => esc_html__( 'Hide on Tablet & Mobile', 'mirrors-interior' ),
                'hide-all-devices'   => esc_html__( 'Hide on all devices', 'mirrors-interior' ),
            ),
        )
    )
);


$wp_customize->add_setting( 'mirrors_interior_page_title_background_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_page_title_background_separator', array(
	'label' => __( 'Page Title BG Image & Color Setting', 'mirrors-interior' ),
	'section' => 'mirrors_interior_page_title_options',
	'settings' => 'mirrors_interior_page_title_background_separator',
)));


$wp_customize->add_setting(
	'mirrors_interior_page_header_style',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => False,
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_page_header_style',
		array(
			'label'   => esc_html__('Page Title Background Image', 'mirrors-interior'),
			'section' => 'mirrors_interior_page_title_options',
		)
	)
);

$wp_customize->add_setting( 'mirrors_interior_page_header_background_image', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'mirrors_interior_page_header_background_image', array(
    'label'    => __( 'Background Image', 'mirrors-interior' ),
	'description' => __('Choose either a background image or a color. If a background image is selected, the background color will not be visible.', 'mirrors-interior'),
    'section'  => 'mirrors_interior_page_title_options',
    'settings' => 'mirrors_interior_page_header_background_image',
	'active_callback' => 'mirrors_interior_is_pagetitle_bcakground_image_enabled',
)));


$wp_customize->add_setting('mirrors_interior_page_header_image_height', array(
	'default'           => 200,
	'sanitize_callback' => 'mirrors_interior_sanitize_range_value',
));

$wp_customize->add_control(new Mirrors_Interior_Customize_Range_Control($wp_customize, 'mirrors_interior_page_header_image_height', array(
		'label'       => __('Image Height', 'mirrors-interior'),
		'section'     => 'mirrors_interior_page_title_options',
		'settings'    => 'mirrors_interior_page_header_image_height',
		'active_callback' => 'mirrors_interior_is_pagetitle_bcakground_image_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 1000,
			'step' => 5,
		),
)));


$wp_customize->add_setting('mirrors_interior_page_title_background_color_setting', array(
    'default' => '#f5f5f5',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mirrors_interior_page_title_background_color_setting', array(
    'label' => __('Page Title Background Color', 'mirrors-interior'),
    'section' => 'mirrors_interior_page_title_options',
)));

$wp_customize->add_setting('mirrors_interior_pagetitle_height', array(
    'default'           => 50,
    'sanitize_callback' => 'mirrors_interior_sanitize_range_value',
));

$wp_customize->add_control(new Mirrors_Interior_Customize_Range_Control($wp_customize, 'mirrors_interior_pagetitle_height', array(
    'label'       => __('Set Height', 'mirrors-interior'),
    'description' => __('This setting controls the page title height when no background image is set. If a background image is set, this setting will not apply.', 'mirrors-interior'),
    'section'     => 'mirrors_interior_page_title_options',
    'settings'    => 'mirrors_interior_pagetitle_height',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 300,
        'step' => 5,
    ),
)));

$wp_customize->add_setting( 'mirrors_interior_page_title_style_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_page_title_style_separator', array(
	'label' => __( 'Page Title Styling Setting', 'mirrors-interior' ),
	'section' => 'mirrors_interior_page_title_options',
	'settings' => 'mirrors_interior_page_title_style_separator',
)));


$wp_customize->add_setting( 'mirrors_interior_page_header_heading_tag', array(
	'default'   => 'h1',
	'sanitize_callback' => 'mirrors_interior_sanitize_select',
) );

$wp_customize->add_control( 'mirrors_interior_page_header_heading_tag', array(
	'label'   => __( 'Page Title Heading Tag', 'mirrors-interior' ),
	'section' => 'mirrors_interior_page_title_options',
	'type'    => 'select',
	'choices' => array(
		'h1' => __( 'H1', 'mirrors-interior' ),
		'h2' => __( 'H2', 'mirrors-interior' ),
		'h3' => __( 'H3', 'mirrors-interior' ),
		'h4' => __( 'H4', 'mirrors-interior' ),
		'h5' => __( 'H5', 'mirrors-interior' ),
		'h6' => __( 'H6', 'mirrors-interior' ),
		'p' => __( 'p', 'mirrors-interior' ),
		'a' => __( 'a', 'mirrors-interior' ),
		'div' => __( 'div', 'mirrors-interior' ),
		'span' => __( 'span', 'mirrors-interior' ),
	),
) );



$wp_customize->add_setting('mirrors_interior_page_header_layout', array(
	'default' => 'left',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('mirrors_interior_page_header_layout', array(
	'label' => __('Style', 'mirrors-interior'),
	'section' => 'mirrors_interior_page_title_options',
	'description' => __('"Flex Layout Style" wont work below 600px (mobile media)', 'mirrors-interior'),
	'settings' => 'mirrors_interior_page_header_layout',
	'type' => 'radio',
	'choices' => array(
		'left' => __('Classic', 'mirrors-interior'),
		'right' => __('Aligned Right', 'mirrors-interior'),
		'center' => __('Centered Focus', 'mirrors-interior'),
		'flex' => __('Flex Layout', 'mirrors-interior'),
	),
));