<?php

/**
 * Footer Options
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_footer_options',
	array(
		'panel' => 'mirrors_interior_theme_options',
		'title' => esc_html__( 'Footer Options', 'mirrors-interior' ),
	)
);


// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_footer_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_footer_separators', array(
	'label' => __( 'Footer Settings', 'mirrors-interior' ),
	'section' => 'mirrors_interior_footer_options',
	'settings' => 'mirrors_interior_footer_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'mirrors_interior_enable_footer_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_footer_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer', 'mirrors-interior' ),
			'section'  => 'mirrors_interior_footer_options',
			'settings' => 'mirrors_interior_enable_footer_section',
		)
	)
);

// column // 
$wp_customize->add_setting(
	'mirrors_interior_footer_widget_column',
	array(
        'default'			=> '4',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
		
	)
);	

$wp_customize->add_control(
	'mirrors_interior_footer_widget_column',
	array(
	    'label'   		=> __('Select Widget Column','mirrors-interior'),
		'description' => __('Note: Default footer widgets are shown. Add your preferred widgets in (Appearance > Widgets > Footer) to see changes.', 'mirrors-interior'),
	    'section' 		=> 'mirrors_interior_footer_options',
		'type'			=> 'select',
		'choices'        => 
		array(
			'' => __( 'None', 'mirrors-interior' ),
			'1' => __( '1 Column', 'mirrors-interior' ),
			'2' => __( '2 Column', 'mirrors-interior' ),
			'3' => __( '3 Column', 'mirrors-interior' ),
			'4' => __( '4 Column', 'mirrors-interior' )
		) 
	) 
);

//  BG Color // 
$wp_customize->add_setting('mirrors_interior_footer_background_color_setting', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'mirrors_interior_footer_background_color_setting', array(
    'label' => __('Footer Background Color', 'mirrors-interior'),
    'section' => 'mirrors_interior_footer_options',
)));

// Footer Background Image Setting
$wp_customize->add_setting('mirrors_interior_footer_background_image_setting', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'mirrors_interior_footer_background_image_setting', array(
    'label' => __('Footer Background Image', 'mirrors-interior'),
    'section' => 'mirrors_interior_footer_options',
)));

// Footer Background Attachment
$wp_customize->add_setting(
	'mirrors_interior_footer_image_attachment_setting',
	array(
		'default'=> 'scroll',
		'sanitize_callback' => 'mirrors_interior_sanitize_choices'
	)
);

$wp_customize->add_control(
	'mirrors_interior_footer_image_attachment_setting',
	array(
		'type' => 'select',
		'label' => __('Footer Background Attatchment','mirrors-interior'),
		'choices' => array(
			'fixed' => __('fixed','mirrors-interior'),
			'scroll' => __('scroll','mirrors-interior'),
		),
		'section'=> 'mirrors_interior_footer_options',
  	)
);

$wp_customize->add_setting('mirrors_interior_footer_text_transform', array(
    'default' => 'none',
    'sanitize_callback' => 'sanitize_text_field',
));

// Add Footer Heading Text Transform Control
$wp_customize->add_control('mirrors_interior_footer_text_transform', array(
    'label' => __('Footer Heading Text Transform', 'mirrors-interior'),
    'section' => 'mirrors_interior_footer_options',
    'settings' => 'mirrors_interior_footer_text_transform',
    'type' => 'select',
    'choices' => array(
        'none' => __('None', 'mirrors-interior'),
        'capitalize' => __('Capitalize', 'mirrors-interior'),
        'uppercase' => __('Uppercase', 'mirrors-interior'),
        'lowercase' => __('Lowercase', 'mirrors-interior'),
    ),
));

// Footer Heading Alignment
$wp_customize->add_setting(
	'mirrors_interior_footer_header_align',
	array(
		'default' 			=> 'left',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'mirrors_interior_footer_header_align',
	array(
		'label' => __('Footer Heading Alignment ','mirrors-interior'),
		'section' => 'mirrors_interior_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','mirrors-interior'),
			'right' => __('Right','mirrors-interior'),
			'center' => __('Center','mirrors-interior'),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_copyright_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_copyright_separators', array(
	'label' => __( 'Copyright Settings', 'mirrors-interior' ),
	'section' => 'mirrors_interior_footer_options',
	'settings' => 'mirrors_interior_copyright_separators',
)));

// Copyright Section - Enable Section.
$wp_customize->add_setting(
	'mirrors_interior_enable_copyright_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_copyright_section',
		array(
			'label'    => esc_html__( 'Show / Hide Copyright', 'mirrors-interior' ),
			'section'  => 'mirrors_interior_footer_options',
			'settings' => 'mirrors_interior_enable_copyright_section',
		)
	)
);

$wp_customize->add_setting(
	'mirrors_interior_footer_copyright_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'mirrors_interior_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'mirrors-interior' ),
		'section'  => 'mirrors_interior_footer_options',
		'settings' => 'mirrors_interior_footer_copyright_text',
		'type'     => 'textarea',
	)
);

//Copyright Alignment
$wp_customize->add_setting(
	'mirrors_interior_footer_bottom_align',
	array(
		'default' 			=> 'center',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'mirrors_interior_footer_bottom_align',
	array(
		'label' => __('Copyright Alignment ','mirrors-interior'),
		'section' => 'mirrors_interior_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','mirrors-interior'),
			'right' => __('Right','mirrors-interior'),
			'center' => __('Center','mirrors-interior'),
		),
	)
);

//Copyright Font Size
$wp_customize->add_setting( 
	'mirrors_interior_copyright_font_size', 
	array(
		'default'           => 16,
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'mirrors_interior_copyright_font_size', 
	array(
		'type'        => 'number',
		'section'     => 'mirrors_interior_footer_options',
		'label'       => __( 'Copyright Font Size ', 'mirrors-interior' ),
		'input_attrs' => 
		array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'mirrors_interior_scroll_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Mirrors_Interior_Separator_Custom_Control( $wp_customize, 'mirrors_interior_scroll_separators', array(
	'label' => __( 'Scroll Top Settings', 'mirrors-interior' ),
	'section' => 'mirrors_interior_footer_options',
	'settings' => 'mirrors_interior_scroll_separators',
)));


// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'mirrors_interior_scroll_top',
	array(
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'mirrors-interior' ),
			'section' => 'mirrors_interior_footer_options',
		)
	)
);
// icon // 
$wp_customize->add_setting(
	'mirrors_interior_scroll_btn_icon',
	array(
        'default' => 'fas fa-chevron-up',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Mirrors_Interior_Change_Icon_Control($wp_customize, 
	'mirrors_interior_scroll_btn_icon',
	array(
	    'label'   		=> __('Scroll Top Icon','mirrors-interior'),
	    'section' 		=> 'mirrors_interior_footer_options',
		'iconset' => 'fa',
	))  
);
$wp_customize->add_setting( 'mirrors_interior_scroll_top_position', array(
    'default'           => 'bottom-right',
    'sanitize_callback' => 'mirrors_interior_sanitize_scroll_top_position',
) );

// Add control for Scroll Top Button Position
$wp_customize->add_control( 'mirrors_interior_scroll_top_position', array(
    'label'    => __( 'Scroll Top Button Position', 'mirrors-interior' ),
    'section'  => 'mirrors_interior_footer_options',
    'settings' => 'mirrors_interior_scroll_top_position',
    'type'     => 'select',
    'choices'  => array(
        'bottom-right' => __( 'Bottom Right', 'mirrors-interior' ),
        'bottom-left'  => __( 'Bottom Left', 'mirrors-interior' ),
        'bottom-center'=> __( 'Bottom Center', 'mirrors-interior' ),
    ),
) );

$wp_customize->add_setting( 'mirrors_interior_scroll_top_position', array(
    'default'           => 'bottom-right',
    'sanitize_callback' => 'mirrors_interior_sanitize_scroll_top_position',
) );

// Add control for Scroll Top Button Position
$wp_customize->add_control( 'mirrors_interior_scroll_top_position', array(
    'label'    => __( 'Scroll Top Button Position', 'mirrors-interior' ),
    'section'  => 'mirrors_interior_footer_options',
    'settings' => 'mirrors_interior_scroll_top_position',
    'type'     => 'select',
    'choices'  => array(
        'bottom-right' => __( 'Bottom Right', 'mirrors-interior' ),
        'bottom-left'  => __( 'Bottom Left', 'mirrors-interior' ),
        'bottom-center'=> __( 'Bottom Center', 'mirrors-interior' ),
    ),
) );

$wp_customize->add_setting( 'mirrors_interior_scroll_top_shape', array(
	'default'           => 'box',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'mirrors_interior_scroll_top_shape', array(
	'label'    => __( 'Scroll to Top Button Shape', 'mirrors-interior' ),
	'section'  => 'mirrors_interior_footer_options',
	'settings' => 'mirrors_interior_scroll_top_shape',
	'type'     => 'radio',
	'choices'  => array(
		'box'        => __( 'Box', 'mirrors-interior' ),
		'curved-box' => __( 'Curved Box', 'mirrors-interior' ),
		'circle'     => __( 'Circle', 'mirrors-interior' ),
	),
) );