<?php

/**
 * Excerpt
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_excerpt_options',
	array(
		'panel' => 'mirrors_interior_theme_options',
		'title' => esc_html__( 'Excerpt', 'mirrors-interior' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'mirrors_interior_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'absint',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'mirrors_interior_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'mirrors-interior' ),
		'section'     => 'mirrors_interior_excerpt_options',
		'settings'    => 'mirrors_interior_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'max'  => 200,
			'step' => 1,
		),
	)
);