<?php

function mirrors_interior_sanitize_select( $mirrors_interior_input, $mirrors_interior_setting ) {
	$mirrors_interior_input = sanitize_key( $mirrors_interior_input );
	$mirrors_interior_choices = $mirrors_interior_setting->manager->get_control( $mirrors_interior_setting->id )->choices;
	return ( array_key_exists( $mirrors_interior_input, $mirrors_interior_choices ) ? $mirrors_interior_input : $mirrors_interior_setting->default );
}

function mirrors_interior_sanitize_switch( $mirrors_interior_input ) {
	if ( true === $mirrors_interior_input ) {
		return true;
	} else {
		return false;
	}
}

function mirrors_interior_sanitize_google_fonts( $mirrors_interior_input, $mirrors_interior_setting ) {
    $mirrors_interior_choices = $mirrors_interior_setting->manager->get_control( $mirrors_interior_setting->id )->choices;
    return ( array_key_exists( $mirrors_interior_input, $mirrors_interior_choices ) ? $mirrors_interior_input : $mirrors_interior_setting->default );
}

/**
 * Sanitize HTML input.
 *
 * @param string $mirrors_interior_input HTML input to sanitize.
 * @return string Sanitized HTML.
 */
function mirrors_interior_sanitize_html( $mirrors_interior_input ) {
    return wp_kses_post( $mirrors_interior_input );
}

/**
 * Sanitize URL input.
 *
 * @param string $mirrors_interior_input URL input to sanitize.
 * @return string Sanitized URL.
 */
function mirrors_interior_sanitize_url( $mirrors_interior_input ) {
    return esc_url_raw( $mirrors_interior_input );
}

// Sanitize Scroll Top Position
function mirrors_interior_sanitize_scroll_top_position( $mirrors_interior_input ) {
    $mirrors_interior_valid_positions = array( 'bottom-right', 'bottom-left', 'bottom-center' );
    if ( in_array( $mirrors_interior_input, $mirrors_interior_valid_positions ) ) {
        return $mirrors_interior_input;
    } else {
        return 'bottom-right'; // Default to bottom-right if invalid value
    }
}

function mirrors_interior_sanitize_choices( $mirrors_interior_input, $mirrors_interior_setting ) {
    global $wp_customize; 
    $mirrors_interior_control = $wp_customize->get_control( $mirrors_interior_setting->id ); 
    if ( array_key_exists( $mirrors_interior_input, $mirrors_interior_control->choices ) ) {
        return $mirrors_interior_input;
    } else {
        return $mirrors_interior_setting->default;
    }
}

function mirrors_interior_sanitize_range_value( $mirrors_interior_number, $mirrors_interior_setting ) {

	// Ensure input is an absolute integer.
	$mirrors_interior_number = absint( $mirrors_interior_number );

	// Get the input attributes associated with the setting.
	$mirrors_interior_atts = $mirrors_interior_setting->manager->get_control( $mirrors_interior_setting->id )->input_attrs;

	// Get minimum number in the range.
	$mirrors_interior_min = ( isset( $mirrors_interior_atts['min'] ) ? $mirrors_interior_atts['min'] : $mirrors_interior_number );

	// Get maximum number in the range.
	$mirrors_interior_max = ( isset( $mirrors_interior_atts['max'] ) ? $mirrors_interior_atts['max'] : $mirrors_interior_number );

	// Get step.
	$mirrors_interior_step = ( isset( $mirrors_interior_atts['step'] ) ? $mirrors_interior_atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default.
	return ( $mirrors_interior_min <= $mirrors_interior_number && $mirrors_interior_number <= $mirrors_interior_max && is_int( $mirrors_interior_number / $mirrors_interior_step ) ? $mirrors_interior_number : $mirrors_interior_setting->default );
}