<?php

/**
 * Service Section
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_product_section',
	array(
		'panel'    => 'mirrors_interior_front_page_options',
		'title'    => esc_html__( 'Mirrors Product Section', 'mirrors-interior' ),
		'priority' => 10,
	)
);

// Service Section - Enable Section.
$wp_customize->add_setting(
	'mirrors_interior_enable_service_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_service_section',
		array(
			'label'    => esc_html__( 'Enable Mirrors Product Section', 'mirrors-interior' ),
			'section'  => 'mirrors_interior_product_section',
			'settings' => 'mirrors_interior_enable_service_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'mirrors_interior_enable_service_section',
		array(
			'selector' => '#mirrors_interior_service_section .section-link',
			'settings' => 'mirrors_interior_enable_service_section',
		)
	);
}

// Service Section - Button Label.
$wp_customize->add_setting(
	'mirrors_interior_trending_product_heading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'mirrors_interior_trending_product_heading',
	array(
		'label'           => esc_html__( 'Heading', 'mirrors-interior' ),
		'section'         => 'mirrors_interior_product_section',
		'settings'        => 'mirrors_interior_trending_product_heading',
		'type'            => 'text',
		'active_callback' => 'mirrors_interior_is_service_section_enabled',
	)
);

if(class_exists('woocommerce')){

	$args = array(
		'type'                     => 'product',
		'child_of'                 => 0,
		'parent'                   => '',
		'orderby'                  => 'term_group',
		'order'                    => 'ASC',
		'hide_empty'               => false,
		'hierarchical'             => 1,
		'number'                   => '',
		'taxonomy'                 => 'product_cat',
		'pad_counts'               => false
	);
	$mirrors_interior_categories = get_categories($args);
	$mirrors_interior_cat_posts = array();
	$mirrors_interior_m = 0;
	$mirrors_interior_cat_posts[]='Select';
	foreach($mirrors_interior_categories as $mirrors_interior_category){
		if($mirrors_interior_m==0){
			$mirrors_interior_default = $mirrors_interior_category->slug;
			$mirrors_interior_m++;
		}
		$mirrors_interior_cat_posts[$mirrors_interior_category->slug] = $mirrors_interior_category->name;
	}

	$wp_customize->add_setting('mirrors_interior_trending_product_category',array(
		'default'	=> 'uncategorized',
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
	));
	$wp_customize->add_control('mirrors_interior_trending_product_category',array(
		'type'    => 'select',
		'choices' => $mirrors_interior_cat_posts,
		'label' => __('Select category to display products ','mirrors-interior'),
		'section' => 'mirrors_interior_product_section',
		'active_callback' => 'mirrors_interior_is_service_section_enabled',
	));
}