<?php

/**
 * Banner Section
 *
 * @package mirrors_interior
 */

$wp_customize->add_section(
	'mirrors_interior_banner_section',
	array(
		'panel'    => 'mirrors_interior_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'mirrors-interior' ),
		'priority' => 10,
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'mirrors_interior_enable_banner_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'mirrors_interior_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Mirrors_Interior_Toggle_Switch_Custom_Control(
		$wp_customize,
		'mirrors_interior_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'mirrors-interior' ),
			'section'  => 'mirrors_interior_banner_section',
			'settings' => 'mirrors_interior_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'mirrors_interior_enable_banner_section',
		array(
			'selector' => '#mirrors_interior_banner_section .section-link',
			'settings' => 'mirrors_interior_enable_banner_section',
		)
	);
}

// Banner Section - Banner Slider Content Type.
$wp_customize->add_setting(
	'mirrors_interior_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'mirrors_interior_sanitize_select',
	)
);

$wp_customize->add_control(
	'mirrors_interior_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Select Banner Slider Content Type', 'mirrors-interior' ),
		'section'         => 'mirrors_interior_banner_section',
		'settings'        => 'mirrors_interior_banner_slider_content_type',
		'type'            => 'select',
		'active_callback' => 'mirrors_interior_is_banner_slider_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'mirrors-interior' ),
			'post' => esc_html__( 'Post', 'mirrors-interior' ),
		),
	)
);

for ( $mirrors_interior_i = 1; $mirrors_interior_i <= 3; $mirrors_interior_i++ ) {

	// Banner Section - Select Banner Post.
	$wp_customize->add_setting(
		'mirrors_interior_banner_slider_content_post_' . $mirrors_interior_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'mirrors_interior_banner_slider_content_post_' . $mirrors_interior_i,
		array(
			/* translators: %d: Select Post Count. */
			'label'           => sprintf( esc_html__( 'Select Post %d', 'mirrors-interior' ), $mirrors_interior_i ),
			'section'         => 'mirrors_interior_banner_section',
			'settings'        => 'mirrors_interior_banner_slider_content_post_' . $mirrors_interior_i,
			'active_callback' => 'mirrors_interior_is_banner_slider_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => mirrors_interior_get_post_choices(),
		)
	);

	// Banner Section - Select Banner Page.
	$wp_customize->add_setting(
		'mirrors_interior_banner_slider_content_page_' . $mirrors_interior_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'mirrors_interior_banner_slider_content_page_' . $mirrors_interior_i,
		array(
			/* translators: %d: Select Page Count. */
			'label'           => sprintf( esc_html__( 'Select Page %d', 'mirrors-interior' ), $mirrors_interior_i ),
			'section'         => 'mirrors_interior_banner_section',
			'settings'        => 'mirrors_interior_banner_slider_content_page_' . $mirrors_interior_i,
			'active_callback' => 'mirrors_interior_is_banner_slider_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => mirrors_interior_get_page_choices(),
		)
	);

	// Banner Section - Button Label.
	$wp_customize->add_setting(
		'mirrors_interior_banner_button_label_' . $mirrors_interior_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'mirrors_interior_banner_button_label_' . $mirrors_interior_i,
		array(
			/* translators: %d: Button Label Count. */
			'label'           => sprintf( esc_html__( 'Button Label %d', 'mirrors-interior' ), $mirrors_interior_i ),
			'section'         => 'mirrors_interior_banner_section',
			'settings'        => 'mirrors_interior_banner_button_label_' . $mirrors_interior_i,
			'type'            => 'text',
			'active_callback' => 'mirrors_interior_is_banner_slider_section_enabled',
		)
	);

	// Banner Section - Button Link.
	$wp_customize->add_setting(
		'mirrors_interior_banner_button_link_' . $mirrors_interior_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'mirrors_interior_banner_button_link_' . $mirrors_interior_i,
		array(
			/* translators: %d: Button Link Count. */
			'label'           => sprintf( esc_html__( 'Button Link %d', 'mirrors-interior' ), $mirrors_interior_i ),
			'section'         => 'mirrors_interior_banner_section',
			'settings'        => 'mirrors_interior_banner_button_link_' . $mirrors_interior_i,
			'type'            => 'url',
			'active_callback' => 'mirrors_interior_is_banner_slider_section_enabled',
		)
	);
}