<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package mirrors_interior
 */

function mirrors_interior_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'mirrors_interior_custom_header_args', array(
		'default-text-color'     => '000',
		'header-text' 			 =>	false,
		'width'                  => 1360,
		'height'                 => 110,
		'flex-width'         	 => true,
        'flex-height'        	 => true,
		'wp-head-callback'       => 'mirrors_interior_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'mirrors_interior_custom_header_setup' );

if ( ! function_exists( 'mirrors_interior_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'mirrors_interior_header_style' );
function mirrors_interior_header_style() {

	if ( get_header_image() ) :
		$mirrors_interior_custom_css = "
        .header-background-image {
            background-image: url('".esc_url(get_header_image())."') !important;
            background-position: center;
            background-size: cover;
            height: 200px; /* Your custom height */
        }
        .bottom-header-outer-wrapper {
            position: absolute;
            width: 100%;
            z-index: 9999;
        }
		.bottom-header-outer-wrapper {
			background-color: transparent;
		}
		@media only screen and (max-width: 600px) {
			.header-background-image {
				display:none;
			}
			.bottom-header-outer-wrapper {
				position: relative;
			}
			.bottom-header-outer-wrapper {
				background-color: #000;
			}
		}
		";
	   	wp_add_inline_style( 'mirrors-interior-style', $mirrors_interior_custom_css );
	endif;
}
endif;