<?php

if ( ! get_theme_mod( 'mirrors_interior_enable_service_section', false ) ) {
	return;
}

$mirrors_interior_args = '';

mirrors_interior_render_service_section( $mirrors_interior_args );

/**
 * Render Service Section.
 */
function mirrors_interior_render_service_section( $mirrors_interior_args ) { ?>
		<section id="mirrors_interior_trending_section" class="asterthemes-frontpage-section trending-section trending-style-1">
		<?php
		if ( is_customize_preview() ) :
			mirrors_interior_section_link( 'mirrors_interior_service_section' );
		endif;

		$mirrors_interior_trending_product_heading = get_theme_mod( 'mirrors_interior_trending_product_heading');
		?>
		<div class="asterthemes-wrapper">
			<?php if ( ! empty( $mirrors_interior_trending_product_heading ) ) { ?>
				<div class="header-contact-inner">
					<h3><?php echo esc_html( $mirrors_interior_trending_product_heading ); ?></h3>
				</div>
			<?php } ?>
			<?php $mirrors_interior_catData = get_theme_mod('mirrors_interior_trending_product_category','uncategorized');
      if ( class_exists( 'WooCommerce' ) ) {
        $mirrors_interior_args = array(
          'post_type' => 'product',
          'posts_per_page' => 4,
          'product_cat' => $mirrors_interior_catData,
          'order' => 'ASC'
        );?>
        <div class="product-box"> 
	        <?php $mirrors_interior_loop = new WP_Query( $mirrors_interior_args );
	        while ( $mirrors_interior_loop->have_posts() ) : $mirrors_interior_loop->the_post(); global $product; ?>
	          <div class="tab-product">
            	<figure>
              	<?php if (has_post_thumbnail( $mirrors_interior_loop->post->ID )) echo get_the_post_thumbnail($mirrors_interior_loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(wc_placeholder_img_src()).'" />'; ?>
              	<?php if ( has_post_thumbnail() ) { ?>
                    <?php woocommerce_show_product_sale_flash( $product ); ?>
                <?php }?>
                <div class="box-content intro-button">
              		<?php if( $product->is_type( 'simple' ) ) { woocommerce_template_loop_add_to_cart(  $mirrors_interior_loop->post, $product );} ?>
          			</div>
              </figure>
        			<?php if( $product->is_type( 'simple' ) ){ woocommerce_template_loop_rating( $mirrors_interior_loop->post, $product ); } ?>
          			<h5 class="product-text"><a href="<?php echo esc_url(get_permalink( $mirrors_interior_loop->post->ID )); ?>"><?php the_title(); ?></a></h5>
        			<h6 class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?>"><?php echo $product->get_price_html(); ?></h6>
	          </div>
	        <?php endwhile; wp_reset_query(); ?>
	      </div>
      <?php } ?>
		</div>
	</section>
	<?php
}