<?php
if ( ! get_theme_mod( 'mirrors_interior_enable_banner_section', true ) ) {
	return;
}

$mirrors_interior_slider_content_ids  = array();
$mirrors_interior_slider_content_type = get_theme_mod( 'mirrors_interior_banner_slider_content_type', 'post' );

for ( $mirrors_interior_i = 1; $mirrors_interior_i <= 3; $mirrors_interior_i++ ) {
	$mirrors_interior_slider_content_ids[] = get_theme_mod( 'mirrors_interior_banner_slider_content_' . $mirrors_interior_slider_content_type . '_' . $mirrors_interior_i );
}
$mirrors_interior_banner_slider_args = array(
	'post_type'           => $mirrors_interior_slider_content_type,
	'post__in'            => array_filter( $mirrors_interior_slider_content_ids ),
	'orderby'             => 'post__in',
	'posts_per_page'      => absint( 3 ),
	'ignore_sticky_posts' => true,
);
$mirrors_interior_banner_slider_args = apply_filters( 'mirrors_interior_banner_section_args', $mirrors_interior_banner_slider_args );

mirrors_interior_render_banner_section( $mirrors_interior_banner_slider_args );

/**
 * Render Banner Section.
 */
function mirrors_interior_render_banner_section( $mirrors_interior_banner_slider_args ) {     ?>

	<section id="mirrors_interior_banner_section" class="banner-section banner-style-1">
		<?php
		if ( is_customize_preview() ) :
			mirrors_interior_section_link( 'mirrors_interior_banner_section' );
		endif;
		?>
		<div class="banner-section-wrapper">
			<?php
			$mirrors_interior_query = new WP_Query( $mirrors_interior_banner_slider_args );
			if ( $mirrors_interior_query->have_posts() ) :
				?>
				<div class="asterthemes-banner-wrapper banner-slider mirrors-interior-carousel-navigation" data-slick='{"autoplay": false }'>
					<?php
					$mirrors_interior_i = 1;
					while ( $mirrors_interior_query->have_posts() ) :
						$mirrors_interior_query->the_post();
						$mirrors_interior_button_label = get_theme_mod( 'mirrors_interior_banner_button_label_' . $mirrors_interior_i);
						$mirrors_interior_button_link  = get_theme_mod( 'mirrors_interior_banner_button_link_' . $mirrors_interior_i);
						$mirrors_interior_button_link  = ! empty( $mirrors_interior_button_link ) ? $mirrors_interior_button_link : get_the_permalink();
						?>
						<div class="banner-single-outer">
							<div class="banner-single">
								<div class="banner-img">
									<?php 
									if ( has_post_thumbnail() ) {
										the_post_thumbnail( 'full' );
									} else {
										echo '<img src="' . esc_url( get_template_directory_uri() ) . '/resource/img/banner.png" alt="Default Image">';
									}
									?>
								</div>
								<div class="banner-caption">
									<div class="asterthemes-wrapper">
										<div class="banner-catption-wrapper">
											<h1 class="banner-caption-title">
											    <?php 
											    $title = get_the_title(); 
											    $mirrors_interior_title_words = explode(' ', $title);
											    $mirrors_interior_last_word = array_pop($mirrors_interior_title_words);
											    $title_without_last_word = implode(' ', $mirrors_interior_title_words);
											    echo $title_without_last_word . ' <span class="last-word">' . $mirrors_interior_last_word . '</span>';
											    ?>
											</h1>
											<?php if ( ! empty( $mirrors_interior_button_label ) ) { ?>
												<div class="banner-slider-btn">
													<a href="<?php echo esc_url( $mirrors_interior_button_link ); ?>" class="asterthemes-button"><?php echo esc_html( $mirrors_interior_button_label ); ?></a>
												</div>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
						$mirrors_interior_i++;
					endwhile;
					wp_reset_postdata();
					?>
				</div>
				<?php
			endif;
			?>
		</div>
	</section>

	<?php
}